/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.testng.annotations.Test;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Test(groups={"functional"})
public class XmlConfigurationSchemaTest {
    public static final String BASE_DIR_FOR_CONFIG = "./configs";
    private String[] testFiles = new String[]{"buddy-replication-cache.xml", "clonable-config.xml", "local-lru-eviction.xml", "local-passivation.xml", "local-tx.xml", "mixedPolicy-eviction.xml", "mux.xml", "parser-test.xml", "parser-test-async.xml", "policyPerRegion-eviction.xml", "replSync.xml", "string-property-replaced.xml", "mvcc-repl-sync-br.xml"};

    public void testSimpleFile() {
        ExceptionCountingErrorHandler handler = new ExceptionCountingErrorHandler();
        System.setProperty("jbosscache.config.schemaLocation", "src/main/resources/jbosscache-config-3.0.xsd");
        XmlConfigurationParser parser = new XmlConfigurationParser((ErrorHandler)handler);
        for (String file : this.testFiles) {
            System.out.println("file = " + file);
            parser.parseFile(BASE_DIR_FOR_CONFIG + File.separator + file);
            System.out.println("Processed file = " + file);
            for (SAXParseException e : handler.exceptionList) {
                e.printStackTrace();
            }
            assert (handler.noErrors()) : "error during parsing (file " + file + ")";
        }
    }

    public void testValidationDisbaledOnSystemProperty() {
        XmlConfigurationParser parser = new XmlConfigurationParser();
        assert (parser.isValidating()) : "by default we have a validating parser";
        System.setProperty("jbosscache.config.validate", "false");
        parser = new XmlConfigurationParser();
        assert (!parser.isValidating());
        System.setProperty("jbosscache.config.validate", "true");
        parser = new XmlConfigurationParser();
        assert (parser.isValidating());
    }

    public static class ExceptionCountingErrorHandler
    implements ErrorHandler {
        List<SAXParseException> exceptionList = new ArrayList<SAXParseException>();

        public void warning(SAXParseException exception) throws SAXException {
            this.handleDefault(exception);
        }

        public void error(SAXParseException exception) throws SAXException {
            this.handleDefault(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.handleDefault(exception);
        }

        private void handleDefault(SAXParseException exception) {
            System.out.println("Error :" + exception.getMessage());
            this.exceptionList.add(exception);
        }

        public boolean noErrors() {
            return this.exceptionList.isEmpty();
        }
    }
}

