/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.element.EvictionElementParser;
import org.jboss.cache.eviction.ElementSizeAlgorithmConfig;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"unit"}, sequential=false)
public class ElementSizeConfigurationTest {
    public void testXMLParse1() throws Exception {
        ElementSizeAlgorithmConfig config = new ElementSizeAlgorithmConfig();
        String xml = "<region name=\"abc\"><property name=\"maxNodes\" value=\"1000\"></property><property name=\"maxElementsPerNode\" value=\"100\"></property></region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)config);
        config.validate();
        AssertJUnit.assertEquals((int)100, (int)config.getMaxElementsPerNode());
        AssertJUnit.assertEquals((int)1000, (int)config.getMaxNodes());
    }

    public void testXMLParse2() throws Exception {
        ElementSizeAlgorithmConfig config = new ElementSizeAlgorithmConfig();
        String xml = "<region name=\"abc\"><property name=\"maxNodes\" value=\"1000\"></property></region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)config);
        config.validate();
        assert (config.getMaxElementsPerNode() == -1);
    }

    public void testXMLParse3() throws Exception {
        ElementSizeAlgorithmConfig config = new ElementSizeAlgorithmConfig();
        String xml = "<region name=\"abc\"><property name=\"maxElementsPerNode\" value=\"100\"></property></region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)config);
        config.validate();
        AssertJUnit.assertEquals((int)100, (int)config.getMaxElementsPerNode());
        AssertJUnit.assertEquals((int)-1, (int)config.getMaxNodes());
    }
}

