/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.FIFOAlgorithmConfig;
import org.jboss.cache.eviction.LFUAlgorithmConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.eviction.MRUAlgorithmConfig;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"unit"}, sequential=false)
public class EvictionConfigurationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPolicyPerRegion() throws Exception {
        CacheSPI<Object, Object> cache = null;
        RegionManager regionManager = null;
        try {
            cache = this.setupCache("configs/policyPerRegion-eviction.xml");
            regionManager = cache.getRegionManager();
            AssertJUnit.assertEquals((long)5000L, (long)cache.getConfiguration().getEvictionConfig().getWakeupInterval());
            Region region = regionManager.getRegion("/org/jboss/data", true);
            EvictionRegionConfig evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/org/jboss/data"), (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof LFUAlgorithmConfig));
            AssertJUnit.assertEquals((int)5000, (int)((LFUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            AssertJUnit.assertEquals((int)1000, (int)((LFUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMinNodes());
            region = regionManager.getRegion("/org/jboss/test/data", true);
            evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/org/jboss/test/data"), (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof FIFOAlgorithmConfig));
            AssertJUnit.assertEquals((int)5, (int)((FIFOAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            region = regionManager.getRegion("/test", true);
            evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/test"), (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof MRUAlgorithmConfig));
            AssertJUnit.assertEquals((int)10000, (int)((MRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            region = regionManager.getRegion("/maxAgeTest", true);
            evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/maxAgeTest"), (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig));
            AssertJUnit.assertEquals((int)10000, (int)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            AssertJUnit.assertEquals((long)8000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getTimeToLive());
            AssertJUnit.assertEquals((long)10000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxAge());
            region = regionManager.getRegion("/a/b/c", false);
            evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.ROOT, (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig));
            AssertJUnit.assertEquals((int)5000, (int)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            AssertJUnit.assertEquals((long)1000000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getTimeToLive());
            AssertJUnit.assertEquals((long)-1L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxAge());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            TestingUtil.killCaches(new Cache[]{cache});
            throw throwable;
        }
        TestingUtil.killCaches(new Cache[]{cache});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMixedPolicies() throws Exception {
        CacheSPI<Object, Object> cache = null;
        RegionManager regionManager = null;
        try {
            cache = this.setupCache("configs/mixedPolicy-eviction.xml");
            regionManager = cache.getRegionManager();
            AssertJUnit.assertEquals((long)5000L, (long)cache.getConfiguration().getEvictionConfig().getWakeupInterval());
            Region region = regionManager.getRegion("/org/jboss/data", true);
            EvictionRegionConfig evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/org/jboss/data/"), (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof FIFOAlgorithmConfig));
            AssertJUnit.assertEquals((int)5000, (int)((FIFOAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            region = regionManager.getRegion("/test", true);
            evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/test/"), (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof MRUAlgorithmConfig));
            AssertJUnit.assertEquals((int)10000, (int)((MRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            region = regionManager.getRegion("/a/b/c", false);
            evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.ROOT, (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig));
            AssertJUnit.assertEquals((int)5000, (int)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            AssertJUnit.assertEquals((long)1000000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getTimeToLive());
            AssertJUnit.assertEquals((long)-1L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxAge());
            region = regionManager.getRegion("/maxAgeTest", false);
            evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/maxAgeTest/"), (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig));
            AssertJUnit.assertEquals((int)10000, (int)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            AssertJUnit.assertEquals((long)8000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getTimeToLive());
            AssertJUnit.assertEquals((long)10000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxAge());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            TestingUtil.killCaches(new Cache[]{cache});
            throw throwable;
        }
        TestingUtil.killCaches(new Cache[]{cache});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLegacyPolicyConfiguration() throws Exception {
        CacheSPI<Object, Object> cache = null;
        RegionManager regionManager = null;
        try {
            cache = this.setupCache("configs/local-lru-eviction.xml");
            regionManager = cache.getRegionManager();
            AssertJUnit.assertEquals((long)5000L, (long)cache.getConfiguration().getEvictionConfig().getWakeupInterval());
            Region region = regionManager.getRegion("/org/jboss/data", false);
            EvictionRegionConfig evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/org/jboss/data/"), (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig));
            AssertJUnit.assertEquals((int)5000, (int)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            AssertJUnit.assertEquals((long)1000000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getTimeToLive());
            region = regionManager.getRegion("/org/jboss/test/data", false);
            evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/org/jboss/test/data/"), (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig));
            AssertJUnit.assertEquals((int)5, (int)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            AssertJUnit.assertEquals((long)4000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getTimeToLive());
            region = regionManager.getRegion("/test", true);
            evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/test/"), (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig));
            AssertJUnit.assertEquals((int)10000, (int)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            AssertJUnit.assertEquals((long)4000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getTimeToLive());
            region = regionManager.getRegion("/maxAgeTest", true);
            evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.fromString((String)"/maxAgeTest/"), (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig));
            AssertJUnit.assertEquals((int)10000, (int)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            AssertJUnit.assertEquals((long)8000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getTimeToLive());
            AssertJUnit.assertEquals((long)10000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxAge());
            region = regionManager.getRegion("/a/b/c", false);
            evictionRegionConfig = region.getEvictionRegionConfig();
            AssertJUnit.assertEquals((Object)Fqn.ROOT, (Object)region.getFqn());
            AssertJUnit.assertTrue((boolean)(evictionRegionConfig.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig));
            AssertJUnit.assertEquals((int)5000, (int)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxNodes());
            AssertJUnit.assertEquals((long)1000000L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getTimeToLive());
            AssertJUnit.assertEquals((long)-1L, (long)((LRUAlgorithmConfig)evictionRegionConfig.getEvictionAlgorithmConfig()).getMaxAge());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            TestingUtil.killCaches(new Cache[]{cache});
            throw throwable;
        }
        TestingUtil.killCaches(new Cache[]{cache});
    }

    public void testTwoCacheInstanceConfiguration() throws Exception {
        this.setupCache("configs/local-lru-eviction.xml");
        this.setupCache("configs/local-lru-eviction.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoEviction() throws Exception {
        CacheSPI cache = null;
        RegionManager regionManager = null;
        try {
            cache = (CacheSPI)new UnitTestCacheFactory().createCache();
            regionManager = cache.getRegionManager();
            AssertJUnit.assertEquals((int)0, (int)regionManager.getAllRegions(Region.Type.ANY).size());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            TestingUtil.killCaches(new Cache[]{cache});
            throw throwable;
        }
        TestingUtil.killCaches(new Cache[]{cache});
    }

    private CacheSPI<Object, Object> setupCache(String configurationName) {
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(configurationName, false);
        cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        cache.start();
        return cache;
    }
}

