/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.FIFOAlgorithmConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionController;
import org.jboss.cache.util.internals.EvictionWatcher;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class FIFOPolicyTest
extends EvictionTestsBase {
    CacheSPI<Object, Object> cache;
    long wakeupIntervalMillis = 0L;
    final String ROOT_STR = "/test";
    Throwable t1_ex;
    Throwable t2_ex;
    volatile boolean isTrue;
    int maxNodes = 50;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupInterval();
        this.log("wakeupInterval is " + this.wakeupIntervalMillis);
        if (this.wakeupIntervalMillis < 0L) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
        this.t2_ex = null;
        this.t1_ex = null;
        this.isTrue = true;
    }

    void initCaches() throws Exception {
        Configuration config = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        EvictionConfig evConfig = new EvictionConfig(new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)new FIFOAlgorithmConfig(this.maxNodes), 2000000), 200);
        evConfig.addEvictionRegionConfig(new EvictionRegionConfig(Fqn.fromString((String)"/org/jboss/test/data"), (EvictionAlgorithmConfig)new FIFOAlgorithmConfig(5)));
        config.setEvictionConfig(evConfig);
        config.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        config.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(config, true);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testEviction() {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        EvictionController evictionController = new EvictionController((Cache)this.cache);
        evictionController.startEviction();
        try {
            String val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
            AssertJUnit.assertNull((Object)this.cache.get(rootStr + "1", (Object)(rootStr + "1")));
            AssertJUnit.assertNull((Object)this.cache.get(rootStr + "2", (Object)(rootStr + "2")));
            AssertJUnit.assertNull((Object)this.cache.get(rootStr + "0", (Object)(rootStr + "0")));
            AssertJUnit.assertNull((Object)this.cache.get(rootStr + "4", (Object)(rootStr + "4")));
            AssertJUnit.assertNotNull((Object)this.cache.get(rootStr + "5", (Object)(rootStr + "5")));
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
    }

    public void testEviction2() throws Exception {
        int i;
        String rootStr = "/org/jboss/data";
        for (int i2 = 0; i2 < this.maxNodes * 2; ++i2) {
            String str = rootStr + i2;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        EvictionController evictionController = new EvictionController((Cache)this.cache);
        evictionController.startEviction();
        TestingUtil.sleepThread(500L);
        AssertJUnit.assertEquals((String)"Number of nodes", (int)(this.maxNodes + 2), (int)this.cache.getNumberOfNodes());
        for (i = 0; i < this.maxNodes; ++i) {
            String n = rootStr + i;
            AssertJUnit.assertNull((String)("DataNode should be empty " + this.cache.getNode(n) + " " + n), (Object)this.cache.get(n, (Object)n));
        }
        for (i = this.maxNodes; i < this.maxNodes * 2; ++i) {
            AssertJUnit.assertNotNull((Object)this.cache.get(rootStr + Integer.toString(i), (Object)(rootStr + Integer.toString(i))));
        }
        this.cache.put(rootStr + "a", (Object)(rootStr + "a"), (Object)(rootStr + "a"));
        for (i = this.maxNodes + 1; i < this.maxNodes; ++i) {
            AssertJUnit.assertNotNull((Object)this.cache.get(rootStr + Integer.toString(i), (Object)(rootStr + Integer.toString(i))));
        }
        AssertJUnit.assertNotNull((Object)this.cache.get(rootStr + "a", (Object)(rootStr + "a")));
    }

    public void testNodeVisited() throws InterruptedException {
        String rootStr = "/org/jboss/test/data/";
        ArrayList<Fqn> fqnsToBeEvicted = new ArrayList<Fqn>();
        for (int i = 0; i < 5; ++i) {
            fqnsToBeEvicted.add(Fqn.fromString((String)(rootStr + i)));
        }
        EvictionWatcher watcher = new EvictionWatcher((Cache<?, ?>)this.cache, (List<Fqn>)fqnsToBeEvicted);
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        assert (watcher.waitForEviction(30L, TimeUnit.SECONDS)) : "Eviction event not received!";
        EvictionController evictionController = new EvictionController((Cache)this.cache);
        evictionController.startEviction();
        try {
            Fqn fqn;
            String str;
            int i;
            for (i = 0; i < 5; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 5; i < 10; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 5; i < 10; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                this.cache.get(fqn, (Object)str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to evict" + e));
        }
    }

    public void testNodeRemoved() {
        Fqn fqn2;
        String str2;
        String rootStr = "/org/jboss/test";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i + "/" + i;
            Fqn fqn = Fqn.fromString((String)str);
            str2 = rootStr + i;
            fqn2 = Fqn.fromString((String)str2);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                this.cache.put(fqn2, (Object)str2, (Object)str2);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        EvictionController evictionController = new EvictionController((Cache)this.cache);
        evictionController.startEviction();
        String str1 = rootStr + "7";
        Fqn fqn1 = Fqn.fromString((String)str1);
        str2 = rootStr + "7/7";
        fqn2 = Fqn.fromString((String)str2);
        try {
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn2, (Object)str2));
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn1, (Object)str1));
            this.cache.removeNode(fqn2);
            evictionController.startEviction();
            AssertJUnit.assertNull((Object)this.cache.get(fqn2, (Object)str2));
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn1, (Object)str1));
            this.cache.removeNode(fqn1);
            evictionController.startEviction();
            AssertJUnit.assertNull((Object)this.cache.get(fqn1, (Object)str1));
            AssertJUnit.assertNull((Object)this.cache.get(fqn2, (Object)str2));
            String str3 = rootStr + "5/5";
            String str4 = rootStr + "5";
            Fqn fqn3 = Fqn.fromString((String)str3);
            Fqn fqn4 = Fqn.fromString((String)str4);
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn3, (Object)str3));
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn4, (Object)str4));
            evictionController.startEviction();
            this.cache.removeNode(fqn4);
            evictionController.startEviction();
            AssertJUnit.assertNull((Object)this.cache.get(fqn3, (Object)str3));
            AssertJUnit.assertNull((Object)this.cache.get(fqn4, (Object)str4));
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to evict" + e));
        }
    }

    public void testConcurrentPutAndEvict() throws Exception {
        this.cache.stop();
        this.cache.destroy();
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.start();
        this.cache.put("/test/concurrentPutAndEvict", (Object)"value", (Object)1);
        ArrayList<MyPutter> putters = new ArrayList<MyPutter>();
        for (int i = 0; i < 10; ++i) {
            MyPutter p = new MyPutter("Putter" + i);
            putters.add(p);
            p.start();
        }
        int counter = 0;
        do {
            ++counter;
            if (this.t1_ex != null) {
                AssertJUnit.fail((String)("Exception generated in put() " + this.t1_ex));
            }
            this.log("nodes/locks: " + this.cache.getNumberOfNodes() + "/" + this.cache.getNumberOfLocksHeld());
            TestingUtil.sleepThread(1000L);
        } while (counter <= 5);
        this.isTrue = false;
        for (MyPutter p : putters) {
            p.join();
        }
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    class MyPutter
    extends Thread {
        public MyPutter(String name) {
            super(name);
        }

        public void run() {
            int i = 0;
            String myName = "/test/test1/node" + this.getName();
            while (FIFOPolicyTest.this.isTrue) {
                try {
                    FIFOPolicyTest.this.cache.put(myName + i++, (Object)"value", (Object)i);
                    TestingUtil.sleepThread(2L);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (FIFOPolicyTest.this.t1_ex != null) continue;
                    FIFOPolicyTest.this.t1_ex = e;
                }
            }
        }
    }
}

