/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;
import org.jboss.cache.RegionImpl;
import org.jboss.cache.RegionManager;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.LFUAlgorithm;
import org.jboss.cache.eviction.LFUAlgorithmConfig;
import org.jboss.cache.eviction.LFUQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class LFUAlgorithmTest
extends EvictionTestsBase {
    RegionManager regionManager;
    LFUAlgorithm algo;
    LFUAlgorithmConfig config;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.regionManager = new RegionManagerImpl();
        this.config = new LFUAlgorithmConfig();
        this.algo = (LFUAlgorithm)this.createAndAssignToRegion("/a/b", this.regionManager, (EvictionAlgorithmConfig)this.config);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.regionManager = null;
        this.config = null;
        this.algo = null;
    }

    public void testMaxNode1() {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(-1);
        this.config.setMinNodes(20);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        try {
            this.algo.process(region.getEvictionEventQueue());
        }
        catch (EvictionException e) {
            AssertJUnit.fail((String)("testMaxNode: process failed " + (Object)((Object)e)));
            e.printStackTrace();
        }
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)2, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }

    public void testMaxNode2() {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(1);
        this.config.setMinNodes(20);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        try {
            this.algo.process(region.getEvictionEventQueue());
        }
        catch (EvictionException e) {
            AssertJUnit.fail((String)("testMaxNode: process failed " + (Object)((Object)e)));
            e.printStackTrace();
        }
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        try {
            this.algo.process(region.getEvictionEventQueue());
        }
        catch (EvictionException e) {
            AssertJUnit.fail((String)("testMaxNode: process failed " + (Object)((Object)e)));
            e.printStackTrace();
        }
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }

    public void testMinNode1() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/c/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/c/d/e");
        Fqn fqn4 = Fqn.fromString((String)"/a/b/c/d/e/f");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        LFUAlgorithmConfig config = (LFUAlgorithmConfig)region.getEvictionRegionConfig().getEvictionAlgorithmConfig();
        config.setMaxNodes(-1);
        config.setMinNodes(2);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn4, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algo.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)2, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }

    public void testMinNode2() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        LFUAlgorithmConfig config = (LFUAlgorithmConfig)region.getEvictionRegionConfig().getEvictionAlgorithmConfig();
        config.setMaxNodes(-1);
        config.setMinNodes(-1);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algo.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)0, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }

    public void testEvictionQueueSortOrder1() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/c/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/c/d/e");
        Fqn fqn4 = Fqn.fromString((String)"/a/b/c/d/e/f");
        Fqn fqn5 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h");
        Fqn fqn6 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/i");
        Fqn fqn7 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/i/j");
        Fqn fqn8 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/i/j/k");
        Fqn fqn9 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/i/j/k/l");
        Fqn fqn10 = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/i/j/k/l/m");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        LFUAlgorithmConfig config = (LFUAlgorithmConfig)region.getEvictionRegionConfig().getEvictionAlgorithmConfig();
        config.setMaxNodes(-1);
        config.setMinNodes(100);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn4, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn5, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn6, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn7, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn8, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn9, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn10, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algo.process(region.getEvictionEventQueue());
        LFUQueue queue = (LFUQueue)this.algo.evictionQueue;
        AssertJUnit.assertEquals((int)10, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        for (NodeEntry ne : queue) {
            System.out.println("Fqn: " + ne.getFqn() + " NodeVisits: " + ne.getNumberOfNodeVisits());
            AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
        }
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn4, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn4, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn9, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn10, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn10, EvictionEvent.Type.VISIT_NODE_EVENT);
        this.algo.process(region.getEvictionEventQueue());
        System.out.println();
        System.out.println();
        int count = 0;
        for (NodeEntry ne : queue) {
            System.out.println("Fqn: " + ne.getFqn() + " NodeVisits: " + ne.getNumberOfNodeVisits());
            if (++count == 5 || count == 6) {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 7 || count == 8) {
                AssertJUnit.assertEquals((int)3, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 9) {
                AssertJUnit.assertEquals((int)4, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 10) {
                AssertJUnit.assertEquals((int)5, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
        }
        AssertJUnit.assertEquals((int)10, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        Fqn fqn11 = Fqn.fromString((String)"/a");
        Fqn fqn12 = Fqn.fromString((String)"/a/b");
        region.registerEvictionEvent(fqn11, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn12, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algo.process(region.getEvictionEventQueue());
        System.out.println();
        System.out.println();
        count = 0;
        for (NodeEntry ne : queue) {
            System.out.println("Fqn: " + ne.getFqn() + " NodeVisits: " + ne.getNumberOfNodeVisits());
            if (++count == 7 || count == 8) {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 9 || count == 10) {
                AssertJUnit.assertEquals((int)3, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 11) {
                AssertJUnit.assertEquals((int)4, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 12) {
                AssertJUnit.assertEquals((int)5, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
        }
        AssertJUnit.assertEquals((int)12, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.REMOVE_NODE_EVENT);
        region.registerEvictionEvent(fqn11, EvictionEvent.Type.REMOVE_NODE_EVENT);
        region.registerEvictionEvent(fqn12, EvictionEvent.Type.REMOVE_NODE_EVENT);
        region.registerEvictionEvent(fqn10, EvictionEvent.Type.REMOVE_NODE_EVENT);
        this.algo.process(region.getEvictionEventQueue());
        System.out.println();
        System.out.println();
        count = 0;
        for (NodeEntry ne : queue) {
            System.out.println("Fqn: " + ne.getFqn() + " NodeVisits: " + ne.getNumberOfNodeVisits());
            if (++count == 5 || count == 6) {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 7) {
                AssertJUnit.assertEquals((int)3, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 8) {
                AssertJUnit.assertEquals((int)4, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
        }
        AssertJUnit.assertEquals((int)8, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        region.registerEvictionEvent(fqn11, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn11, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn11, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn11, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn11, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn11, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn4, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.VISIT_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.REMOVE_NODE_EVENT);
        this.algo.process(region.getEvictionEventQueue());
        System.out.println();
        System.out.println();
        count = 0;
        for (NodeEntry ne : queue) {
            System.out.println("Fqn: " + ne.getFqn() + " NodeVisits: " + ne.getNumberOfNodeVisits());
            if (++count == 5 || count == 6) {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 7 || count == 8) {
                AssertJUnit.assertEquals((int)4, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            if (count == 9) {
                AssertJUnit.assertEquals((int)6, (int)ne.getNumberOfNodeVisits());
                continue;
            }
            AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
        }
        AssertJUnit.assertEquals((int)9, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }

    public void testEvictionQueueSortOrder2() throws Exception {
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        EvictionRegionConfig config = region.getEvictionRegionConfig();
        ((LFUAlgorithmConfig)config.getEvictionAlgorithmConfig()).setMaxNodes(-1);
        ((LFUAlgorithmConfig)config.getEvictionAlgorithmConfig()).setMinNodes(10000);
        for (int i = 0; i < 10000; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.registerEvictionEvent(fqn, EvictionEvent.Type.ADD_NODE_EVENT);
        }
        this.algo.process(region.getEvictionEventQueue());
        LFUQueue queue = (LFUQueue)this.algo.evictionQueue;
        long lastModifiedTimestamp = 0L;
        for (NodeEntry ne : queue) {
            AssertJUnit.assertTrue((lastModifiedTimestamp <= ne.getModifiedTimeStamp() ? 1 : 0) != 0);
            lastModifiedTimestamp = ne.getModifiedTimeStamp();
        }
        for (int i = 0; i < 10000; ++i) {
            if (i % 2 != 0) continue;
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.registerEvictionEvent(fqn, EvictionEvent.Type.VISIT_NODE_EVENT);
        }
        this.algo.process(region.getEvictionEventQueue());
        int count = 0;
        lastModifiedTimestamp = 0L;
        for (NodeEntry ne : queue) {
            AssertJUnit.assertTrue((lastModifiedTimestamp <= ne.getModifiedTimeStamp() ? 1 : 0) != 0);
            lastModifiedTimestamp = ne.getModifiedTimeStamp();
            if (count < 5000) {
                AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
            } else {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfNodeVisits());
            }
            ++count;
        }
        AssertJUnit.assertEquals((int)10000, (int)this.algo.getEvictionQueue().getNumberOfNodes());
    }
}

