/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.element.EvictionElementParser;
import org.jboss.cache.eviction.LFUAlgorithmConfig;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"unit"}, sequential=false)
public class LFUConfigurationTest {
    public void testXMLParsing() throws Exception {
        LFUAlgorithmConfig config = new LFUAlgorithmConfig();
        String xml = "<region name=\"abc\"><property name=\"minNodes\" value=\"10\"></property><property name=\"maxNodes\" value=\"20\"></property></region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)config);
        config.validate();
        AssertJUnit.assertEquals((int)10, (int)config.getMinNodes());
        AssertJUnit.assertEquals((int)20, (int)config.getMaxNodes());
    }

    public void testXMLParsing2() throws Exception {
        LFUAlgorithmConfig config = new LFUAlgorithmConfig();
        String xml = "<region name=\"abc\"><property name=\"minNodes\" value=\"10\"></property></region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)config);
        config.validate();
        AssertJUnit.assertEquals((int)10, (int)config.getMinNodes());
        AssertJUnit.assertEquals((int)-1, (int)config.getMaxNodes());
    }

    public void testXMLParsing3() throws Exception {
        LFUAlgorithmConfig config = new LFUAlgorithmConfig();
        String xml = "<region name=\"abc\"><property name=\"maxNodes\" value=\"20\"></property></region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)config);
        config.validate();
        AssertJUnit.assertEquals((int)-1, (int)config.getMinNodes());
        AssertJUnit.assertEquals((int)20, (int)config.getMaxNodes());
    }
}

