/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.LFUAlgorithmConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionWatcher;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class LFUPolicyTest
extends EvictionTestsBase {
    CacheSPI<Object, Object> cache;
    long wakeupIntervalMillis = 0L;
    final String ROOT_STR = "/test";
    Throwable t1_ex;
    Throwable t2_ex;
    boolean isTrue;
    int maxNodesDefault = 500;
    int minNodesDefault = 10;
    int maxNodesR1 = 200;
    int minNodesR1 = 100;
    int maxNodesR2 = -1;
    int minNodesR2 = 5;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupInterval();
        this.log("wakeupInterval is " + this.wakeupIntervalMillis);
        if (this.wakeupIntervalMillis < 0L) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
        this.t2_ex = null;
        this.t1_ex = null;
        this.isTrue = true;
    }

    void initCaches() throws Exception {
        Configuration config = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        EvictionConfig evConfig = new EvictionConfig(new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)new LFUAlgorithmConfig(this.maxNodesDefault, this.minNodesDefault), 200000), 200);
        evConfig.addEvictionRegionConfig(new EvictionRegionConfig(Fqn.fromString((String)"/org/jboss/data"), (EvictionAlgorithmConfig)new LFUAlgorithmConfig(this.maxNodesR1, this.minNodesR1)));
        evConfig.addEvictionRegionConfig(new EvictionRegionConfig(Fqn.fromString((String)"/org/jboss/test/data"), (EvictionAlgorithmConfig)new LFUAlgorithmConfig(this.maxNodesR2, this.minNodesR2)));
        config.setEvictionConfig(evConfig);
        config.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        config.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(config, true);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testNodeVisited() throws InterruptedException {
        Fqn fqn;
        String str;
        int i;
        String rootStr = "/org/jboss/test/data/";
        ArrayList<Fqn> fqns = new ArrayList<Fqn>();
        for (int i2 = 0; i2 < 5; ++i2) {
            fqns.add(Fqn.fromString((String)(rootStr + i2)));
        }
        EvictionWatcher ew = new EvictionWatcher((Cache<?, ?>)this.cache, (List<Fqn>)fqns);
        for (i = 0; i < 10; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        assert (ew.waitForEviction(30L, TimeUnit.SECONDS));
        try {
            for (i = 0; i < 5; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNull((String)("Fqn " + fqn + " should be null"), (Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 5; i < 10; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 5; i < 10; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 5; i < 7; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                this.cache.get(fqn, (Object)str);
            }
            for (i = 10; i < 13; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                this.cache.put(fqn, (Object)str, (Object)str);
                for (int k = 0; k < 10; ++k) {
                    this.cache.get(fqn, (Object)str);
                }
            }
            assert (this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, Fqn.fromString((String)(rootStr + 7)), Fqn.fromString((String)(rootStr + 8)), Fqn.fromString((String)(rootStr + 9))));
            for (i = 5; i < 7; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 7; i < 10; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)str));
            }
            for (i = 10; i < 13; ++i) {
                str = rootStr + Integer.toString(i);
                fqn = Fqn.fromString((String)str);
                AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to evict" + e));
        }
    }

    public void testNodeRemoved() throws Exception {
        Fqn fqn;
        String str;
        int i;
        String rootStr = "/org/jboss/data/";
        for (int i2 = 0; i2 < this.maxNodesR1; ++i2) {
            String str2 = rootStr + i2;
            Fqn fqn2 = Fqn.fromString((String)str2);
            try {
                this.cache.put(fqn2, (Object)str2, (Object)str2);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        long period = this.wakeupIntervalMillis + 500L;
        this.log("period is " + period);
        TestingUtil.sleepThread(period);
        for (i = 0; i < this.maxNodesR1 - this.minNodesR1; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            AssertJUnit.assertNull((Object)this.cache.get(fqn, (Object)str));
        }
        for (i = this.maxNodesR1 - this.minNodesR1; i < this.maxNodesR1; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            AssertJUnit.assertNotNull((Object)this.cache.get(fqn, (Object)str));
        }
        for (i = this.maxNodesR1 - this.minNodesR1; i < this.maxNodesR1; ++i) {
            if (i % 2 != 0) continue;
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            this.cache.removeNode(fqn);
        }
        TestingUtil.sleepThread(period);
        for (i = this.maxNodesR1 - this.minNodesR1; i < this.maxNodesR1; ++i) {
            if (i % 2 != 0) continue;
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            AssertJUnit.assertNull((Object)this.cache.getNode(fqn));
        }
    }

    public void testConcurrentPutAndEvict() throws Exception {
        this.cache.stop();
        this.cache.destroy();
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.start();
        this.cache.put("/test/concurrentPutAndEvict", (Object)"value", (Object)1);
        for (int i = 0; i < 10; ++i) {
            new MyPutter("Putter" + i).start();
        }
        int counter = 0;
        do {
            ++counter;
            if (this.t1_ex != null) {
                AssertJUnit.fail((String)("Exception generated in put() " + this.t1_ex));
            }
            this.log("nodes/locks: " + this.cache.getNumberOfNodes() + "/" + this.cache.getNumberOfLocksHeld());
            TestingUtil.sleepThread(1000L);
        } while (counter <= 5);
        this.isTrue = false;
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    class MyPutter
    extends Thread {
        public MyPutter(String name) {
            super(name);
        }

        public void run() {
            int i = 0;
            String myName = "/test/test1/node" + this.getName();
            while (LFUPolicyTest.this.isTrue) {
                try {
                    LFUPolicyTest.this.cache.put(myName + i++, (Object)"value", (Object)i);
                    MyPutter.sleep(1L);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (LFUPolicyTest.this.t1_ex != null) continue;
                    LFUPolicyTest.this.t1_ex = e;
                }
            }
        }
    }
}

