/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionImpl;
import org.jboss.cache.RegionManager;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.LRUAlgorithm;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.eviction.LRUQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class LRUAlgorithmTest
extends EvictionTestsBase {
    RegionManager regionManager;
    LRUAlgorithm algorithm;
    LRUAlgorithmConfig config;
    Log log = LogFactory.getLog(LRUAlgorithm.class);

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.regionManager = new RegionManagerImpl();
        this.config = new LRUAlgorithmConfig();
        this.config.setTimeToLive(-1L);
        this.algorithm = (LRUAlgorithm)this.createAndAssignToRegion("/a/b", this.regionManager, (EvictionAlgorithmConfig)this.config);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.regionManager = null;
        this.config = null;
        this.algorithm = null;
    }

    public void testEvictException() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(1);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testMaxNode1() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(0);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)2, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testMaxNode2() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(1);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testIdleTimeSeconds1() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(-1);
        this.config.setTimeToLive(-1L);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)2, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testIdleTimeSeconds2() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(0);
        this.config.setTimeToLive(1000L);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size #1: ", (int)3, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        TestingUtil.sleepThread(1100L);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size #2: ", (int)0, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testIdleTimeSeconds3() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(0);
        this.config.setTimeToLive(1000L);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size #1: ", (int)3, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        TestingUtil.sleepThread(1100L);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.VISIT_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size #2: ", (int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testMaxAgeSeconds1() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(-1);
        this.config.setTimeToLive(-1L);
        this.config.setMaxAge(100L);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size #1: ", (int)3, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        TestingUtil.sleepThread(110L);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size #2: ", (int)0, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testMaxAgeSeconds2() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(-1);
        this.config.setTimeToLive(-1L);
        this.config.setMaxAge(100L);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size #1: ", (int)3, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        TestingUtil.sleepThread(50L);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size #2: ", (int)3, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        TestingUtil.sleepThread(60L);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((String)"Queue size #3: ", (int)0, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testCombo1() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Fqn fqn4 = Fqn.fromString((String)"/a/b/f");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(2);
        this.config.setTimeToLive(100L);
        this.config.setMaxAge(300L);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn4, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        EvictionQueue eq = this.algorithm.getEvictionQueue();
        int numNodesInQueue = eq.getNumberOfNodes();
        assert (2 == numNodesInQueue) : "Queue size #1: expected 2 but was " + numNodesInQueue;
        TestingUtil.sleepThread(110L);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        numNodesInQueue = eq.getNumberOfNodes();
        assert (1 == numNodesInQueue) : "Queue size #2: expected 1 but was " + numNodesInQueue;
        TestingUtil.sleepThread(310L);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.VISIT_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        numNodesInQueue = eq.getNumberOfNodes();
        assert (0 == numNodesInQueue) : "Queue size #3: expected 0 but was " + numNodesInQueue;
    }

    public void testCombo2() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxNodes(2);
        this.config.setTimeToLive(100L);
        this.config.setMaxAge(300L);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.REMOVE_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        EvictionQueue eq = this.algorithm.getEvictionQueue();
        int numNodesInQueue = eq.getNumberOfNodes();
        assert (1 == numNodesInQueue) : "Queue size #1: expected 1 but was " + numNodesInQueue;
        TestingUtil.sleepThread(110L);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        numNodesInQueue = eq.getNumberOfNodes();
        assert (1 == numNodesInQueue) : "Queue size #2: expected 1 but was " + numNodesInQueue;
        TestingUtil.sleepThread(310L);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.VISIT_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        numNodesInQueue = eq.getNumberOfNodes();
        assert (0 == numNodesInQueue) : "Queue size #3: expected 0 but was " + numNodesInQueue;
    }

    public void testEvictionSortOrder() throws EvictionException {
        NodeEntry ne;
        Fqn fqn;
        int i;
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        this.config.setMaxAge(1000000L);
        this.config.setMaxNodes(0);
        this.config.setTimeToLive(1000000L);
        for (i = 0; i < 100; ++i) {
            fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.registerEvictionEvent(fqn, EvictionEvent.Type.ADD_NODE_EVENT);
        }
        this.algorithm.process(region.getEvictionEventQueue());
        for (i = 0; i < 100; ++i) {
            fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            if (i % 2 != 0) continue;
            region.registerEvictionEvent(fqn, EvictionEvent.Type.VISIT_NODE_EVENT);
        }
        this.algorithm.process(region.getEvictionEventQueue());
        LRUQueue queue = (LRUQueue)this.algorithm.getEvictionQueue();
        int count = 0;
        while ((ne = queue.getFirstLRUNodeEntry()) != null) {
            if (count < 50) {
                AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
            } else {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfNodeVisits());
            }
            queue.removeNodeEntry(ne);
            ++count;
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            Fqn fqn2 = Fqn.fromString((String)("/a/b/" + Integer.toString(i2)));
            region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        }
        this.algorithm.process(region.getEvictionEventQueue());
        long lastCreateTimestamp = 0L;
        while ((ne = queue.getFirstMaxAgeNodeEntry()) != null) {
            AssertJUnit.assertTrue((ne.getCreationTimeStamp() >= lastCreateTimestamp ? 1 : 0) != 0);
            lastCreateTimestamp = ne.getCreationTimeStamp();
            queue.removeNodeEntry(ne);
        }
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }
}

