/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.LRUQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class LRUQueueTest {
    private LRUQueue queue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.queue = new LRUQueue();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.queue = null;
    }

    public void testQueue() throws Exception {
        NodeEntry ne;
        int i;
        for (i = 0; i < 500; ++i) {
            NodeEntry ne2 = new NodeEntry("/a/b/c/" + Integer.toString(i));
            this.queue.addNodeEntry(ne2);
        }
        AssertJUnit.assertEquals((int)500, (int)this.queue.getNumberOfNodes());
        for (i = 0; i < 500; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/c/" + Integer.toString(i)));
            if (i >= 100 && (i < 300 || i >= 400)) continue;
            this.queue.reorderByLRU(fqn);
        }
        Iterator maxAgeIt = this.queue.iterateMaxAgeQueue();
        int count = 0;
        long lastTs = 0L;
        while (maxAgeIt.hasNext()) {
            NodeEntry ne3 = (NodeEntry)maxAgeIt.next();
            AssertJUnit.assertTrue((lastTs <= ne3.getCreationTimeStamp() ? 1 : 0) != 0);
            lastTs = ne3.getCreationTimeStamp();
            ++count;
        }
        AssertJUnit.assertEquals((int)500, (int)count);
        Iterator lruIt = this.queue.iterateLRUQueue();
        count = 0;
        while (lruIt.hasNext()) {
            int expectedNodeIndex;
            ne = (NodeEntry)lruIt.next();
            int nodeIndex = Integer.parseInt((String)ne.getFqn().get(3));
            if (count >= 300 && count < 400) {
                expectedNodeIndex = count - 300;
                AssertJUnit.assertEquals((int)expectedNodeIndex, (int)nodeIndex);
            } else if (count >= 400 && count < 500) {
                expectedNodeIndex = count - 100;
                AssertJUnit.assertEquals((int)expectedNodeIndex, (int)nodeIndex);
            } else if (count < 200) {
                expectedNodeIndex = count + 100;
                AssertJUnit.assertEquals((int)expectedNodeIndex, (int)nodeIndex);
            } else if (count >= 200 && count < 300) {
                expectedNodeIndex = count + 200;
                AssertJUnit.assertEquals((int)expectedNodeIndex, (int)nodeIndex);
            }
            ++count;
        }
        AssertJUnit.assertEquals((int)500, (int)count);
        ne = this.queue.getFirstMaxAgeNodeEntry();
        this.queue.removeNodeEntry(ne);
        AssertJUnit.assertEquals((int)499, (int)this.queue.getNumberOfNodes());
        AssertJUnit.assertFalse((boolean)this.queue.containsNodeEntry(ne));
        ne = this.queue.getFirstLRUNodeEntry();
        this.queue.removeNodeEntry(ne);
        AssertJUnit.assertEquals((int)498, (int)this.queue.getNumberOfNodes());
        AssertJUnit.assertFalse((boolean)this.queue.containsNodeEntry(ne));
    }

    public void testGetFirstLRUNodeEntry() throws Exception {
        NodeEntry ne;
        int i;
        for (i = 0; i < 100; ++i) {
            NodeEntry ne2 = new NodeEntry("/a/b/c/" + Integer.toString(i));
            this.queue.addNodeEntry(ne2);
        }
        for (i = 0; i < 100; ++i) {
            if (i % 2 != 0) continue;
            Fqn fqn = Fqn.fromString((String)("/a/b/c/" + Integer.toString(i)));
            this.queue.reorderByLRU(fqn);
        }
        AssertJUnit.assertEquals((int)100, (int)this.queue.getNumberOfNodes());
        int count = 0;
        while ((ne = this.queue.getFirstLRUNodeEntry()) != null) {
            int nodeIndex = Integer.parseInt((String)ne.getFqn().get(3));
            if (count < 50) {
                AssertJUnit.assertTrue((nodeIndex % 2 != 0 ? 1 : 0) != 0);
            } else {
                AssertJUnit.assertTrue((nodeIndex % 2 == 0 ? 1 : 0) != 0);
            }
            this.queue.removeNodeEntry(ne);
            ++count;
        }
        AssertJUnit.assertEquals((int)0, (int)this.queue.getNumberOfNodes());
    }

    public void testGetFirstMaxAgeNodeEntriy() throws Exception {
        NodeEntry ne;
        int i;
        for (i = 0; i < 100; ++i) {
            NodeEntry ne2 = new NodeEntry("/a/b/c/" + Integer.toString(i));
            this.queue.addNodeEntry(ne2);
        }
        for (i = 0; i < 100; ++i) {
            if (i % 2 != 0) continue;
            Fqn fqn = Fqn.fromString((String)("/a/b/c/" + Integer.toString(i)));
            this.queue.reorderByLRU(fqn);
        }
        AssertJUnit.assertEquals((int)100, (int)this.queue.getNumberOfNodes());
        int count = 0;
        while ((ne = this.queue.getFirstMaxAgeNodeEntry()) != null) {
            int nodeIndex = Integer.parseInt((String)ne.getFqn().get(3));
            AssertJUnit.assertEquals((int)count, (int)nodeIndex);
            this.queue.removeNodeEntry(ne);
            ++count;
        }
        AssertJUnit.assertEquals((int)0, (int)this.queue.getNumberOfNodes());
    }

    public void testNumElements() throws Exception {
        int i;
        LRUQueue queue = new LRUQueue();
        NodeEntry ne = new NodeEntry("/a/b/c");
        ne.setNumberOfElements(50);
        queue.addNodeEntry(ne);
        AssertJUnit.assertEquals((int)50, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)1, (int)queue.getNumberOfNodes());
        queue.removeNodeEntry(ne);
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfElements());
        for (i = 0; i < 10; ++i) {
            ne = new NodeEntry("/a/b/c/" + Integer.toString(i));
            ne.setNumberOfElements(i);
            queue.addNodeEntry(ne);
        }
        AssertJUnit.assertEquals((int)45, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)10, (int)queue.getNumberOfNodes());
        ne = queue.getNodeEntry("/a/b/c/0");
        AssertJUnit.assertNotNull((Object)ne);
        AssertJUnit.assertEquals((int)0, (int)ne.getNumberOfElements());
        ne.setNumberOfElements(500);
        AssertJUnit.assertEquals((int)545, (int)queue.getNumberOfElements());
        ne = queue.getNodeEntry("/a/b/c/0");
        AssertJUnit.assertEquals((int)500, (int)ne.getNumberOfElements());
        queue.removeNodeEntry(ne);
        AssertJUnit.assertEquals((int)45, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)9, (int)queue.getNumberOfNodes());
        for (i = 1; i < 10; ++i) {
            ne = queue.getNodeEntry("/a/b/c/" + Integer.toString(i));
            AssertJUnit.assertEquals((int)i, (int)ne.getNumberOfElements());
            queue.removeNodeEntry(ne);
        }
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfElements());
        AssertJUnit.assertNull((Object)queue.getNodeEntry("/a/b/c/0"));
        AssertJUnit.assertNull((Object)queue.getFirstNodeEntry());
    }
}

