/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.MRUQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class MRUQueueTest {
    private MRUQueue queue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.queue = new MRUQueue();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.queue.clear();
    }

    public void testQueue() throws Exception {
        NodeEntry ne;
        int i;
        for (i = 0; i < 100; ++i) {
            NodeEntry ne2 = new NodeEntry("/a/b/c/" + Integer.toString(i));
            ne2.setModifiedTimeStamp(0L);
            this.queue.addNodeEntry(ne2);
        }
        AssertJUnit.assertEquals((int)this.queue.nodeMap.size(), (int)this.queue.list.size());
        for (i = 0; i < 100; ++i) {
            if (i % 2 != 0) continue;
            Fqn fqn = Fqn.fromString((String)("/a/b/c/" + Integer.toString(i)));
            NodeEntry ne3 = this.queue.getNodeEntry(fqn);
            ne3.setModifiedTimeStamp(System.currentTimeMillis());
            this.queue.moveToTopOfStack(fqn);
        }
        AssertJUnit.assertEquals((int)this.queue.nodeMap.size(), (int)this.queue.list.size());
        int count = 0;
        while ((ne = this.queue.getFirstNodeEntry()) != null) {
            if (count < 50) {
                AssertJUnit.assertTrue((ne.getModifiedTimeStamp() > 0L ? 1 : 0) != 0);
                AssertJUnit.assertEquals((int)(100 - count), (int)this.queue.getNumberOfNodes());
            } else {
                AssertJUnit.assertEquals((long)0L, (long)ne.getModifiedTimeStamp());
            }
            this.queue.removeNodeEntry(ne);
            ++count;
        }
        AssertJUnit.assertEquals((int)this.queue.nodeMap.size(), (int)this.queue.list.size());
    }

    public void testNumElements() throws Exception {
        int i;
        MRUQueue queue = new MRUQueue();
        NodeEntry ne = new NodeEntry("/a/b/c");
        ne.setNumberOfElements(50);
        queue.addNodeEntry(ne);
        AssertJUnit.assertEquals((int)50, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)1, (int)queue.getNumberOfNodes());
        queue.removeNodeEntry(ne);
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfElements());
        for (i = 0; i < 10; ++i) {
            ne = new NodeEntry("/a/b/c/" + Integer.toString(i));
            ne.setNumberOfElements(i);
            queue.addNodeEntry(ne);
        }
        AssertJUnit.assertEquals((int)45, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)10, (int)queue.getNumberOfNodes());
        ne = queue.getNodeEntry("/a/b/c/0");
        AssertJUnit.assertNotNull((Object)ne);
        AssertJUnit.assertEquals((int)0, (int)ne.getNumberOfElements());
        ne.setNumberOfElements(500);
        AssertJUnit.assertEquals((int)545, (int)queue.getNumberOfElements());
        ne = queue.getNodeEntry("/a/b/c/0");
        AssertJUnit.assertEquals((int)500, (int)ne.getNumberOfElements());
        queue.removeNodeEntry(ne);
        AssertJUnit.assertEquals((int)45, (int)queue.getNumberOfElements());
        AssertJUnit.assertEquals((int)9, (int)queue.getNumberOfNodes());
        for (i = 1; i < 10; ++i) {
            ne = queue.getNodeEntry("/a/b/c/" + Integer.toString(i));
            AssertJUnit.assertEquals((int)i, (int)ne.getNumberOfElements());
            queue.removeNodeEntry(ne);
        }
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)queue.getNumberOfElements());
        AssertJUnit.assertNull((Object)queue.getNodeEntry("/a/b/c/0"));
        AssertJUnit.assertNull((Object)queue.getFirstNodeEntry());
    }
}

