/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.interceptors.EvictionInterceptor;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionController;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class OptimisticEvictionTest
extends EvictionTestsBase {
    private CacheSPI<Object, Object> cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration config = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        config.setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        config.setEvictionConfig(this.buildEvictionConfig());
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(config);
    }

    private EvictionConfig buildEvictionConfig() throws Exception {
        EvictionConfig result = new EvictionConfig(new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)new LRUAlgorithmConfig(0L, 0, 10)), 200);
        result.addEvictionRegionConfig(new EvictionRegionConfig(Fqn.fromString((String)"/testingRegion"), (EvictionAlgorithmConfig)new LRUAlgorithmConfig(0L, 0, 10)));
        result.addEvictionRegionConfig(new EvictionRegionConfig(Fqn.fromString((String)"/timeBased"), (EvictionAlgorithmConfig)new LRUAlgorithmConfig(1L, 1, 0)));
        return result;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testEvictionOccurence() throws Exception {
        this.cache.put("/timeBased/test", (Object)"key", (Object)"value");
        AssertJUnit.assertTrue((boolean)this.cache.exists("/timeBased/test"));
        TestingUtil.sleepThread(1L);
        new EvictionController((Cache)this.cache).startEviction();
        AssertJUnit.assertTrue((!this.cache.exists("/timeBased/test") ? 1 : 0) != 0);
    }

    public void testInterceptorChain() throws Exception {
        List interceptors = this.cache.getInterceptorChain();
        System.out.println(interceptors);
        Iterator i = interceptors.iterator();
        boolean found = false;
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof EvictionInterceptor)) continue;
            found = true;
        }
        AssertJUnit.assertTrue((String)"Eviction interceptor should be in interceptor chain.", (boolean)found);
    }

    public void testCompleteRemoval() throws Exception {
        String rootStr = "/timeBased/";
        Fqn parent = Fqn.fromString((String)(rootStr + "parent"));
        this.cache.put(parent, (Object)"key", (Object)"value");
        this.cache.put(Fqn.fromRelativeElements((Fqn)parent, (Object[])new String[]{"child"}), (Object)"key", (Object)"value");
        assert (this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, parent));
        assert (this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, parent));
        AssertJUnit.assertFalse((String)"Parent completely removed", (boolean)this.cache.getRoot().hasChild(parent));
    }
}

