/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionManager;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class ProgrammaticLRUPolicyTest
extends EvictionTestsBase {
    CacheSPI<Object, Object> cache;
    long wakeupIntervalMillis = 0L;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupInterval();
        this.log("wakeupInterval is " + this.wakeupIntervalMillis);
        if (this.wakeupIntervalMillis < 0L) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
    }

    private void initCaches() {
        Configuration conf = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = (CacheSPI)instance.createCache(conf, false);
        EvictionConfig erc = new EvictionConfig(new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)new LRUAlgorithmConfig(0L, 0, 10)), 200);
        conf.setEvictionConfig(erc);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache.create();
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    private void addStringBasedRegion() throws Exception {
        LRUAlgorithmConfig lru = new LRUAlgorithmConfig(150L, 0, 1000);
        EvictionRegionConfig regConfig = new EvictionRegionConfig(Fqn.fromString((String)"/dummy"), (EvictionAlgorithmConfig)lru);
        RegionManager regionManager = this.cache.getRegionManager();
        EvictionConfig topConfig = this.cache.getConfiguration().getEvictionConfig();
        topConfig.addEvictionRegionConfig(regConfig);
        regionManager.setEvictionConfig(topConfig);
        regionManager.getRegion("/programmatic", true).setEvictionRegionConfig(regConfig);
    }

    public void testStringBasedFqnEviction() throws Exception {
        this.addStringBasedRegion();
        String rootStr = "/programmatic/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        String val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNotNull((String)"DataNode should be empty ", (Object)val);
        System.out.println(this.cache.toString());
        assert (this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, Fqn.fromString((String)(rootStr + 3))));
        System.out.println(this.cache.toString());
        val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
    }

    private void addObjectBasedRegion() throws Exception {
        LRUAlgorithmConfig lru = new LRUAlgorithmConfig(150L, 1000L);
        EvictionRegionConfig regConfig = new EvictionRegionConfig(Fqn.fromElements((Object[])new Integer[]{1}), (EvictionAlgorithmConfig)lru);
        RegionManager regionManager = this.cache.getRegionManager();
        EvictionConfig topConfig = this.cache.getConfiguration().getEvictionConfig();
        topConfig.addEvictionRegionConfig(regConfig);
        regionManager.setEvictionConfig(topConfig);
        regionManager.getRegion(Fqn.fromElements((Object[])new Integer[]{1}), true).setEvictionRegionConfig(regConfig);
    }

    public void testObjectBasedFqnEviction1() throws Exception {
        String val;
        this.addStringBasedRegion();
        String rootStr = "programmatic";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr;
            Integer in = i;
            Fqn fqn = Fqn.fromElements((Object[])new Serializable[]{rootStr, in});
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        Integer in = 3;
        Fqn fqn = Fqn.fromElements((Object[])new Serializable[]{rootStr, in});
        try {
            val = (String)this.cache.get(fqn, (Object)in);
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
        System.out.println(this.cache.toString());
        assert (this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, fqn));
        System.out.println(this.cache.toString());
        try {
            val = (String)this.cache.get(fqn, (Object)in);
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
    }

    public void testObjectBasedFqnEviction2() throws Exception {
        Object val;
        Integer in;
        Fqn fqn;
        this.addObjectBasedRegion();
        Integer ii = 1;
        Fqn rootfqn = Fqn.fromElements((Object[])new Integer[]{ii});
        for (int i = 0; i < 10; ++i) {
            fqn = Fqn.fromRelativeElements((Fqn)rootfqn, (Object[])new Integer[]{i});
            try {
                this.cache.put(fqn, (Object)i, (Object)i);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        try {
            in = 3;
            fqn = Fqn.fromRelativeElements((Fqn)rootfqn, (Object[])new Integer[]{in});
            val = this.cache.get(fqn, (Object)in);
            AssertJUnit.assertNotNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
        in = 3;
        fqn = Fqn.fromRelativeElements((Fqn)rootfqn, (Object[])new Integer[]{in});
        System.out.println(this.cache.toString());
        assert (this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, fqn));
        System.out.println(this.cache.toString());
        try {
            val = this.cache.get(fqn, (Object)in);
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
    }

    private void log(String msg) {
        System.out.println("-- " + msg);
    }
}

