/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionController;
import org.jboss.cache.util.internals.EvictionWatcher;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class ReplicatedLRUPolicyTest
extends EvictionTestsBase {
    CacheSPI<Object, Object> cache1;
    CacheSPI<Object, Object> cache2;
    CacheSPI<Object, Object> cache3;
    long wakeupIntervalMillis = 500L;
    EvictionListener listener = new EvictionListener();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC, true), false);
        this.cache1.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache1.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache1.getConfiguration().getEvictionConfig().setWakeupInterval(this.wakeupIntervalMillis);
        this.cache1.start();
        this.cache1.getNotifier().addCacheListener((Object)this.listener);
        this.listener.resetCounter();
        this.cache3 = (CacheSPI)new UnitTestCacheFactory().createCache(this.cache1.getConfiguration().clone(), false);
        this.cache3.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache3.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache3.getConfiguration().getEvictionConfig().setWakeupInterval(this.wakeupIntervalMillis);
        this.cache3.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2, this.cache3});
        this.cache1 = null;
        this.cache2 = null;
        this.cache3 = null;
    }

    public void testBasic() throws Exception {
        String rootStr = "/org/jboss/test/data/";
        LRUAlgorithmConfig cfg = (LRUAlgorithmConfig)this.cache1.getConfiguration().getEvictionConfig().getEvictionRegionConfig(rootStr).getEvictionAlgorithmConfig();
        cfg.setMaxAge(0L);
        cfg.setTimeToLive(0L);
        cfg = (LRUAlgorithmConfig)this.cache3.getConfiguration().getEvictionConfig().getEvictionRegionConfig(rootStr).getEvictionAlgorithmConfig();
        cfg.setMaxAge(-1L, TimeUnit.SECONDS);
        cfg.setTimeToLive(-1L, TimeUnit.SECONDS);
        cfg.setMaxNodes(200);
        String str = rootStr + "0";
        Fqn fqn = Fqn.fromString((String)str);
        this.cache1.put(str, (Object)str, (Object)str);
        new EvictionController((Cache)this.cache1).startEviction();
        NodeSPI node = this.cache1.peek(fqn, false);
        AssertJUnit.assertNull((String)"Node should be evicted already ", (Object)node);
        AssertJUnit.assertEquals((String)"Eviction counter ", (int)1, (int)this.listener.getCounter());
        String val = (String)this.cache3.get(str, (Object)str);
        AssertJUnit.assertNotNull((String)"DataNode should not be evicted here ", (Object)val);
        AssertJUnit.assertEquals((String)"Eviction counter ", (int)1, (int)this.listener.getCounter());
    }

    public void testEviction() throws Exception {
        String rootStr = "/org/jboss/test/data/";
        LRUAlgorithmConfig cfg = (LRUAlgorithmConfig)this.cache3.getConfiguration().getEvictionConfig().getEvictionRegionConfig(rootStr).getEvictionAlgorithmConfig();
        cfg.setMaxAge(60L, TimeUnit.SECONDS);
        cfg.setTimeToLive(360L, TimeUnit.SECONDS);
        cfg.setMaxNodes(200);
        EvictionWatcher ew = new EvictionWatcher((Cache<?, ?>)this.cache1, Fqn.fromString((String)(rootStr + 3)));
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache1.put(fqn, (Object)str, (Object)str);
        }
        assert (ew.waitForEviction(30L, TimeUnit.SECONDS));
        String val = (String)this.cache1.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"DataNode should be evicted already ", (Object)val);
        val = (String)this.cache3.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNotNull((String)"DataNode should not be evicted here ", (Object)val);
    }

    public void testEvictionReplication() throws Exception {
        String rootStr = "/org/jboss/test/data/";
        LRUAlgorithmConfig cfg = (LRUAlgorithmConfig)this.cache3.getConfiguration().getEvictionConfig().getEvictionRegionConfig(rootStr).getEvictionAlgorithmConfig();
        cfg.setMaxAge(60L, TimeUnit.SECONDS);
        cfg.setTimeToLive(360L, TimeUnit.SECONDS);
        EvictionWatcher ew = new EvictionWatcher((Cache<?, ?>)this.cache1, Fqn.fromString((String)(rootStr + 3)));
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache1.put(fqn, (Object)str, (Object)str);
        }
        String str = rootStr + "7";
        Fqn fqn = Fqn.fromString((String)str);
        this.cache1.get(fqn, (Object)str);
        assert (ew.waitForEviction(30L, TimeUnit.SECONDS));
        String val = (String)this.cache1.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        val = (String)this.cache3.get(rootStr + "7", (Object)(rootStr + "7"));
        AssertJUnit.assertNotNull((String)"DataNode should not be null", (Object)val);
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    @CacheListener
    public class EvictionListener {
        int counter = 0;

        public int getCounter() {
            return this.counter;
        }

        public void resetCounter() {
            this.counter = 0;
        }

        @NodeEvicted
        public void nodeEvicted(Event e) {
            System.out.println(e);
            if (e.isPre()) {
                ++this.counter;
            }
        }
    }
}

