/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.io.InputStream;
import java.net.URL;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.FileLookup;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.XmlConfigurator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UnitTestCacheConfigurationFactory {
    public static final String JGROUPS_CHANNEL = System.getProperty("jgroups.stack", "udp");
    public static final String JGROUPS_STACK_TYPE = "jgroups.stack";
    public static final String DEFAULT_CONFIGURATION_FILE = "unit-test-cache-service.xml";

    public static Configuration createConfiguration(Configuration.CacheMode mode) throws ConfigurationException {
        return UnitTestCacheConfigurationFactory.createConfiguration(mode, false, false);
    }

    public static Configuration createConfiguration(Configuration.CacheMode mode, boolean useEviction) throws ConfigurationException {
        return UnitTestCacheConfigurationFactory.createConfiguration(mode, useEviction, false);
    }

    public static Configuration createConfiguration(Configuration.CacheMode mode, boolean useEviction, boolean usePassivation) throws ConfigurationException {
        return UnitTestCacheConfigurationFactory.createConfiguration(mode, useEviction, usePassivation, false);
    }

    public static Configuration createConfiguration(Configuration.CacheMode mode, boolean useEviction, boolean usePassivation, boolean killable) throws ConfigurationException {
        UnitTestXmlConfigurationParser parser = new UnitTestXmlConfigurationParser();
        Configuration c = parser.parseFile(DEFAULT_CONFIGURATION_FILE, mode);
        if (!useEviction) {
            c.setEvictionConfig(null);
        }
        if (!usePassivation) {
            c.setCacheLoaderConfig(null);
        }
        c.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        if (mode != Configuration.CacheMode.LOCAL && killable) {
            String clusterConfig = c.getClusterConfig();
            c.setClusterConfig(UnitTestCacheConfigurationFactory.injectDiscard(clusterConfig, 0.0, 0.0));
        }
        return c;
    }

    public static CacheLoaderConfig buildSingleCacheLoaderConfig(boolean passivation, String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared, boolean purgeOnStartup, boolean ignoreModifications) throws Exception {
        CacheLoaderConfig clc = new CacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName(cacheloaderClass);
        iclc.setAsync(async);
        iclc.setFetchPersistentState(fetchPersistentState);
        iclc.setPurgeOnStartup(purgeOnStartup);
        iclc.setIgnoreModifications(ignoreModifications);
        iclc.setProperties(properties);
        clc.addIndividualCacheLoaderConfig(iclc);
        clc.setPassivation(passivation);
        clc.setShared(shared);
        clc.setPreload(preload);
        return clc;
    }

    public static CacheLoaderConfig.IndividualCacheLoaderConfig buildIndividualCacheLoaderConfig(String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean purgeOnStartup, boolean ignoreModifications) throws Exception {
        return UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(false, preload, cacheloaderClass, properties, async, fetchPersistentState, false, purgeOnStartup, ignoreModifications).getFirstCacheLoaderConfig();
    }

    public static String getClusterConfigFromFile(URL url) {
        try {
            XmlConfigurator conf = XmlConfigurator.getInstance((URL)url);
            String tmp = conf.getProtocolStackString();
            tmp = tmp.replace("${jgroups.udp.mcast_addr:228.10.10.10}", "228.10.10.10");
            tmp = tmp.replace("${jgroups.udp.mcast_port:45588}", "45588");
            tmp = tmp.replace("${jgroups.udp.ip_ttl:2}", "2");
            return tmp;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems with url " + url, e);
        }
    }

    public static String getClusterConfigFromProperties(String properties) {
        try {
            XmlConfigurator conf = XmlConfigurator.getInstance((InputStream)ConfiguratorFactory.getConfigStream((String)properties));
            String tmp = conf.getProtocolStackString();
            tmp = tmp.replace("${jgroups.udp.mcast_addr:228.10.10.10}", "228.10.10.10");
            tmp = tmp.replace("${jgroups.udp.mcast_port:45588}", "45588");
            tmp = tmp.replace("${jgroups.udp.ip_ttl:2}", "2");
            System.out.println("config string: " + tmp);
            return tmp;
        }
        catch (Exception e) {
            throw new RuntimeException("Problems with properties " + properties, e);
        }
    }

    public static String injectDelay(String jgroupsConfigString, int incomingDelay, int outgoingDelay) {
        String delay = ":DELAY(in_delay=" + incomingDelay + ";out_delay=" + outgoingDelay + ")";
        return jgroupsConfigString.substring(0, jgroupsConfigString.indexOf(":")) + delay + jgroupsConfigString.substring(jgroupsConfigString.indexOf(":"));
    }

    public static String injectDiscard(String jgroupsConfigString, double up, double down) {
        String delay = ":DISCARD(up=" + up + ";down=" + down + ")";
        return jgroupsConfigString.substring(0, jgroupsConfigString.indexOf(":")) + delay + jgroupsConfigString.substring(jgroupsConfigString.indexOf(":"));
    }

    private static class UnitTestXmlConfigurationParser
    extends XmlConfigurationParser {
        private UnitTestXmlConfigurationParser() {
        }

        public Configuration parseFile(String filename, Configuration.CacheMode mode) {
            String finalFileName = filename == null ? UnitTestCacheConfigurationFactory.DEFAULT_CONFIGURATION_FILE : filename;
            return this.parseStream(new FileLookup().lookupFile(finalFileName), mode);
        }

        public Configuration parseStream(InputStream stream, Configuration.CacheMode mode) {
            if (stream == null) {
                throw new ConfigurationException("Input stream for configuration xml is null!");
            }
            Element root = XmlConfigHelper.getDocumentRoot((InputStream)stream);
            UnitTestXmlConfigurationParser parser = new UnitTestXmlConfigurationParser();
            Configuration conf = parser.parseElement(root);
            Element list = (Element)root.getElementsByTagNameNS("*", "protocol_stacks").item(0);
            NodeList stacks = list.getElementsByTagNameNS("*", "stack");
            for (int i = 0; i < stacks.getLength(); ++i) {
                Element stack = (Element)stacks.item(i);
                String stackName = stack.getAttribute("name");
                if (!stackName.startsWith(JGROUPS_CHANNEL)) continue;
                Element jgroupsStack = (Element)stack.getElementsByTagNameNS("*", "config").item(0);
                if (mode == Configuration.CacheMode.REPL_ASYNC && !stackName.contains("-")) {
                    conf.setClusterConfig(jgroupsStack);
                    conf.setCacheMode(Configuration.CacheMode.REPL_ASYNC);
                    break;
                }
                if (mode != Configuration.CacheMode.REPL_SYNC || !stackName.contains("-")) continue;
                conf.setClusterConfig(jgroupsStack);
                conf.setCacheMode(Configuration.CacheMode.REPL_SYNC);
                break;
            }
            conf.setCacheMode(mode);
            return conf;
        }
    }
}

