/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invalidation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ReplicationListener;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"}, sequential=true)
public class InvalidationInterceptorTest {
    private static Log log = LogFactory.getLog(InvalidationInterceptorTest.class);
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    private Set<CacheSPI> toClean = new HashSet<CacheSPI>();

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2});
        for (CacheSPI c : this.toClean) {
            TestingUtil.killCaches(new Cache[]{c});
        }
        this.toClean.clear();
    }

    public void testPessimisticNonTransactional() throws Exception {
        this.cache1 = this.createCache(false);
        this.cache2 = this.createCache(false);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        this.cache1.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"Should NOT have replicated!", (Object)this.cache2.getNode(fqn));
        log.info((Object)"***** Node not replicated, as expected.");
        this.cache2.put(fqn, (Object)"key", (Object)"value");
        NodeSPI n = this.cache1.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n, "Should have been invalidated");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        this.cache1.put(fqn, (Object)"key2", (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        n = this.cache2.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n, "Should have been invalidated");
    }

    public void testUnnecessaryEvictions() throws Exception {
        this.cache1 = this.createCache(false);
        this.cache2 = this.createCache(false);
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        this.cache1.put(fqn1, (Object)"hello", (Object)"world");
        AssertJUnit.assertEquals((Object)"world", (Object)this.cache1.get(fqn1, (Object)"hello"));
        AssertJUnit.assertNull((Object)this.cache2.get(fqn1, (Object)"hello"));
        this.cache2.put(fqn2, (Object)"hello", (Object)"world");
        AssertJUnit.assertEquals((Object)"world", (Object)this.cache1.get(fqn1, (Object)"hello"));
        AssertJUnit.assertNull((Object)this.cache2.get(fqn1, (Object)"hello"));
        AssertJUnit.assertEquals((Object)"world", (Object)this.cache2.get(fqn2, (Object)"hello"));
        AssertJUnit.assertNull((Object)this.cache1.get(fqn2, (Object)"hello"));
        this.cache2.put(fqn1, (Object)"hello", (Object)"world");
        AssertJUnit.assertEquals((Object)"world", (Object)this.cache2.get(fqn1, (Object)"hello"));
        AssertJUnit.assertEquals((Object)"world", (Object)this.cache2.get(fqn2, (Object)"hello"));
        AssertJUnit.assertNull((Object)this.cache1.get(fqn1, (Object)"hello"));
        AssertJUnit.assertNull((Object)this.cache1.get(fqn2, (Object)"hello"));
    }

    public void testPessimisticNonTransactionalAsync() throws Exception {
        this.cache1 = this.createUnstartedCache(false);
        this.cache2 = this.createUnstartedCache(false);
        this.cache1.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
        this.cache2.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
        this.cache1.start();
        this.cache2.start();
        Fqn fqn = Fqn.fromString((String)"/a/b");
        ReplicationListener replListener1 = new ReplicationListener((Cache)this.cache1);
        ReplicationListener replListener2 = new ReplicationListener((Cache)this.cache2);
        replListener2.expectAny();
        this.cache1.put(fqn, (Object)"key", (Object)"value");
        replListener2.waitForReplicationToOccur(500L);
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"Should NOT have replicated!", (Object)this.cache2.getNode(fqn));
        replListener1.expectAny();
        this.cache2.put(fqn, (Object)"key", (Object)"value");
        replListener1.waitForReplicationToOccur(500L);
        NodeSPI n = this.cache1.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n, "Should have been invalidated");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        replListener2.expectAny();
        this.cache1.put(fqn, (Object)"key2", (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        replListener2.waitForReplicationToOccur(500L);
        n = this.cache2.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n, "Should have been invalidated");
    }

    public void testPessimisticTransactional() throws Exception {
        this.cache1 = this.createCache(false);
        this.cache2 = this.createCache(false);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        this.cache1.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"Should NOT have replicated!", (Object)this.cache2.getNode(fqn));
        log.info((Object)"***** Node not replicated, as expected.");
        TransactionManager txm = this.cache2.getTransactionManager();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)"key"));
        txm.begin();
        this.cache2.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        txm.commit();
        NodeSPI n = this.cache1.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n, "Should have been invalidated");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        txm = this.cache1.getTransactionManager();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        txm.begin();
        this.cache1.put(fqn, (Object)"key2", (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        txm.commit();
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        n = this.cache2.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n, "Should have been invalidated");
        txm = this.cache2.getTransactionManager();
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        txm.begin();
        this.cache2.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        txm.rollback();
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        n = this.cache2.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n, "Should have been invalidated");
    }

    public void testOptSyncUnableToEvict() throws Exception {
        this.cache1 = this.createCache(true);
        this.cache2 = this.createCache(true);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        this.cache2.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        NodeSPI n = this.cache1.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n, "Should have been invalidated");
        this.assertHasBeenInvalidated((Node)this.cache1.peek(fqn, true, true), "Should have been invalidated");
        TransactionManager mgr1 = this.cache1.getTransactionManager();
        TransactionManager mgr2 = this.cache2.getTransactionManager();
        mgr1.begin();
        this.cache1.put(fqn, (Object)"key2", (Object)"value2");
        Transaction tx1 = mgr1.suspend();
        mgr2.begin();
        this.cache2.put(fqn, (Object)"key3", (Object)"value3");
        Transaction tx2 = mgr2.suspend();
        mgr1.resume(tx1);
        try {
            mgr1.commit();
            AssertJUnit.assertTrue((String)"Ought to have succeeded!", (boolean)true);
        }
        catch (RollbackException roll) {
            AssertJUnit.assertTrue((String)"Ought to have succeeded!", (boolean)false);
        }
        mgr2.resume(tx2);
        try {
            mgr2.commit();
            AssertJUnit.assertTrue((String)"Ought to have failed!", (boolean)false);
        }
        catch (RollbackException roll) {
            AssertJUnit.assertTrue((String)"Ought to have failed!", (boolean)true);
        }
    }

    public void testPessTxSyncUnableToEvict() throws Exception {
        this.cache1 = this.createCache(false);
        this.cache2 = this.createCache(false);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        this.cache1.put("/a/b", (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertNull((Object)this.cache2.getNode(fqn));
        TransactionManager mgr1 = this.cache1.getTransactionManager();
        TransactionManager mgr2 = this.cache2.getTransactionManager();
        mgr1.begin();
        this.cache1.put(fqn, (Object)"key2", (Object)"value2");
        Transaction tx1 = mgr1.suspend();
        mgr2.begin();
        this.cache2.put(fqn, (Object)"key3", (Object)"value3");
        Transaction tx2 = mgr2.suspend();
        mgr1.resume(tx1);
        try {
            mgr1.commit();
            AssertJUnit.assertTrue((String)"Ought to have failed!", (boolean)false);
        }
        catch (RollbackException roll) {
            AssertJUnit.assertTrue((String)"Ought to have failed!", (boolean)true);
        }
        mgr2.resume(tx2);
        try {
            mgr2.commit();
            AssertJUnit.assertTrue((String)"Ought to have succeeded!", (boolean)true);
        }
        catch (RollbackException roll) {
            AssertJUnit.assertTrue((String)"Ought to have succeeded!", (boolean)false);
        }
    }

    public void testPessTxAsyncUnableToEvict() throws Exception {
        this.cache1 = this.createUnstartedCache(false);
        this.cache2 = this.createUnstartedCache(false);
        this.cache1.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
        this.cache2.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
        this.cache1.start();
        this.cache2.start();
        Fqn fqn = Fqn.fromString((String)"/a/b");
        this.cache1.put("/a/b", (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertNull((Object)this.cache2.getNode(fqn));
        TransactionManager mgr1 = this.cache1.getTransactionManager();
        TransactionManager mgr2 = this.cache2.getTransactionManager();
        mgr1.begin();
        this.cache1.put(fqn, (Object)"key2", (Object)"value2");
        Transaction tx1 = mgr1.suspend();
        mgr2.begin();
        this.cache2.put(fqn, (Object)"key3", (Object)"value3");
        Transaction tx2 = mgr2.suspend();
        mgr1.resume(tx1);
        try {
            mgr1.commit();
            AssertJUnit.assertTrue((String)"Ought to have succeeded!", (boolean)true);
        }
        catch (RollbackException roll) {
            AssertJUnit.assertTrue((String)"Ought to have succeeded!", (boolean)false);
        }
        mgr2.resume(tx2);
        try {
            mgr2.commit();
            AssertJUnit.assertTrue((String)"Ought to have succeeded!", (boolean)true);
        }
        catch (RollbackException roll) {
            AssertJUnit.assertTrue((String)"Ought to have succeeded!", (boolean)false);
        }
    }

    public void testPessimisticNodeRemoval() throws Exception {
        this.nodeRemovalTest(false);
    }

    public void testOptimisticNodeRemoval() throws Exception {
        this.nodeRemovalTest(true);
    }

    private void nodeRemovalTest(boolean optimistic) throws Exception {
        this.cache1 = this.createCache(optimistic);
        this.cache2 = this.createCache(optimistic);
        NodeSPI root1 = this.cache1.getRoot();
        NodeSPI root2 = this.cache2.getRoot();
        Fqn fqn = Fqn.fromString((String)"/test/fqn");
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache1.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)"key"));
        this.cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache2.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.cache1.removeNode(fqn));
        AssertJUnit.assertFalse((boolean)root1.hasChild(fqn));
        Node remoteNode = root2.getChild(fqn);
        this.checkRemoteNodeIsRemoved((Node<Object, Object>)remoteNode);
        AssertJUnit.assertEquals((boolean)false, (boolean)this.cache1.removeNode(fqn));
        Fqn child = Fqn.fromString((String)"/test/fqn/child");
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache1.put(child, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(child, (Object)"key"));
        this.cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache2.put(child, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(child, (Object)"key"));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.cache1.removeNode(fqn));
        AssertJUnit.assertFalse((boolean)root1.hasChild(fqn));
        remoteNode = root2.getChild(fqn);
        this.checkRemoteNodeIsRemoved((Node<Object, Object>)remoteNode);
        AssertJUnit.assertEquals((boolean)false, (boolean)this.cache1.removeNode(fqn));
    }

    private void checkRemoteNodeIsRemoved(Node<Object, Object> remoteNode) {
        this.assertHasBeenInvalidated(remoteNode, "Should have been removed");
        if (remoteNode != null) {
            for (Node child : remoteNode.getChildren()) {
                this.checkRemoteNodeIsRemoved((Node<Object, Object>)child);
            }
        }
    }

    public void testPessimisticNodeResurrection() throws Exception {
        this.nodeResurrectionTest(false);
    }

    public void testOptimisticNodeResurrection() throws Exception {
        this.nodeResurrectionTest(true);
    }

    private void nodeResurrectionTest(boolean optimistic) throws Exception {
        this.cache1 = this.createCache(optimistic);
        this.cache2 = this.createCache(optimistic);
        Fqn fqn = Fqn.fromString((String)"/test/fqn1");
        this.cache1.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals(null, (Object)this.cache2.get(fqn, (Object)"key"));
        this.cache1.put(fqn, (Object)"key", (Object)"newValue");
        AssertJUnit.assertEquals((Object)"newValue", (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals(null, (Object)this.cache2.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.cache1.removeNode(fqn));
        AssertJUnit.assertEquals(null, (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals(null, (Object)this.cache2.get(fqn, (Object)"key"));
        this.cache1.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals(null, (Object)this.cache2.get(fqn, (Object)"key"));
        fqn = Fqn.fromString((String)"/test/fqn2");
        this.cache1.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals(null, (Object)this.cache2.get(fqn, (Object)"key"));
        this.cache1.put(fqn, (Object)"key", (Object)"newValue");
        AssertJUnit.assertEquals((Object)"newValue", (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals(null, (Object)this.cache2.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.cache1.removeNode(fqn));
        AssertJUnit.assertEquals(null, (Object)this.cache1.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals(null, (Object)this.cache2.get(fqn, (Object)"key"));
        this.cache2.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals(null, (Object)this.cache1.get(fqn, (Object)"key"));
    }

    public void testPessimisticNodeResurrection2() throws Exception {
        this.nodeResurrectionTest2(false);
    }

    public void testOptimisticNodeResurrection2() throws Exception {
        this.nodeResurrectionTest2(true);
    }

    private void nodeResurrectionTest2(boolean optimistic) throws Exception {
        this.cache1 = this.createCache(optimistic);
        this.cache2 = this.createCache(optimistic);
        NodeSPI root1 = this.cache1.getRoot();
        NodeSPI root2 = this.cache2.getRoot();
        Fqn fqn = Fqn.fromString((String)"/test/fqn");
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        root1.addChild(fqn);
        AssertJUnit.assertEquals((boolean)true, (boolean)root1.hasChild(fqn));
        this.cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        root1.addChild(fqn);
        AssertJUnit.assertEquals((boolean)true, (boolean)root1.hasChild(fqn));
        Fqn child = Fqn.fromRelativeElements((Fqn)fqn, (Object[])new String[]{"child"});
        this.cache1.putForExternalRead(child, (Object)"key", (Object)"value");
        this.cache2.putForExternalRead(child, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(child, (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(child, (Object)"key"));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.cache1.removeNode(fqn));
        AssertJUnit.assertFalse((boolean)root1.hasChild(fqn));
        this.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        root1.addChild(fqn);
        AssertJUnit.assertEquals((boolean)true, (boolean)root1.hasChild(fqn));
        Node remoteNode = root2.getChild(fqn);
        this.checkRemoteNodeIsRemoved((Node<Object, Object>)remoteNode);
        this.cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        root2.addChild(fqn);
        AssertJUnit.assertEquals((boolean)true, (boolean)root2.hasChild(fqn));
    }

    private void dumpVersionInfo(CacheSPI c1, CacheSPI c2, Fqn fqn) {
        System.out.println("**** Versin Info for Fqn [" + fqn + "] ****");
        NodeSPI n1 = c1.getRoot().getChildDirect(fqn);
        System.out.println("  Cache 1: " + n1.getVersion() + " dataLoaded? " + n1.isDataLoaded());
        NodeSPI n2 = c2.getRoot().getChildDirect(fqn);
        System.out.println("  Cache 2: " + n2.getVersion() + " dataLoaded? " + n2.isDataLoaded());
    }

    public void testOptimistic() throws Exception {
        this.cache1 = this.createCache(true);
        this.cache2 = this.createCache(true);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        this.cache1.put(fqn, (Object)"key", (Object)"value");
        this.dumpVersionInfo(this.cache1, this.cache2, fqn);
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)"key"));
        NodeSPI n2 = this.cache2.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n2, "Should have been invalidated");
        this.assertHasBeenInvalidated((Node)this.cache2.peek(fqn, true, true), "Should have been invalidated");
        this.cache2.put(fqn, (Object)"key", (Object)"value");
        this.dumpVersionInfo(this.cache1, this.cache2, fqn);
        NodeSPI n1 = this.cache1.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n1, "Should have been invalidated");
        this.assertHasBeenInvalidated((Node)this.cache1.peek(fqn, true, true), "Should have been invalidated");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        this.cache1.put(fqn, (Object)"key2", (Object)"value2");
        this.dumpVersionInfo(this.cache1, this.cache2, fqn);
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        n2 = this.cache2.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n2, "Should have been invalidated");
        this.assertHasBeenInvalidated((Node)this.cache2.peek(fqn, false, false), "Should have been invalidated");
        TransactionManager txm = this.cache2.getTransactionManager();
        txm.begin();
        this.cache2.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        txm.commit();
        n1 = this.cache1.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n1, "Should have been invalidated");
        this.assertHasBeenInvalidated((Node)this.cache1.peek(fqn, false, false), "Should have been invalidated");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        txm = this.cache1.getTransactionManager();
        txm.begin();
        this.cache1.put(fqn, (Object)"key2", (Object)"value2");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        txm.commit();
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        n2 = this.cache2.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n2, "Should have been invalidated");
        this.assertHasBeenInvalidated((Node)this.cache2.peek(fqn, false, false), "Should have been invalidated");
        txm = this.cache2.getTransactionManager();
        txm.begin();
        this.cache2.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)"key"));
        txm.rollback();
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)"key2"));
        n2 = this.cache2.getNode(fqn);
        this.assertHasBeenInvalidated((Node)n2, "Should have been invalidated");
        this.assertHasBeenInvalidated((Node)this.cache2.peek(fqn, false, false), "Should have been invalidated");
    }

    public void testPessimisticNonTransactionalWithCacheLoader() throws Exception {
        List<CacheSPI<Object, Object>> caches = this.createCachesWithSharedCL(false);
        this.cache1 = caches.get(0);
        this.cache2 = caches.get(1);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        caches.get(0).put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        caches.get(1).put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        caches.get(0).put(fqn, (Object)"key2", (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)caches.get(0).get(fqn, (Object)"key2"));
        AssertJUnit.assertEquals((Object)"value2", (Object)caches.get(1).get(fqn, (Object)"key2"));
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
    }

    public void testPessimisticTransactionalWithCacheLoader() throws Exception {
        List<CacheSPI<Object, Object>> caches = this.createCachesWithSharedCL(false);
        this.cache1 = caches.get(0);
        this.cache2 = caches.get(1);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        TransactionManager mgr = caches.get(0).getTransactionManager();
        AssertJUnit.assertNull((String)"Should be null", (Object)caches.get(0).get(fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key"));
        mgr.begin();
        caches.get(0).put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        mgr.commit();
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        mgr.begin();
        caches.get(0).put(fqn, (Object)"key2", (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)caches.get(0).get(fqn, (Object)"key2"));
        mgr.rollback();
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"Should be null", (Object)caches.get(0).get(fqn, (Object)"key2"));
        AssertJUnit.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key2"));
    }

    public void testOptimisticWithCacheLoader() throws Exception {
        List<CacheSPI<Object, Object>> caches = this.createCachesWithSharedCL(true);
        this.cache1 = caches.get(0);
        this.cache2 = caches.get(1);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        TransactionManager mgr = caches.get(0).getTransactionManager();
        AssertJUnit.assertNull((String)"Should be null", (Object)caches.get(0).get(fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key"));
        mgr.begin();
        caches.get(0).put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key"));
        mgr.commit();
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        mgr.begin();
        caches.get(0).put(fqn, (Object)"key2", (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)caches.get(0).get(fqn, (Object)"key2"));
        AssertJUnit.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key2"));
        mgr.rollback();
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(1).get(fqn, (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)caches.get(0).get(fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"Should be null", (Object)caches.get(0).get(fqn, (Object)"key2"));
        AssertJUnit.assertNull((String)"Should be null", (Object)caches.get(1).get(fqn, (Object)"key2"));
    }

    public void testInvalidationWithRegionBasedMarshalling() throws Exception {
        this.doRegionBasedTest(false);
    }

    public void testInvalidationWithRegionBasedMarshallingOptimistic() throws Exception {
        this.doRegionBasedTest(true);
    }

    protected void doRegionBasedTest(boolean optimistic) throws Exception {
        ArrayList<CacheSPI<Object, Object>> caches = new ArrayList<CacheSPI<Object, Object>>();
        caches.add(this.createUnstartedCache(false));
        caches.add(this.createUnstartedCache(false));
        this.cache1 = (CacheSPI)caches.get(0);
        this.cache2 = (CacheSPI)caches.get(1);
        ((CacheSPI)caches.get(0)).getConfiguration().setUseRegionBasedMarshalling(true);
        ((CacheSPI)caches.get(1)).getConfiguration().setUseRegionBasedMarshalling(true);
        if (optimistic) {
            ((CacheSPI)caches.get(0)).getConfiguration().setNodeLockingScheme("OPTIMISTIC");
            ((CacheSPI)caches.get(1)).getConfiguration().setNodeLockingScheme("OPTIMISTIC");
        }
        ((CacheSPI)caches.get(0)).start();
        ((CacheSPI)caches.get(1)).start();
        TestingUtil.blockUntilViewsReceived(caches.toArray(new CacheSPI[0]), 5000L);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)caches.get(0)).getNode(fqn));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheSPI)caches.get(1)).getNode(fqn));
        ((CacheSPI)caches.get(0)).put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"expecting value", (Object)"value", (Object)((CacheSPI)caches.get(0)).get(fqn, (Object)"key"));
        NodeSPI n = ((CacheSPI)caches.get(1)).getNode(fqn);
        this.assertHasBeenInvalidated((Node)n, "Should have been invalidated");
        ((CacheSPI)caches.get(1)).put(fqn, (Object)"key", (Object)"value2");
        AssertJUnit.assertEquals((String)"expecting value2", (Object)"value2", (Object)((CacheSPI)caches.get(1)).get(fqn, (Object)"key"));
        n = ((CacheSPI)caches.get(0)).getNode(fqn);
        this.assertHasBeenInvalidated((Node)n, "Should have been invalidated");
    }

    public void testDeleteNonExistentPessimistic() throws Exception {
        this.deleteNonExistentTest(false);
    }

    public void testDeleteNonExistentOptimistic() throws Exception {
        this.deleteNonExistentTest(true);
    }

    private void deleteNonExistentTest(boolean optimistic) throws Exception {
        ArrayList<CacheSPI<Object, Object>> caches = new ArrayList<CacheSPI<Object, Object>>();
        caches.add(this.createUnstartedCache(optimistic));
        caches.add(this.createUnstartedCache(optimistic));
        this.cache1 = (CacheSPI)caches.get(0);
        this.cache2 = (CacheSPI)caches.get(1);
        this.cache1.start();
        this.cache2.start();
        TestingUtil.blockUntilViewsReceived(caches.toArray(new CacheSPI[0]), 5000L);
        Fqn fqn = Fqn.fromString((String)"/a/b");
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache1.getNode(fqn));
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache2.getNode(fqn));
        this.cache1.putForExternalRead(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.getNode(fqn).get((Object)"key"));
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache2.getNode(fqn));
        TransactionManager tm = this.cache2.getTransactionManager();
        tm.begin();
        try {
            this.cache2.removeNode(fqn);
            tm.commit();
        }
        catch (Exception e) {
            String msg = "Unable to remove non-existent node " + fqn;
            log.error((Object)msg, (Throwable)e);
            AssertJUnit.fail((String)(msg + " -- " + e));
        }
        this.assertHasBeenInvalidated((Node)this.cache1.getNode(fqn), "Should have been invalidated");
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache2.getNode(fqn));
    }

    public void testAddOfDeletedNonExistent() throws Exception {
        this.cache1 = this.createCache(true);
        this.cache2 = this.createCache(true);
        TestingUtil.blockUntilViewsReceived(5000L, new Cache[]{this.cache1, this.cache2});
        Fqn fqn = Fqn.fromString((String)"/a/b");
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache1.getNode(fqn));
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache2.getNode(fqn));
        TransactionManager tm = this.cache2.getTransactionManager();
        tm.begin();
        try {
            this.cache2.removeNode(fqn);
            tm.commit();
        }
        catch (Exception e) {
            String msg = "Unable to remove non-existent node " + fqn;
            log.error((Object)msg, (Throwable)e);
            AssertJUnit.fail((String)(msg + " -- " + e));
        }
        this.assertHasBeenInvalidated((Node)this.cache1.getNode(fqn), "Should have been invalidated");
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache2.getNode(fqn));
        this.cache1.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new DefaultDataVersion());
        this.cache1.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.getNode(fqn).get((Object)"key"));
        this.assertHasBeenInvalidated((Node)this.cache2.getNode(fqn), "Should have been invalidated");
    }

    protected CacheSPI<Object, Object> createUnstartedCache(boolean optimistic) throws Exception {
        Configuration c = new Configuration();
        c.setStateRetrievalTimeout(3000L);
        c.setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
        if (optimistic) {
            c.setNodeLockingScheme("OPTIMISTIC");
        }
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        this.toClean.add(cache);
        return cache;
    }

    protected CacheSPI<Object, Object> createCache(boolean optimistic) throws Exception {
        CacheSPI<Object, Object> cache = this.createUnstartedCache(optimistic);
        cache.start();
        this.toClean.add(cache);
        return cache;
    }

    protected List<CacheSPI<Object, Object>> createCachesWithSharedCL(boolean optimistic) throws Exception {
        ArrayList<CacheSPI<Object, Object>> caches = new ArrayList<CacheSPI<Object, Object>>();
        caches.add(this.createUnstartedCache(optimistic));
        caches.add(this.createUnstartedCache(optimistic));
        ((CacheSPI)caches.get(0)).getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig());
        ((CacheSPI)caches.get(1)).getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig());
        ((CacheSPI)caches.get(0)).start();
        ((CacheSPI)caches.get(1)).start();
        this.toClean.addAll(caches);
        return caches;
    }

    protected CacheLoaderConfig getCacheLoaderConfig() throws Exception {
        return UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(false, "", "org.jboss.cache.loader.DummySharedInMemoryCacheLoader", "", false, false, false, false, false);
    }

    protected void assertHasBeenInvalidated(Node n, String message) {
        if (n != null) assert (!n.isValid()) : message;
    }
}

