/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.interceptors.CacheMgmtInterceptor;
import org.jboss.cache.jmx.JmxRegistrationManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class JmxRegistrationManagerTest {
    private UnitTestCacheFactory cacheFactory = new UnitTestCacheFactory();
    private MBeanServer mBeanServer;

    @BeforeMethod
    public void setUp() {
        this.mBeanServer = MBeanServerFactory.createMBeanServer();
    }

    @AfterMethod
    public void tearDown() {
        MBeanServerFactory.releaseMBeanServer(this.mBeanServer);
    }

    public void testRegisterLocalCache() throws Exception {
        Configuration localConfig = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL);
        localConfig.setExposeManagementStatistics(true);
        Cache cache = this.cacheFactory.createCache(localConfig);
        JmxRegistrationManager regManager = new JmxRegistrationManager(this.mBeanServer, cache, (ObjectName)null);
        assert (regManager.getObjectNameBase().indexOf("jboss.cache:service=JBossCache,uniqueId=") == 0);
        regManager.registerAllMBeans();
        String name = regManager.getObjectName(CacheMgmtInterceptor.class.getSimpleName());
        assert (this.mBeanServer.isRegistered(new ObjectName(name)));
        regManager.unregisterAllMBeans();
        assert (!this.mBeanServer.isRegistered(new ObjectName(name)));
        cache.stop();
    }

    public void testRegisterReplicatedCache() throws Exception {
        Configuration localConfig = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        localConfig.setExposeManagementStatistics(true);
        Cache cache = this.cacheFactory.createCache(localConfig);
        JmxRegistrationManager regManager = new JmxRegistrationManager(this.mBeanServer, cache, (ObjectName)null);
        assert (regManager.getObjectNameBase().indexOf("jboss.cache:service=JBossCache,cluster=") == 0);
        regManager.registerAllMBeans();
        String name = regManager.getObjectName(CacheMgmtInterceptor.class.getSimpleName());
        assert (this.mBeanServer.isRegistered(new ObjectName(name)));
        regManager.unregisterAllMBeans();
        assert (!this.mBeanServer.isRegistered(new ObjectName(name)));
        cache.stop();
    }

    @Test(enabled=false)
    public static void main(String[] args) {
        Configuration localConfig = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        localConfig.setExposeManagementStatistics(true);
        DefaultCacheFactory cacheFactory = new DefaultCacheFactory();
        Cache cache = cacheFactory.createCache(localConfig);
        JmxRegistrationManager regManager = new JmxRegistrationManager(cache);
        while (true) {
            // Infinite loop
        }
    }
}

