/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.List;
import java.util.Properties;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.element.LoadersElementParser;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.AbstractDelegatingCacheLoader;
import org.jboss.cache.loader.AsyncCacheLoader;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.loader.ChainingCacheLoader;
import org.jboss.cache.loader.FileCacheLoader;
import org.jboss.cache.loader.JDBCCacheLoader;
import org.jboss.cache.loader.SingletonStoreCacheLoader;
import org.jboss.cache.loader.SingletonStoreDefaultConfig;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"}, sequential=true)
public class CacheLoaderManagerTest
extends AbstractCacheLoaderTestBase {
    private LoadersElementParser loadersElementParser = new LoadersElementParser();

    private CacheLoaderConfig createCacheLoaderCfg(boolean passivation) {
        CacheLoaderConfig cfg = new CacheLoaderConfig();
        cfg.setPassivation(passivation);
        return cfg;
    }

    private CacheLoaderConfig.IndividualCacheLoaderConfig createIndividualCacheLoaderConfig(CacheLoaderConfig parent, boolean async, String classname) {
        CacheLoaderConfig.IndividualCacheLoaderConfig cfg = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        cfg.setAsync(async);
        cfg.setClassName(classname);
        cfg.setFetchPersistentState(false);
        Properties p = new Properties();
        p.setProperty("location", this.getTempDir());
        p.setProperty("cache.jdbc.driver", "com.mysql.jdbc.Driver");
        p.setProperty("cache.jdbc.url", "jdbc:mysql://localhost/test");
        p.setProperty("cache.jdbc.user", "user");
        p.setProperty("cache.jdbc.password", "pwd");
        cfg.setProperties(p);
        return cfg;
    }

    private String getTempDir() {
        return System.getProperty("java.io.tempdir", "/tmp");
    }

    private static Element strToElement(String s) throws Exception {
        return XmlConfigHelper.stringToElementInCoreNS((String)s);
    }

    public void testSingleCacheLoader() throws Exception {
        CacheLoaderManager mgr = new CacheLoaderManager();
        CacheLoaderConfig cfg = this.createCacheLoaderCfg(false);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.FileCacheLoader"));
        mgr.setConfig(cfg, null, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(FileCacheLoader.class, cl.getClass());
        cfg = this.createCacheLoaderCfg(false);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader"));
        mgr.setConfig(cfg, null, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(AsyncCacheLoader.class, cl.getClass());
    }

    public void testSingleCacheLoaderPassivation() throws Exception {
        CacheLoaderConfig cfg = this.createCacheLoaderCfg(true);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.FileCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.bdbje.BdbjeCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.JDBCCacheLoader"));
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(cfg, null, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(FileCacheLoader.class, cl.getClass());
        cfg = this.createCacheLoaderCfg(true);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.bdbje.BdbjeCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.JDBCCacheLoader"));
        mgr.setConfig(cfg, null, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(AsyncCacheLoader.class, cl.getClass());
    }

    public void testSingleCacheLoaderFromXml() throws Exception {
        CacheLoaderConfig clc = this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.FileCacheLoader", "location=" + this.getTempDir(), false, false, false);
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(FileCacheLoader.class, cl.getClass());
        clc = this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.FileCacheLoader", "location=" + this.getTempDir(), true, false, false);
        mgr.setConfig(clc, null, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(AsyncCacheLoader.class, cl.getClass());
    }

    public void testSingleCacheLoaderPassivationFromXml() throws Exception {
        CacheLoaderConfig clc = UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(true, "", "org.jboss.cache.loader.FileCacheLoader", "location=" + this.getTempDir(), false, false, false, false, false);
        CacheLoaderConfig bdbjeCl = UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(true, "", "org.jboss.cache.loader.bdbje.BdbjeCacheLoader", "location=" + this.getTempDir(), false, false, false, false, false);
        CacheLoaderConfig jdbCl = UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(true, "", "org.jboss.cache.loader.JDBCCacheLoader", "location=" + this.getTempDir(), false, false, false, false, false);
        clc.getIndividualCacheLoaderConfigs().add(bdbjeCl.getFirstCacheLoaderConfig());
        clc.getIndividualCacheLoaderConfigs().add(jdbCl.getFirstCacheLoaderConfig());
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(FileCacheLoader.class, cl.getClass());
        clc = UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(true, "", "org.jboss.cache.loader.FileCacheLoader", "location=" + this.getTempDir(), true, false, false, false, false);
        bdbjeCl = UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(true, "", "org.jboss.cache.loader.bdbje.BdbjeCacheLoader", "location=" + this.getTempDir(), true, false, false, false, false);
        jdbCl = UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(true, "", "org.jboss.cache.loader.JDBCCacheLoader", "location=" + this.getTempDir(), true, false, false, false, false);
        clc.getIndividualCacheLoaderConfigs().add(bdbjeCl.getFirstCacheLoaderConfig());
        clc.getIndividualCacheLoaderConfigs().add(jdbCl.getFirstCacheLoaderConfig());
        mgr.setConfig(clc, null, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(AsyncCacheLoader.class, cl.getClass());
    }

    public void testChainingCacheLoader() throws Exception {
        CacheLoaderConfig cfg = this.createCacheLoaderCfg(false);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.FileCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.JDBCCacheLoader"));
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(cfg, null, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(ChainingCacheLoader.class, cl.getClass());
        AssertJUnit.assertEquals((int)2, (int)((ChainingCacheLoader)cl).getSize());
        List loaders = ((ChainingCacheLoader)cl).getCacheLoaders();
        AssertJUnit.assertEquals(FileCacheLoader.class, loaders.get(0).getClass());
        AssertJUnit.assertEquals(JDBCCacheLoader.class, loaders.get(1).getClass());
        cfg = this.createCacheLoaderCfg(false);
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, false, "org.jboss.cache.loader.FileCacheLoader"));
        cfg.addIndividualCacheLoaderConfig(this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.JDBCCacheLoader"));
        mgr.setConfig(cfg, null, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(ChainingCacheLoader.class, cl.getClass());
        AssertJUnit.assertEquals((int)2, (int)((ChainingCacheLoader)cl).getSize());
        loaders = ((ChainingCacheLoader)cl).getCacheLoaders();
        AssertJUnit.assertEquals(FileCacheLoader.class, loaders.get(0).getClass());
        AssertJUnit.assertEquals(AsyncCacheLoader.class, loaders.get(1).getClass());
    }

    public void testChainingCacheLoaderFromXml() throws Exception {
        CacheLoaderConfig clc = UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(false, "", "org.jboss.cache.loader.FileCacheLoader", "a=b", false, false, false, false, false);
        clc.addIndividualCacheLoaderConfig(UnitTestCacheConfigurationFactory.buildIndividualCacheLoaderConfig("", "org.jboss.cache.loader.JDBCCacheLoader", "cache.jdbc.driver=com.mysql.jdbc.Driver\ncache.jdbc.url=jdbc:mysql://localhost/test\ncache.jdbc.user=user\ncache.jdbc.password=pwd", false, false, false, false));
        CacheLoaderManager mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null, null);
        CacheLoader cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(ChainingCacheLoader.class, cl.getClass());
        AssertJUnit.assertEquals((int)2, (int)((ChainingCacheLoader)cl).getSize());
        List loaders = ((ChainingCacheLoader)cl).getCacheLoaders();
        AssertJUnit.assertEquals(FileCacheLoader.class, loaders.get(0).getClass());
        AssertJUnit.assertEquals(JDBCCacheLoader.class, loaders.get(1).getClass());
        clc = UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(false, "", "org.jboss.cache.loader.FileCacheLoader", "a=b", false, false, false, false, false);
        clc.addIndividualCacheLoaderConfig(UnitTestCacheConfigurationFactory.buildIndividualCacheLoaderConfig("", "org.jboss.cache.loader.JDBCCacheLoader", "cache.jdbc.driver=com.mysql.jdbc.Driver\ncache.jdbc.url=jdbc:mysql://localhost/test\ncache.jdbc.user=user\ncache.jdbc.password=pwd", true, false, false, false));
        mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null, null);
        cl = mgr.getCacheLoader();
        AssertJUnit.assertEquals(ChainingCacheLoader.class, cl.getClass());
        AssertJUnit.assertEquals((int)2, (int)((ChainingCacheLoader)cl).getSize());
        loaders = ((ChainingCacheLoader)cl).getCacheLoaders();
        AssertJUnit.assertEquals(FileCacheLoader.class, loaders.get(0).getClass());
        AssertJUnit.assertEquals(AsyncCacheLoader.class, loaders.get(1).getClass());
    }

    public void testMoreThanOneFetchPersistentState() throws Exception {
        CacheLoaderManager mgr = new CacheLoaderManager();
        CacheLoaderConfig cfg = this.createCacheLoaderCfg(false);
        CacheLoaderConfig.IndividualCacheLoaderConfig i = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i.setFetchPersistentState(true);
        CacheLoaderConfig.IndividualCacheLoaderConfig i2 = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i2.setFetchPersistentState(true);
        cfg.addIndividualCacheLoaderConfig(i);
        cfg.addIndividualCacheLoaderConfig(i2);
        AssertJUnit.assertEquals((int)2, (int)cfg.getIndividualCacheLoaderConfigs().size());
        try {
            mgr.setConfig(cfg, null, null);
            AssertJUnit.assertTrue((String)"Should throw exception since we have > 1 cache loader with fetchPersistentState as true", (boolean)false);
        }
        catch (Exception e) {
            AssertJUnit.assertTrue((boolean)true);
        }
        mgr = new CacheLoaderManager();
        cfg = this.createCacheLoaderCfg(false);
        i = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i.setFetchPersistentState(true);
        cfg.addIndividualCacheLoaderConfig(i);
        AssertJUnit.assertEquals((int)1, (int)cfg.getIndividualCacheLoaderConfigs().size());
        mgr.setConfig(cfg, null, null);
        mgr = new CacheLoaderManager();
        cfg = this.createCacheLoaderCfg(false);
        i = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i.setFetchPersistentState(true);
        i2 = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i2.setFetchPersistentState(false);
        cfg.addIndividualCacheLoaderConfig(i);
        cfg.addIndividualCacheLoaderConfig(i2);
        AssertJUnit.assertEquals((int)2, (int)cfg.getIndividualCacheLoaderConfigs().size());
        mgr.setConfig(cfg, null, null);
        mgr = new CacheLoaderManager();
        cfg = this.createCacheLoaderCfg(false);
        i = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i.setFetchPersistentState(false);
        i2 = this.createIndividualCacheLoaderConfig(cfg, true, "org.jboss.cache.loader.FileCacheLoader");
        i2.setFetchPersistentState(false);
        cfg.addIndividualCacheLoaderConfig(i);
        cfg.addIndividualCacheLoaderConfig(i2);
        AssertJUnit.assertEquals((int)2, (int)cfg.getIndividualCacheLoaderConfigs().size());
        mgr.setConfig(cfg, null, null);
    }

    public void testSingletonConfiguration() throws Exception {
        String conf = "<loaders passivation=\"false\">\n   <preload/>\n   <loader class=\"org.jboss.cache.loader.DummyInMemoryCacheLoader\">       <singletonStore enabled=\"true\"/>\n   </loader></loaders>";
        CacheLoaderConfig clc = this.loadersElementParser.parseLoadersElement(CacheLoaderManagerTest.strToElement(conf));
        MockCacheLoaderManager mgr = new MockCacheLoaderManager();
        mgr.setConfig(clc, null, null);
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNotNull((String)"Singleton has been configured", (Object)iclc.getSingletonStoreConfig());
        AssertJUnit.assertTrue((String)"Singleton should enabled", (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        AssertJUnit.assertEquals((String)"Singleton class should be default", (String)SingletonStoreCacheLoader.class.getName(), (String)iclc.getSingletonStoreConfig().getSingletonStoreClass());
        AssertJUnit.assertNotNull((String)"Singleton properties should be not null", (Object)iclc.getSingletonStoreConfig().getSingletonStoreproperties());
        AssertJUnit.assertTrue((String)"Singleton properties should be empty", (boolean)iclc.getSingletonStoreConfig().getSingletonStoreproperties().keySet().isEmpty());
        SingletonStoreDefaultConfig ssdc = ((SingletonStoreCacheLoader)mgr.getCacheLoader()).getSingletonStoreDefaultConfig();
        AssertJUnit.assertTrue((String)"Singleton pushStateWhenCoordinator should be true (default)", (boolean)ssdc.isPushStateWhenCoordinator());
        AssertJUnit.assertEquals((String)"Singleton pushStateWhenCoordinatorTimeout should be default value", (int)20000, (int)ssdc.getPushStateWhenCoordinatorTimeout());
        conf = "<loaders passivation=\"false\">\n   <preload/>\n   <loader class=\"org.jboss.cache.loader.DummyInMemoryCacheLoader\">       <singletonStore enabled=\"true\" class=\"org.jboss.cache.loader.CacheLoaderManagerTest$MockSingletonStoreCacheLoader\" />\n   </loader></loaders>";
        clc = this.loadersElementParser.parseLoadersElement(CacheLoaderManagerTest.strToElement(conf));
        mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null, null);
        iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNotNull((String)"Singleton has been configured", (Object)iclc.getSingletonStoreConfig());
        AssertJUnit.assertTrue((String)"Singleton should enabled", (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        AssertJUnit.assertEquals((String)"Singleton class should be a user defined one", (String)MockSingletonStoreCacheLoader.class.getName(), (String)iclc.getSingletonStoreConfig().getSingletonStoreClass());
        AssertJUnit.assertNotNull((String)"Singleton properties should be not null", (Object)iclc.getSingletonStoreConfig().getSingletonStoreproperties());
        AssertJUnit.assertTrue((String)"Singleton properties should be empty", (boolean)iclc.getSingletonStoreConfig().getSingletonStoreproperties().keySet().isEmpty());
        AssertJUnit.assertTrue((boolean)(mgr.getCacheLoader() instanceof MockSingletonStoreCacheLoader));
        conf = "   <loaders passivation=\"true\">\n      <preload/>\n      <loader class=\"org.jboss.cache.loader.DummyInMemoryCacheLoader\">\n         <singletonStore enabled=\"true\">\n            <properties>\n               pushStateWhenCoordinator=false\n            </properties>\n         </singletonStore>\n      </loader>\n   </loaders>";
        clc = this.loadersElementParser.parseLoadersElement(CacheLoaderManagerTest.strToElement(conf));
        mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null, null);
        iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNotNull((String)"Singleton has been configured", (Object)iclc.getSingletonStoreConfig());
        AssertJUnit.assertTrue((String)"Singleton should enabled", (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        AssertJUnit.assertEquals((String)"Singleton class should be default", (String)SingletonStoreCacheLoader.class.getName(), (String)iclc.getSingletonStoreConfig().getSingletonStoreClass());
        AssertJUnit.assertNotNull((String)"Singleton properties should be defined", (Object)iclc.getSingletonStoreConfig().getSingletonStoreproperties());
        ssdc = ((SingletonStoreCacheLoader)mgr.getCacheLoader()).getSingletonStoreDefaultConfig();
        AssertJUnit.assertFalse((String)"Singleton pushStateWhenCoordinator should be false", (boolean)ssdc.isPushStateWhenCoordinator());
        conf = "   <loaders passivation=\"true\">\n      <preload/>\n      <loader class=\"org.jboss.cache.loader.DummyInMemoryCacheLoader\">\n         <singletonStore enabled=\"true\">\n            <properties>\n                pushStateWhenCoordinator = true\n                pushStateWhenCoordinatorTimeout = 5000\n            </properties>\n         </singletonStore>\n      </loader>\n   </loaders>";
        clc = this.loadersElementParser.parseLoadersElement(CacheLoaderManagerTest.strToElement(conf));
        mgr = new CacheLoaderManager();
        mgr.setConfig(clc, null, null);
        iclc = mgr.getCacheLoaderConfig().getFirstCacheLoaderConfig();
        AssertJUnit.assertNotNull((String)"Singleton has been configured", (Object)iclc.getSingletonStoreConfig());
        AssertJUnit.assertTrue((String)"Singleton should enabled", (boolean)iclc.getSingletonStoreConfig().isSingletonStoreEnabled());
        AssertJUnit.assertEquals((String)"Singleton class should be default", (String)SingletonStoreCacheLoader.class.getName(), (String)iclc.getSingletonStoreConfig().getSingletonStoreClass());
        AssertJUnit.assertNotNull((String)"Singleton properties should not be defined", (Object)iclc.getSingletonStoreConfig().getSingletonStoreproperties());
        ssdc = ((SingletonStoreCacheLoader)mgr.getCacheLoader()).getSingletonStoreDefaultConfig();
        AssertJUnit.assertTrue((String)"Singleton pushStateWhenCoordinator should be true", (boolean)ssdc.isPushStateWhenCoordinator());
        AssertJUnit.assertEquals((String)"Singleton pushStateWhenCoordinatorTimeout should be default value", (int)5000, (int)ssdc.getPushStateWhenCoordinatorTimeout());
        conf = "   <loaders passivation=\"false\" shared=\"true\">\n      <preload/>\n      <loader class=\"org.jboss.cache.loader.DummyInMemoryCacheLoader\">\n         <singletonStore enabled=\"true\">\n            <properties>\n                pushStateWhenCoordinator = true\n                pushStateWhenCoordinatorTimeout = 5000\n            </properties>\n         </singletonStore>\n      </loader>\n   </loaders>";
        clc = this.loadersElementParser.parseLoadersElement(CacheLoaderManagerTest.strToElement(conf));
        mgr = new CacheLoaderManager();
        try {
            mgr.setConfig(clc, null, null);
            AssertJUnit.fail((String)"A cache loader cannot be configured as singleton and shared, should have thrown an Exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        conf = "   <loaders passivation=\"true\">\n      <preload/>\n      <loader class=\"org.jboss.cache.loader.DummyInMemoryCacheLoader\">\n         <singletonStore enabled=\"true\" class=\"org.jboss.cache.loader.DummyInMemoryCacheLoader\">\n         </singletonStore>\n      </loader>\n   </loaders>";
        clc = this.loadersElementParser.parseLoadersElement(CacheLoaderManagerTest.strToElement(conf));
        mgr = new CacheLoaderManager();
        try {
            mgr.setConfig(clc, null, null);
            AssertJUnit.fail((String)"A singleton store class implementation must extend AbstractDelegatingCacheLoader");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static class MockSingletonStoreCacheLoader
    extends AbstractDelegatingCacheLoader {
        public MockSingletonStoreCacheLoader() {
            super(null);
        }
    }

    private class MockCacheLoaderManager
    extends CacheLoaderManager {
        private MockCacheLoaderManager() {
        }

        protected void setCacheInLoader(CacheSPI c, CacheLoader loader) {
        }
    }
}

