/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.File;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.CacheLoaderTestsBase;
import org.jboss.cache.loader.DummySharedInMemoryCacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ChainingCacheLoaderBasicTest
extends CacheLoaderTestsBase {
    private static final String loc1 = "JBossCache-ChainingCacheLoaderBasicTest-1";
    private static final String loc2 = "JBossCache-ChainingCacheLoaderBasicTest-2";

    public ChainingCacheLoaderBasicTest() {
        File dir1 = new File(loc1);
        File dir2 = new File(loc2);
        if (!dir1.exists()) {
            dir1.mkdirs();
        }
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
    }

    protected void configureCache() throws Exception {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(loc1, loc2));
        TestingUtil.recursiveFileRemove(loc1);
        TestingUtil.recursiveFileRemove(loc2);
    }

    protected CacheLoaderConfig getCacheLoaderConfig(String loc1, String loc2) throws Exception {
        CacheLoaderConfig clc = new CacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName(DummySharedInMemoryCacheLoader.class.getName());
        iclc.setAsync(false);
        iclc.setFetchPersistentState(true);
        iclc.setPurgeOnStartup(false);
        iclc.setIgnoreModifications(false);
        iclc.setProperties("bin=" + loc1);
        clc.addIndividualCacheLoaderConfig(iclc);
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc2 = iclc.clone();
        iclc2.setFetchPersistentState(false);
        iclc2.setProperties("bin=" + loc2);
        clc.addIndividualCacheLoaderConfig(iclc2);
        clc.setPassivation(false);
        clc.setShared(false);
        return clc;
    }
}

