/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.JDBCCacheLoader;
import org.jboss.cache.transaction.GenericTransactionManagerLookup;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class JDBCCacheLoaderStateTransferTest
extends AbstractCacheLoaderTestBase {
    CacheSPI first;
    CacheSPI second;

    @AfterMethod
    public void tearDown() {
        if (this.first != null) {
            this.first.stop();
        }
        if (this.second != null) {
            this.second.stop();
        }
    }

    private Configuration getConfiguration(int instance) throws Exception {
        Configuration c = new Configuration();
        c.setTransactionManagerLookupClass(GenericTransactionManagerLookup.class.getName());
        CacheLoaderConfig clc = this.getSingleCacheLoaderConfig("/", JDBCCacheLoader.class.getName(), "cache.jdbc.table.name=jbosscache\n            cache.jdbc.table.create=true\n            cache.jdbc.table.drop=true\n            cache.jdbc.table.primarykey=jbosscache_pk\n            cache.jdbc.fqn.column=fqn\n            cache.jdbc.fqn.type=varchar(255)\n            cache.jdbc.node.column=node\n            cache.jdbc.node.type=blob\n            cache.jdbc.parent.column=parent\n            cache.jdbc.sql-concat=1 || 2\n            cache.jdbc.driver = org.apache.derby.jdbc.EmbeddedDriver\n            cache.jdbc.url=jdbc:derby:jbossdb" + instance + ";create=true\n" + "            cache.jdbc.user=user1\n" + "            cache.jdbc.password=user1\n" + "            cache.jdbc.batch.enable=true\n" + "            cache.jdbc.batch.size=1000", false, true, false);
        clc.setPassivation(false);
        clc.getFirstCacheLoaderConfig().setPurgeOnStartup(true);
        c.setCacheLoaderConfig(clc);
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        return c;
    }

    public void testSimpleStateTransfer() throws Exception {
        this.first = (CacheSPI)new DefaultCacheFactory().createCache(this.getConfiguration(0));
        this.first.put("/a/b/c", (Object)"key", (Object)"value");
        this.first.put("/a/b/d", (Object)"key", (Object)"value");
        this.first.put("/a/b/e", (Object)"key", (Object)"value");
        this.second = (CacheSPI)new DefaultCacheFactory().createCache(this.getConfiguration(2));
        assert (this.second.get("/a/b/c", (Object)"key").equals("value"));
        assert (this.second.get("/a/b/d", (Object)"key").equals("value"));
        assert (this.second.get("/a/b/e", (Object)"key").equals("value"));
        JDBCCacheLoader cacheLoader = (JDBCCacheLoader)this.second.getCacheLoaderManager().getCacheLoader();
        assert (cacheLoader.exists(Fqn.fromString((String)"/a")));
        assert (cacheLoader.exists(Fqn.fromString((String)"/a/b")));
    }

    public void testMoreState() throws Exception {
        long startTime = System.currentTimeMillis();
        this.first = (CacheSPI)new DefaultCacheFactory().createCache(this.getConfiguration(0));
        long cacheStartTime = System.currentTimeMillis() - startTime;
        System.out.println("cacheStartTime = " + cacheStartTime);
        for (int i = 0; i < 5012; ++i) {
            this.first.put("a/b/" + i, (Object)"k", (Object)"v");
            if (i % 1000 != 0) continue;
            System.out.println(i + " operations executed so far");
        }
        startTime = System.currentTimeMillis();
        this.second = (CacheSPI)new DefaultCacheFactory().createCache(this.getConfiguration(2));
        long stateTranferTime = System.currentTimeMillis() - startTime - cacheStartTime;
        for (int i = 0; i < 5012; i += 100) {
            this.second.get("a/b/" + i, (Object)"k").equals("v");
        }
        System.out.println("stateTranferTime = " + stateTranferTime);
    }
}

