/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Iterator;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.CacheStoreInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.DummyCountingCacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class SharedCacheLoaderTest
extends AbstractCacheLoaderTestBase {
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    private DummyCountingCacheLoader dummyCacheLoader;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        if (this.cache1 != null || this.cache2 != null) {
            this.tearDown();
        }
        Configuration c1 = new Configuration();
        Configuration c2 = new Configuration();
        c1.setCacheMode("REPL_SYNC");
        c2.setCacheMode("REPL_SYNC");
        c1.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyCountingCacheLoader.class.getName(), "", false, false, true));
        c2.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyCountingCacheLoader.class.getName(), "", false, false, true));
        this.cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(c1, false);
        this.cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(c2, false);
        this.cache1.start();
        this.cache2.start();
        this.dummyCacheLoader = new DummyCountingCacheLoader();
        this.dummyCacheLoader.scrubStats();
    }

    protected CacheStoreInterceptor findCacheStoreInterceptor(CacheSPI cache) {
        Iterator ints = cache.getInterceptorChain().iterator();
        CacheStoreInterceptor csi = null;
        while (ints.hasNext()) {
            CommandInterceptor i = (CommandInterceptor)ints.next();
            if (!(i instanceof CacheStoreInterceptor)) continue;
            csi = (CacheStoreInterceptor)i;
            break;
        }
        return csi;
    }

    @AfterMethod(alwaysRun=true)
    protected void tearDown() {
        if (this.cache1 != null) {
            TestingUtil.killCaches(new Cache[]{this.cache1});
        }
        if (this.cache2 != null) {
            TestingUtil.killCaches(new Cache[]{this.cache2});
        }
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testReplicationWithSharedCL() {
        this.cache1.put("/test", (Object)"one", (Object)"two");
        AssertJUnit.assertEquals((Object)"two", (Object)this.cache1.get("/test", (Object)"one"));
        AssertJUnit.assertEquals((Object)"two", (Object)this.cache2.get("/test", (Object)"one"));
        AssertJUnit.assertEquals((int)1, (int)this.dummyCacheLoader.getPutCount());
    }
}

