/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.File;
import java.util.Collections;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.loader.FileCacheLoaderConfig;
import org.jboss.cache.marshall.FooClassLoader;
import org.jboss.cache.marshall.RegionBasedMarshallingTestBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class CacheLoaderMarshallingTest
extends RegionBasedMarshallingTestBase {
    private static final String tmpDir = System.getProperty("java.io.tmpdir") + File.separatorChar + "CacheLoaderMarshallingTest";
    private Cache<Object, Object> cache;
    private Fqn fqn = Fqn.fromString((String)"/a");

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(this.cache);
        this.cache = null;
        File f = new File(tmpDir);
        if (f.exists() && !f.delete()) {
            f.deleteOnExit();
        }
        super.tearDown();
    }

    public void testCacheLoaderMarshalling() throws Exception {
        this.cacheLoaderMarshallingTest(false);
    }

    public void testCacheLoaderRegionBasedMarshalling() throws Exception {
        this.cacheLoaderMarshallingTest(true);
    }

    public void testLoadNodesAtRootOfRegion() throws Exception {
        String rootRegionName = "/myregion";
        String hereFqn = rootRegionName + "/here";
        this.cache = this.createCache(true);
        this.cache.start();
        Region r = this.cache.getRegion(Fqn.fromString((String)rootRegionName), true);
        r.registerContextClassLoader(Thread.currentThread().getContextClassLoader());
        r.activate();
        this.cache.put(rootRegionName, (Object)"a key", (Object)"a value");
        this.cache.put(hereFqn, (Object)"another key", (Object)"another value");
        r.deactivate();
        r.unregisterContextClassLoader();
        this.cache.stop();
        this.cache.start();
        r = this.cache.getRegion(Fqn.fromString((String)rootRegionName), true);
        r.registerContextClassLoader(Thread.currentThread().getContextClassLoader());
        r.activate();
        Node rootRegionNode = this.cache.getNode(rootRegionName);
        Node hereNode = this.cache.getNode(hereFqn);
        AssertJUnit.assertNotNull((Object)rootRegionNode);
        AssertJUnit.assertNotNull((Object)hereNode);
        AssertJUnit.assertEquals((Object)hereNode.get((Object)"another key"), (Object)"another value");
        AssertJUnit.assertEquals((Object)rootRegionNode.get((Object)"a key"), (Object)"a value");
    }

    private void cacheLoaderMarshallingTest(boolean useRegionBased) throws Exception {
        this.cache = this.createCache(useRegionBased);
        this.cache.start();
        FooClassLoader loader = new FooClassLoader((ClassLoader)this.originalClassLoaderTL.get());
        if (useRegionBased) {
            Region r = this.cache.getRegion(Fqn.ROOT, true);
            r.registerContextClassLoader((ClassLoader)loader);
            r.activate();
        }
        Class clazz = loader.loadFoo();
        Object obj = clazz.newInstance();
        Thread.currentThread().setContextClassLoader(loader);
        this.cache.put(this.fqn, (Object)"key", obj);
        this.resetContextClassLoader();
        this.cache.evict(this.fqn);
        Thread.currentThread().setContextClassLoader(loader);
        AssertJUnit.assertEquals(obj, (Object)this.cache.get(this.fqn, (Object)"key"));
    }

    private Cache createCache(boolean useRegionBased) {
        Configuration config = new Configuration();
        config.setUseRegionBasedMarshalling(useRegionBased);
        config.setInactiveOnStartup(useRegionBased);
        Cache cache = new UnitTestCacheFactory().createCache(config, false);
        EvictionConfig ec = new EvictionConfig();
        ec.setWakeupInterval(1000000L);
        EvictionRegionConfig erc = new EvictionRegionConfig();
        erc.setRegionFqn(Fqn.ROOT);
        LRUAlgorithmConfig lruAlgorithmConfig = new LRUAlgorithmConfig();
        lruAlgorithmConfig.setMaxNodes(1000);
        lruAlgorithmConfig.setTimeToLive(1000000L);
        erc.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)lruAlgorithmConfig);
        ec.addEvictionRegionConfig(erc);
        config.setEvictionConfig(ec);
        CacheLoaderConfig clc = new CacheLoaderConfig();
        clc.setPassivation(true);
        clc.setShared(false);
        FileCacheLoaderConfig fclc = new FileCacheLoaderConfig();
        fclc.setLocation(tmpDir);
        clc.setIndividualCacheLoaderConfigs(Collections.singletonList(fclc));
        config.setCacheLoaderConfig(clc);
        return cache;
    }
}

