/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class RegionManagerTest {
    private final Fqn DEFAULT_REGION = Fqn.ROOT;
    private RegionManager r;
    private Configuration c;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache();
        this.r = cache.getRegionManager();
        this.c = cache.getConfiguration();
    }

    @AfterMethod(alwaysRun=false)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.r.getCache()});
        this.r = null;
    }

    public void testGetAllMarshallingRegions() {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b");
        Fqn fqn3 = Fqn.fromString((String)"/aop");
        ArrayList<Region> expected = new ArrayList<Region>(4);
        Region region = this.r.getRegion(this.DEFAULT_REGION, true);
        region.registerContextClassLoader(this.getClass().getClassLoader());
        AssertJUnit.assertEquals((Object)this.DEFAULT_REGION, (Object)region.getFqn());
        expected.add(region);
        region = this.r.getRegion(fqn1, true);
        region.registerContextClassLoader(this.getClass().getClassLoader());
        AssertJUnit.assertEquals((Object)fqn1, (Object)region.getFqn());
        expected.add(region);
        region = this.r.getRegion(fqn2, true);
        region.registerContextClassLoader(this.getClass().getClassLoader());
        AssertJUnit.assertEquals((Object)fqn2, (Object)region.getFqn());
        expected.add(region);
        region = this.r.getRegion(fqn3, true);
        region.registerContextClassLoader(this.getClass().getClassLoader());
        AssertJUnit.assertEquals((Object)fqn3, (Object)region.getFqn());
        expected.add(region);
        Collections.sort(expected);
        Iterator expectedRegions = expected.iterator();
        for (Region reg : this.r.getAllRegions(Region.Type.MARSHALLING)) {
            AssertJUnit.assertSame((String)("Unexpected region " + reg), expectedRegions.next(), (Object)reg);
        }
        AssertJUnit.assertFalse((String)"Should not be expecting any more regions", (boolean)expectedRegions.hasNext());
    }

    public void testNoDefaultRegion() {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/");
        this.r.getRegion(fqn1, true);
        this.r.getRegion(fqn2, true);
        Region region = null;
        try {
            region = this.r.getRegion("/a", false);
        }
        catch (Exception e) {
            AssertJUnit.fail((String)"If we don't set the default region, it still should be ok!");
        }
        AssertJUnit.assertNull((String)"Default region is not null!", (Object)region);
    }

    public void testGetParentRegion() {
        String fqn1 = "/a/b/c";
        String fqn2 = "/a/b";
        String fqn3 = "/a";
        this.r.getRegion(fqn1, true);
        this.r.getRegion(fqn3, true);
        Region region = this.r.getRegion(fqn2, false);
        AssertJUnit.assertEquals((String)("Should be the same region as in " + fqn3), (Object)this.r.getRegion(fqn3, false), (Object)region);
    }

    public void testRemoveRegion() {
        String fqn1 = "/a";
        String fqn2 = "/a/b";
        String fqn3 = "/a/b/c";
        Region r1 = this.r.getRegion(fqn1, true);
        Region r2 = this.r.getRegion(fqn2, true);
        Region r3 = this.r.getRegion(fqn3, true);
        AssertJUnit.assertEquals((String)"Expecting 3 regions", (int)3, (int)this.r.getAllRegions(Region.Type.ANY).size());
        AssertJUnit.assertEquals((Object)r3, (Object)this.r.getRegion(fqn3, false));
        this.r.removeRegion(Fqn.fromString((String)fqn3));
        AssertJUnit.assertEquals((String)"Expecting 2 regions", (int)2, (int)this.r.getAllRegions(Region.Type.ANY).size());
        AssertJUnit.assertEquals((String)"Should have retrieved parent region", (Object)r2, (Object)this.r.getRegion(fqn3, false));
        this.r.removeRegion(Fqn.fromString((String)fqn2));
        AssertJUnit.assertEquals((String)"Expecting 1 region", (int)1, (int)this.r.getAllRegions(Region.Type.ANY).size());
        AssertJUnit.assertEquals((String)"Should have retrieved parent region", (Object)r1, (Object)this.r.getRegion(fqn3, false));
        this.r.removeRegion(Fqn.fromString((String)fqn1));
        AssertJUnit.assertEquals((String)"Expecting 0 regions", (int)0, (int)this.r.getAllRegions(Region.Type.ANY).size());
    }

    public void testGetRegionsMethods() {
        String f1 = "/a";
        String f2 = "/b";
        String f3 = "/c";
        String f4 = "/d";
        this.r.setDefaultInactive(true);
        Region r1 = this.r.getRegion(f1, true);
        Region r2 = this.r.getRegion(f2, true);
        Region r3 = this.r.getRegion(f3, true);
        Region r4 = this.r.getRegion(f4, true);
        AssertJUnit.assertEquals((String)"4 regions should exist", (int)4, (int)this.r.getAllRegions(Region.Type.ANY).size());
        AssertJUnit.assertEquals((String)"None of the regions should marshalling or active", (int)0, (int)this.r.getAllRegions(Region.Type.MARSHALLING).size());
        r3.registerContextClassLoader(this.getClass().getClassLoader());
        r3.activate();
        AssertJUnit.assertEquals((String)"r3 should be marshalling and active", (int)1, (int)this.r.getAllRegions(Region.Type.MARSHALLING).size());
        AssertJUnit.assertSame((String)"r3 should be marshalling and active", (Object)r3, this.r.getAllRegions(Region.Type.MARSHALLING).get(0));
        r4.activate();
        AssertJUnit.assertEquals((String)"r3 should be marshalling and active", (int)1, (int)this.r.getAllRegions(Region.Type.MARSHALLING).size());
        AssertJUnit.assertSame((String)"r3 should be marshalling and active", (Object)r3, this.r.getAllRegions(Region.Type.MARSHALLING).get(0));
        r2.registerContextClassLoader(this.getClass().getClassLoader());
        AssertJUnit.assertEquals((String)"r3 should be marshalling and active", (int)1, (int)this.r.getAllRegions(Region.Type.MARSHALLING).size());
        AssertJUnit.assertSame((String)"r3 should be marshalling and active", (Object)r3, this.r.getAllRegions(Region.Type.MARSHALLING).get(0));
        r2.activate();
        AssertJUnit.assertEquals((String)"r2 + r3 should be marshalling and active", (int)2, (int)this.r.getAllRegions(Region.Type.MARSHALLING).size());
        AssertJUnit.assertSame((String)"r2 should be marshalling and active", (Object)r2, this.r.getAllRegions(Region.Type.MARSHALLING).get(0));
        AssertJUnit.assertSame((String)"r3 should be marshalling and active", (Object)r3, this.r.getAllRegions(Region.Type.MARSHALLING).get(1));
        r4.registerContextClassLoader(this.getClass().getClassLoader());
        AssertJUnit.assertEquals((String)"r2 + r3 + r4 should be marshalling and active", (int)3, (int)this.r.getAllRegions(Region.Type.MARSHALLING).size());
        AssertJUnit.assertSame((String)"r2 should be marshalling and active", (Object)r2, this.r.getAllRegions(Region.Type.MARSHALLING).get(0));
        AssertJUnit.assertSame((String)"r3 should be marshalling and active", (Object)r3, this.r.getAllRegions(Region.Type.MARSHALLING).get(1));
        AssertJUnit.assertSame((String)"r4 should be marshalling and active", (Object)r4, this.r.getAllRegions(Region.Type.MARSHALLING).get(2));
    }
}

