/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.CommandsFactoryImpl;
import org.jboss.cache.commands.DataCommand;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GravitateDataCommand;
import org.jboss.cache.commands.remote.ClusteredGetCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.marshall.MarshalledValue;
import org.jboss.cache.marshall.MyList;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.RegionBasedMarshallingTestBase;
import org.jboss.cache.marshall.SelectedClassnameClassLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"}, sequential=true)
public class ReturnValueMarshallingTest
extends RegionBasedMarshallingTestBase {
    protected boolean useMarshalledValues = false;
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    private Fqn fqn = Fqn.fromString((String)"/a");
    private ClassLoader classLoader;
    private Object key = "key";
    private Object value;
    private String className = "org.jboss.cache.marshall.MyList";
    private Class listClass;
    private CommandsFactory commandsFactory = new CommandsFactoryImpl();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        Configuration c1 = new Configuration();
        c1.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        c1.setUseLazyDeserialization(this.useMarshalledValues);
        c1.setUseRegionBasedMarshalling(!this.useMarshalledValues);
        c1.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c1.setSyncReplTimeout(60000L);
        this.cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(c1, false);
        this.cache1.start();
        Configuration c2 = new Configuration();
        c2.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        c2.setUseLazyDeserialization(this.useMarshalledValues);
        c2.setUseRegionBasedMarshalling(!this.useMarshalledValues);
        c2.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c2.setSyncReplTimeout(60000L);
        this.cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(c2, false);
        this.cache2.start();
        this.classLoader = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r1 = this.cache1.getRegion(this.fqn, true);
            r1.setActive(true);
            r1.registerContextClassLoader(this.classLoader);
            Region r2 = this.cache2.getRegion(this.fqn, true);
            r2.setActive(true);
            r2.registerContextClassLoader(this.classLoader);
        }
        this.listClass = this.classLoader.loadClass(this.className);
        this.value = this.listClass.newInstance();
        this.cache1.put(this.fqn, this.key, this.value);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2});
        this.cache1 = null;
        this.cache2 = null;
        super.tearDown();
    }

    protected ClassLoader getClassLoader() {
        String[] includesClasses = new String[]{this.className};
        String[] excludesClasses = new String[]{};
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new SelectedClassnameClassLoader(includesClasses, excludesClasses, cl);
    }

    public void testClusteredGet() throws Exception {
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }
        AssertJUnit.assertNotNull((Object)this.cache1.get(this.fqn, this.key));
        AssertJUnit.assertNotSame(MyList.class, this.cache1.get(this.fqn, this.key).getClass());
        AssertJUnit.assertSame((Object)this.listClass, this.cache1.get(this.fqn, this.key).getClass());
        AssertJUnit.assertNotNull((Object)this.cache2.get(this.fqn, this.key));
        AssertJUnit.assertNotSame(MyList.class, this.cache2.get(this.fqn, this.key).getClass());
        AssertJUnit.assertSame((Object)this.listClass, this.cache2.get(this.fqn, this.key).getClass());
        GetKeyValueCommand command = new GetKeyValueCommand(this.fqn, this.key, false);
        ClusteredGetCommand clusteredGet = new ClusteredGetCommand(false, (DataCommand)command);
        List responses = this.cache1.getRPCManager().callRemoteMethods(null, (ReplicableCommand)clusteredGet, true, 15000L, false);
        List response1 = (List)responses.get(0);
        Boolean found = (Boolean)response1.get(0);
        AssertJUnit.assertTrue((String)"Should have found remote data", (boolean)found);
        Object data = response1.get(1);
        AssertJUnit.assertNotNull(data);
        if (this.useMarshalledValues) {
            data = ((MarshalledValue)data).get();
        }
        AssertJUnit.assertNotSame(MyList.class, data.getClass());
        AssertJUnit.assertSame((Object)this.listClass, data.getClass());
    }

    public void testDataGravitation() throws Exception {
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }
        AssertJUnit.assertNotNull((Object)this.cache1.get(this.fqn, this.key));
        AssertJUnit.assertNotSame(MyList.class, this.cache1.get(this.fqn, this.key).getClass());
        AssertJUnit.assertSame((Object)this.listClass, this.cache1.get(this.fqn, this.key).getClass());
        AssertJUnit.assertNotNull((Object)this.cache2.get(this.fqn, this.key));
        AssertJUnit.assertNotSame(MyList.class, this.cache2.get(this.fqn, this.key).getClass());
        AssertJUnit.assertSame((Object)this.listClass, this.cache2.get(this.fqn, this.key).getClass());
        GravitateDataCommand gravitateDataCommand = new GravitateDataCommand(this.fqn, false, this.cache1.getRPCManager().getLocalAddress());
        List responses = this.cache1.getRPCManager().callRemoteMethods(null, (ReplicableCommand)gravitateDataCommand, true, 15000L, false);
        GravitateResult data = (GravitateResult)responses.get(0);
        AssertJUnit.assertTrue((String)"Should have found remote data", (boolean)data.isDataFound());
        AssertJUnit.assertNotNull((Object)data.getNodeData());
        Object value = ((NodeData)data.getNodeData().get(0)).getAttributes().get(this.key);
        AssertJUnit.assertNotNull(value);
        if (this.useMarshalledValues) {
            value = ((MarshalledValue)value).get();
        }
        AssertJUnit.assertNotSame(MyList.class, value.getClass());
        AssertJUnit.assertSame((Object)this.listClass, value.getClass());
    }
}

