/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mgmt;

import java.util.HashMap;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.interceptors.CacheStoreInterceptor;
import org.jboss.cache.mgmt.MgmtTestBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class CacheLoaderTest
extends MgmtTestBase {
    public void testCacheLoaderMgmt() throws Exception {
        AssertJUnit.assertNotNull((String)"Cache is null.", (Object)this.cache);
        CacheLoaderInterceptor loader = TestingUtil.findInterceptor(this.cache, CacheLoaderInterceptor.class);
        AssertJUnit.assertNotNull((String)"CacheLoaderInterceptor not found.", (Object)loader);
        CacheStoreInterceptor store = TestingUtil.findInterceptor(this.cache, CacheStoreInterceptor.class);
        AssertJUnit.assertNotNull((String)"CacheStoreInterceptor not found.", (Object)store);
        int miss = 5;
        int load = 0;
        int stores = 5;
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)load, (long)loader.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)loader.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"CacheLoaderStores count error: ", (long)stores, (long)store.getCacheLoaderStores());
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve capital for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"capital"));
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve area for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"area"));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)load, (long)loader.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)loader.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"CacheLoaderStores count error: ", (long)stores, (long)store.getCacheLoaderStores());
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve capital for " + POLAND), (Object)this.cache.get(POLAND, (Object)"capital"));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)load, (long)loader.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)(++miss), (long)loader.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"CacheLoaderStores count error: ", (long)stores, (long)store.getCacheLoaderStores());
        this.cache.evict(AUSTRIA, false);
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to find node " + AUSTRIA + " in cache"), (Object)this.cache.peek(AUSTRIA, false));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve capital for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"capital"));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve currency for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"currency"));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)(++load), (long)loader.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)loader.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"CacheLoaderStores count error: ", (long)stores, (long)store.getCacheLoaderStores());
        this.cache.removeNode(AUSTRIA);
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to find node " + AUSTRIA + " in cache"), (Object)this.cache.peek(AUSTRIA, false));
        AssertJUnit.assertFalse((String)("Retrieval error: did not expect to find node " + AUSTRIA + " in loader"), (boolean)this.cl.exists(AUSTRIA));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)load, (long)loader.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)loader.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"CacheLoaderStores count error: ", (long)stores, (long)store.getCacheLoaderStores());
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve capital for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"capital"));
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve currency for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"currency"));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)load, (long)loader.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)(miss += 2), (long)loader.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"CacheLoaderStores count error: ", (long)stores, (long)store.getCacheLoaderStores());
        this.cache.put(POLAND, new HashMap());
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)load, (long)loader.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)(++miss), (long)loader.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"CacheLoaderStores count error: ", (long)(++stores), (long)store.getCacheLoaderStores());
        stores += 2;
        this.cache.put(POLAND, (Object)"capital", (Object)"Warsaw");
        this.cache.put(POLAND, (Object)"currency", (Object)"Zloty");
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)load, (long)loader.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)loader.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"CacheLoaderStores count error: ", (long)stores, (long)store.getCacheLoaderStores());
        this.cache.evict(POLAND, false);
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve area for " + POLAND), (Object)this.cache.get(POLAND, (Object)"area"));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)(++load), (long)loader.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)loader.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"CacheLoaderStores count error: ", (long)stores, (long)store.getCacheLoaderStores());
        loader.resetStatistics();
        store.resetStatistics();
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error after reset: ", (long)0L, (long)loader.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error after reset: ", (long)0L, (long)loader.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"CacheLoaderStores count error after reset: ", (long)0L, (long)store.getCacheLoaderStores());
    }
}

