/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mgmt;

import java.util.HashMap;
import java.util.List;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class TxTest {
    private static final String CLUSTER_NAME = "TxTestCluster";
    private static final String CAPITAL = "capital";
    private static final String CURRENCY = "currency";
    private static final String POPULATION = "population";
    private static final String AREA = "area";
    private CacheSPI<Object, Object> cache1 = null;
    private CacheSPI<Object, Object> cache2 = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache1 = this.createCache(CLUSTER_NAME);
        this.cache2 = this.createCache(CLUSTER_NAME);
    }

    @BeforeMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache1 != null) {
            TestingUtil.killCaches(new Cache[]{this.cache1});
            this.cache1 = null;
        }
        if (this.cache2 != null) {
            TestingUtil.killCaches(new Cache[]{this.cache2});
            this.cache2 = null;
        }
    }

    public void testTxMgmt() throws Exception {
        AssertJUnit.assertNotNull((String)"Cache1 is null.", this.cache1);
        AssertJUnit.assertNotNull((String)"Cache2 is null.", this.cache2);
        TxInterceptor tx1 = this.getTxInterceptor(this.cache1);
        AssertJUnit.assertNotNull((String)"Cache1 InvalidationInterceptor not found.", (Object)tx1);
        TxInterceptor tx2 = this.getTxInterceptor(this.cache2);
        AssertJUnit.assertNotNull((String)"Cache2 InvalidationInterceptor not found.", (Object)tx2);
        TransactionManager tm1 = this.cache1.getTransactionManager();
        AssertJUnit.assertNotNull((String)"TransactionManager is null.", (Object)tm1);
        this.loadCacheNoTx(this.cache1);
        Fqn key = Fqn.fromString((String)"Europe/Austria");
        AssertJUnit.assertNotNull((String)("Cache1 retrieval error: expected to retrieve capital for " + key), (Object)this.cache1.get(key, (Object)CAPITAL));
        AssertJUnit.assertNotNull((String)("Cache2 retrieval error: expected to retrieve capital for " + key), (Object)this.cache2.get(key, (Object)CAPITAL));
        key = Fqn.fromString((String)"Europe/Albania");
        AssertJUnit.assertNotNull((String)("Cache1 retrieval error: expected to retrieve capital for " + key), (Object)this.cache1.get(key, (Object)CAPITAL));
        AssertJUnit.assertNotNull((String)("Cache2 retrieval error: expected to retrieve capital for " + key), (Object)this.cache2.get(key, (Object)CAPITAL));
        AssertJUnit.assertEquals((String)"Cache1 Tx Prepares error after reset: ", (Object)new Long(0L), (Object)new Long(tx1.getPrepares()));
        AssertJUnit.assertEquals((String)"Cache1 Tx Commits error after reset: ", (Object)new Long(0L), (Object)new Long(tx1.getCommits()));
        AssertJUnit.assertEquals((String)"Cache1 Tx Rollbacks error after reset: ", (Object)new Long(0L), (Object)new Long(tx1.getRollbacks()));
        AssertJUnit.assertEquals((String)"Cache2 Tx Prepares error after reset: ", (Object)new Long(0L), (Object)new Long(tx2.getPrepares()));
        AssertJUnit.assertEquals((String)"Cache2 Tx Commits error after reset: ", (Object)new Long(0L), (Object)new Long(tx2.getCommits()));
        AssertJUnit.assertEquals((String)"Cache2 Tx Rollbacks error after reset: ", (Object)new Long(0L), (Object)new Long(tx2.getRollbacks()));
        this.loadCacheTxCommit(this.cache1, tm1);
        this.loadCacheTxCommit2(this.cache1, tm1);
        key = Fqn.fromString((String)"Europe/England");
        AssertJUnit.assertNotNull((String)("Cache1 retrieval error: expected to retrieve capital for " + key), (Object)this.cache1.get(key, (Object)CAPITAL));
        AssertJUnit.assertNotNull((String)("Cache2 retrieval error: expected to retrieve capital for " + key), (Object)this.cache2.get(key, (Object)CAPITAL));
        key = Fqn.fromString((String)"Europe/Hungary");
        AssertJUnit.assertNotNull((String)("Cache1 retrieval error: expected to retrieve capital for " + key), (Object)this.cache1.get(key, (Object)CAPITAL));
        AssertJUnit.assertNotNull((String)("Cache2 retrieval error: expected to retrieve capital for " + key), (Object)this.cache2.get(key, (Object)CAPITAL));
        this.loadCacheTxRollback(this.cache1, tm1);
        key = Fqn.fromString((String)"Europe/France");
        AssertJUnit.assertNull((String)("Cache1 retrieval error: did not expect to retrieve capital for " + key), (Object)this.cache1.get(key, (Object)CAPITAL));
        AssertJUnit.assertNull((String)("Cache2 retrieval error: did not expect to retrieve capital for " + key), (Object)this.cache2.get(key, (Object)CAPITAL));
        key = Fqn.fromString((String)"Europe/Germany");
        AssertJUnit.assertNull((String)("Cache1 retrieval error: did not expect to retrieve capital for " + key), (Object)this.cache1.get(key, (Object)CAPITAL));
        AssertJUnit.assertNull((String)("Cache2 retrieval error: did not expect to retrieve capital for " + key), (Object)this.cache2.get(key, (Object)CAPITAL));
        AssertJUnit.assertEquals((String)"Cache1 Tx Prepares error after reset: ", (Object)new Long(0L), (Object)new Long(tx1.getPrepares()));
        AssertJUnit.assertEquals((String)"Cache1 Tx Commits error after reset: ", (Object)new Long(0L), (Object)new Long(tx1.getCommits()));
        AssertJUnit.assertEquals((String)"Cache1 Tx Rollbacks error after reset: ", (Object)new Long(0L), (Object)new Long(tx1.getRollbacks()));
        AssertJUnit.assertEquals((String)"Cache2 Tx Prepares error after reset: ", (Object)new Long(2L), (Object)new Long(tx2.getPrepares()));
        AssertJUnit.assertEquals((String)"Cache2 Tx Commits error after reset: ", (Object)new Long(2L), (Object)new Long(tx2.getCommits()));
        AssertJUnit.assertEquals((String)"Cache2 Tx Rollbacks error after reset: ", (Object)new Long(0L), (Object)new Long(tx2.getRollbacks()));
        tx1.resetStatistics();
        tx2.resetStatistics();
        AssertJUnit.assertEquals((String)"Cache1 Tx Prepares error after reset: ", (Object)new Long(0L), (Object)new Long(tx1.getPrepares()));
        AssertJUnit.assertEquals((String)"Cache1 Tx Commits error after reset: ", (Object)new Long(0L), (Object)new Long(tx1.getCommits()));
        AssertJUnit.assertEquals((String)"Cache1 Tx Rollbacks error after reset: ", (Object)new Long(0L), (Object)new Long(tx1.getRollbacks()));
        AssertJUnit.assertEquals((String)"Cache2 Tx Prepares error after reset: ", (Object)new Long(0L), (Object)new Long(tx2.getPrepares()));
        AssertJUnit.assertEquals((String)"Cache2 Tx Commits error after reset: ", (Object)new Long(0L), (Object)new Long(tx2.getCommits()));
        AssertJUnit.assertEquals((String)"Cache2 Tx Rollbacks error after reset: ", (Object)new Long(0L), (Object)new Long(tx2.getRollbacks()));
    }

    private void loadCacheNoTx(CacheSPI<Object, Object> cache) {
        cache.put("Europe", new HashMap());
        cache.put("Europe/Austria", new HashMap());
        cache.put("Europe/Austria", (Object)CAPITAL, (Object)"Vienna");
        cache.put("Europe/Austria", (Object)CURRENCY, (Object)"Euro");
        cache.put("Europe/Austria", (Object)POPULATION, (Object)8184691);
        HashMap<String, Object> albania = new HashMap<String, Object>(4);
        albania.put(CAPITAL, "Tirana");
        albania.put(CURRENCY, "Lek");
        albania.put(POPULATION, 3563112);
        albania.put(AREA, 28748);
        cache.put("Europe/Albania", albania);
    }

    private void loadCacheTxCommit(CacheSPI<Object, Object> cache, TransactionManager tm) throws Exception {
        tm.begin();
        cache.put("Europe/Czech Republic", new HashMap());
        cache.put("Europe/Czech Republic", (Object)CAPITAL, (Object)"Prague");
        cache.put("Europe/Czech Republic", (Object)CURRENCY, (Object)"Czech Koruna");
        cache.put("Europe/Czech Republic", (Object)POPULATION, (Object)10241138);
        cache.put("Europe/England", new HashMap());
        cache.put("Europe/England", (Object)CAPITAL, (Object)"London");
        cache.put("Europe/England", (Object)CURRENCY, (Object)"British Pound");
        cache.put("Europe/England", (Object)POPULATION, (Object)60441457);
        tm.commit();
    }

    private void loadCacheTxCommit2(CacheSPI<Object, Object> cache, TransactionManager tm) throws Exception {
        tm.begin();
        HashMap<String, Object> hungary = new HashMap<String, Object>(4);
        hungary.put(CAPITAL, "Budapest");
        hungary.put(CURRENCY, "Forint");
        hungary.put(POPULATION, 10006835);
        hungary.put(AREA, 93030);
        cache.put("Europe/Hungary", hungary);
        HashMap<String, Object> romania = new HashMap<String, Object>(4);
        romania.put(CAPITAL, "Bucharest");
        romania.put(CURRENCY, "Leu");
        romania.put(POPULATION, 22329977);
        romania.put(AREA, 237500);
        cache.put("Europe/Romania", romania);
        tm.commit();
    }

    private void loadCacheTxRollback(CacheSPI<Object, Object> cache, TransactionManager tm) throws Exception {
        tm.begin();
        cache.put("Europe/France", new HashMap());
        cache.put("Europe/France", (Object)CAPITAL, (Object)"Paris");
        cache.put("Europe/France", (Object)CURRENCY, (Object)"Euro");
        cache.put("Europe/France", (Object)POPULATION, (Object)60656178);
        cache.put("Europe/Germany", new HashMap());
        cache.put("Europe/Germany", (Object)CAPITAL, (Object)"Berlin");
        cache.put("Europe/Germany", (Object)CURRENCY, (Object)"Euro");
        cache.put("Europe/Germany", (Object)POPULATION, (Object)82431390);
        tm.rollback();
    }

    private CacheSPI<Object, Object> createCache(String clusterName) {
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        c.setUseRegionBasedMarshalling(false);
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        c.setExposeManagementStatistics(true);
        c.setClusterName(clusterName);
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        cache.create();
        cache.start();
        return cache;
    }

    private TxInterceptor getTxInterceptor(CacheSPI cache) {
        List interceptors = cache.getInterceptorChain();
        if (interceptors.isEmpty()) {
            return null;
        }
        for (Object o : interceptors) {
            if (!(o instanceof TxInterceptor)) continue;
            return (TxInterceptor)o;
        }
        return null;
    }
}

