/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.multiplexer;

import org.jboss.cache.Cache;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.multiplexer.MultiplexerTestHelper;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"}, enabled=true, sequential=true)
public class BadMuxConfigTest {
    private MultiplexerTestHelper muxHelper;
    private Cache cache;
    private boolean cacheStarted;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.muxHelper = new MultiplexerTestHelper();
        Configuration config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        config.setClusterConfig(UnitTestCacheConfigurationFactory.getClusterConfigFromProperties("udp.xml"));
        this.cache = new UnitTestCacheFactory().createCache(config, false);
        this.cacheStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        try {
            if (this.cache != null) {
                TestingUtil.killCaches(this.cache);
                this.cache = null;
            }
        }
        finally {
            if (this.muxHelper != null) {
                this.muxHelper.tearDown();
                this.muxHelper = null;
            }
        }
    }

    public void testValidMuxConfig() throws Exception {
    }

    public void testMissingMuxChannelFactory() throws Exception {
        this.muxHelper.configureCacheForMux(this.cache);
        this.cache.getConfiguration().getRuntimeConfig().setMuxChannelFactory(null);
        this.checkStart(false, false);
    }

    public void testInvalidStackName() throws Exception {
        this.muxHelper.configureCacheForMux(this.cache);
        this.cache.getConfiguration().setMultiplexerStack("bogus");
        this.checkStart(true, false);
    }

    public void testMissingStackName() throws Exception {
        this.muxHelper.configureCacheForMux(this.cache);
        this.cache.getConfiguration().setMultiplexerStack(null);
        this.checkStart(true, false);
    }

    private void checkStart(boolean expectFail, boolean expectMux) {
        block5: {
            try {
                this.cache.start();
                this.cacheStarted = true;
                if (expectFail) {
                    AssertJUnit.fail((String)"Start did not fail as expected");
                }
                if (expectMux) {
                    AssertJUnit.assertTrue((String)"Cache is using mux", (boolean)this.cache.getConfiguration().isUsingMultiplexer());
                } else {
                    AssertJUnit.assertFalse((String)"Cache is not using mux ", (boolean)this.cache.getConfiguration().isUsingMultiplexer());
                }
            }
            catch (Exception e) {
                if (expectFail) break block5;
                AssertJUnit.fail((String)("Caught exception starting cache " + e.getLocalizedMessage()));
            }
        }
    }
}

