/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.concurrent.CountDownLatch;
import org.jboss.cache.Cache;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.event.NodeCreatedEvent;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class AsyncNotificationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncNotification() throws InterruptedException {
        Cache c = null;
        try {
            c = new UnitTestCacheFactory().createCache();
            CountDownLatch latch = new CountDownLatch(2);
            Listener syncListener = new Listener(latch);
            AsyncListener asyncListener = new AsyncListener(latch);
            c.addCacheListener((Object)syncListener);
            c.addCacheListener((Object)asyncListener);
            c.put("/a", (Object)"k", (Object)"v");
            latch.await();
            assert (syncListener.caller == Thread.currentThread());
            assert (asyncListener.caller != Thread.currentThread());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            TestingUtil.killCaches(c);
            throw throwable;
        }
        TestingUtil.killCaches(c);
    }

    @CacheListener(sync=false)
    public static class AsyncListener
    extends AbstractListener {
        public AsyncListener(CountDownLatch latch) {
            super(latch);
        }

        @NodeCreated
        public void handle(NodeCreatedEvent e) {
            if (e.isPre()) {
                this.caller = Thread.currentThread();
                this.latch.countDown();
            }
        }
    }

    @CacheListener(sync=true)
    public static class Listener
    extends AbstractListener {
        public Listener(CountDownLatch latch) {
            super(latch);
        }

        @NodeCreated
        public void handle(NodeCreatedEvent e) {
            if (e.isPre()) {
                this.caller = Thread.currentThread();
                this.latch.countDown();
            }
        }
    }

    public static abstract class AbstractListener {
        Thread caller;
        CountDownLatch latch;

        protected AbstractListener(CountDownLatch latch) {
            this.latch = latch;
        }
    }
}

