/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.notifications.EventLog;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.EventImpl;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class CacheListenerPassivationTest {
    private Cache<Object, Object> cache;
    private EventLog eventLog = new EventLog();
    private TransactionManager tm;
    private Fqn fqn = Fqn.fromString((String)"/test");

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c = new Configuration();
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        CacheLoaderConfig clc = new CacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName(DummyInMemoryCacheLoader.class.getName());
        clc.addIndividualCacheLoaderConfig(iclc);
        clc.setPassivation(true);
        c.setCacheLoaderConfig(clc);
        this.cache = new UnitTestCacheFactory().createCache(c);
        this.eventLog.events.clear();
        this.cache.addCacheListener((Object)this.eventLog);
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(this.cache);
        this.cache = null;
    }

    public void testActivationAndPassivation() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        this.eventLog.events.clear();
        this.cache.evict(this.fqn);
        expected.add(new EventImpl(true, this.cache, null, data, this.fqn, null, true, null, false, null, Event.Type.NODE_PASSIVATED));
        expected.add(new EventImpl(false, this.cache, null, Collections.emptyMap(), this.fqn, null, true, null, false, null, Event.Type.NODE_PASSIVATED));
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_EVICTED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_EVICTED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        expected.clear();
        this.eventLog.events.clear();
        this.cache.get(this.fqn, (Object)"DOES_NOT_EXIST");
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(true, this.cache, null, Collections.emptyMap(), this.fqn, null, true, null, false, null, Event.Type.NODE_ACTIVATED));
        expected.add(new EventImpl(false, this.cache, null, data, this.fqn, null, true, null, false, null, Event.Type.NODE_ACTIVATED));
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_VISITED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_VISITED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }

    public void testActivationAndPassivationTxNoMods() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        this.eventLog.events.clear();
        this.cache.evict(this.fqn);
        expected.add(new EventImpl(true, this.cache, null, data, this.fqn, null, true, null, false, null, Event.Type.NODE_PASSIVATED));
        expected.add(new EventImpl(false, this.cache, null, Collections.emptyMap(), this.fqn, null, true, null, false, null, Event.Type.NODE_PASSIVATED));
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_EVICTED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_EVICTED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        expected.clear();
        this.eventLog.events.clear();
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.cache.get(this.fqn, (Object)"DOES_NOT_EXIST");
        this.tm.commit();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(true, this.cache, null, Collections.emptyMap(), this.fqn, tx, true, null, false, null, Event.Type.NODE_ACTIVATED));
        expected.add(new EventImpl(false, this.cache, null, data, this.fqn, tx, true, null, false, null, Event.Type.NODE_ACTIVATED));
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_VISITED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_VISITED));
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
    }

    public void testActivationAndPassivationTxMods() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        this.eventLog.events.clear();
        this.cache.evict(this.fqn);
        expected.add(new EventImpl(true, this.cache, null, data, this.fqn, null, true, null, false, null, Event.Type.NODE_PASSIVATED));
        expected.add(new EventImpl(false, this.cache, null, Collections.emptyMap(), this.fqn, null, true, null, false, null, Event.Type.NODE_PASSIVATED));
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_EVICTED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_EVICTED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        expected.clear();
        this.eventLog.events.clear();
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.cache.put(this.fqn, (Object)"key2", (Object)"value2");
        this.tm.commit();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(true, this.cache, null, Collections.emptyMap(), this.fqn, tx, true, null, false, null, Event.Type.NODE_ACTIVATED));
        expected.add(new EventImpl(false, this.cache, null, data, this.fqn, tx, true, null, false, null, Event.Type.NODE_ACTIVATED));
        expected.add(new EventImpl(true, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, data, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, Collections.singletonMap("key2", "value2"), this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        assert (this.cache.get(this.fqn, (Object)"key").equals("value"));
        assert (this.cache.get(this.fqn, (Object)"key2").equals("value2"));
    }

    public void testActivationAndPassivationTxModsWithChildren() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog.events);
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        this.cache.put(Fqn.fromRelativeElements((Fqn)this.fqn, (Object[])new String[]{"child"}), (Object)"key3", (Object)"value3");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        this.eventLog.events.clear();
        this.cache.evict(this.fqn);
        expected.add(new EventImpl(true, this.cache, null, data, this.fqn, null, true, null, false, null, Event.Type.NODE_PASSIVATED));
        expected.add(new EventImpl(false, this.cache, null, Collections.emptyMap(), this.fqn, null, true, null, false, null, Event.Type.NODE_PASSIVATED));
        expected.add(new EventImpl(true, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_EVICTED));
        expected.add(new EventImpl(false, this.cache, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_EVICTED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        expected.clear();
        this.eventLog.events.clear();
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        this.cache.put(this.fqn, (Object)"key2", (Object)"value2");
        this.tm.commit();
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add(new EventImpl(true, this.cache, null, Collections.emptyMap(), this.fqn, tx, true, null, false, null, Event.Type.NODE_ACTIVATED));
        expected.add(new EventImpl(false, this.cache, null, data, this.fqn, tx, true, null, false, null, Event.Type.NODE_ACTIVATED));
        expected.add(new EventImpl(true, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, data, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, NodeModifiedEvent.ModificationType.PUT_DATA, Collections.singletonMap("key2", "value2"), this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog.events);
        assert (this.cache.get(this.fqn, (Object)"key").equals("value"));
        assert (this.cache.get(this.fqn, (Object)"key2").equals("value2"));
    }
}

