/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeMoved;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.NodeVisited;
import org.jboss.cache.notifications.annotation.TransactionCompleted;
import org.jboss.cache.notifications.annotation.TransactionRegistered;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class NotificationThreadTest
extends AbstractCacheLoaderTestBase {
    private Cache<String, String> cache1;
    private Cache<String, String> cache2;
    private TestCacheListener listener;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        Configuration conf1 = new Configuration();
        Configuration conf2 = new Configuration();
        conf1.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        conf2.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        conf1.setSyncCommitPhase(true);
        conf2.setSyncCommitPhase(true);
        conf1.setSyncRollbackPhase(true);
        conf2.setSyncRollbackPhase(true);
        conf1.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        conf2.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        conf1.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyInMemoryCacheLoader.class.getName(), null, false, false, false));
        this.cache1 = instance.createCache(conf1, false);
        this.cache2 = instance.createCache(conf2, false);
        this.listener = new TestCacheListener();
        this.cache1.addCacheListener((Object)this.listener);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(this.cache1, this.cache2);
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testPessimisticWithCacheLoader() throws Throwable {
        this.doTest(false);
    }

    public void testOptimisticWithCacheLoader() throws Throwable {
        this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.doTest(false);
    }

    public void testPessimisticWithPassivation() throws Throwable {
        this.cache1.getConfiguration().getCacheLoaderConfig().setPassivation(true);
        this.doTest(false);
    }

    public void testOptimisticWithPassivation() throws Throwable {
        this.cache1.getConfiguration().getCacheLoaderConfig().setPassivation(true);
        this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.doTest(false);
    }

    public void testPessimisticWithCacheLoaderTx() throws Throwable {
        this.doTest(true);
    }

    public void testOptimisticWithCacheLoaderTx() throws Throwable {
        this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.doTest(true);
    }

    public void testPessimisticWithPassivationTx() throws Throwable {
        this.cache1.getConfiguration().getCacheLoaderConfig().setPassivation(true);
        this.doTest(true);
    }

    public void testOptimisticWithPassivationTx() throws Throwable {
        this.cache1.getConfiguration().getCacheLoaderConfig().setPassivation(true);
        this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.doTest(true);
    }

    private void doTest(boolean tx) throws Throwable {
        this.cache1.stop();
        this.cache1.start();
        this.cache2.start();
        TransactionManager tm = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.listener.sameThreadExpected = true;
        this.listener.mainThread = Thread.currentThread();
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        if (tx) {
            tm.begin();
        }
        this.cache1.put(fqn, (Object)"k", (Object)"v");
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.get(fqn, (Object)"k");
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.put(fqn, (Object)"k", (Object)"v2");
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.removeNode(fqn);
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.put(fqn, (Object)"k", (Object)"v3");
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.evict(fqn, true);
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.get(fqn, (Object)"k");
        if (tx) {
            tm.commit();
        }
        if (tx) {
            tm.begin();
        }
        this.cache1.move(fqn, Fqn.ROOT);
        if (tx) {
            tm.commit();
        }
        this.listener.sameThreadExpected = false;
        this.cache2.stop();
        TestingUtil.sleepThread(500L);
        Iterator<Throwable> i$ = this.listener.exceptions.iterator();
        if (i$.hasNext()) {
            Throwable e = i$.next();
            throw e;
        }
    }

    @CacheListener
    public class TestCacheListener {
        boolean sameThreadExpected;
        Thread mainThread;
        List<Throwable> exceptions = new LinkedList<Throwable>();

        @NodeCreated
        @NodeModified
        @NodeRemoved
        @NodeVisited
        @NodeEvicted
        @NodeLoaded
        @NodeMoved
        @NodeActivated
        @NodePassivated
        @CacheStarted
        @CacheStopped
        @ViewChanged
        @TransactionCompleted
        @TransactionRegistered
        public void testCallbackThread(Event e) {
            try {
                if (this.sameThreadExpected) {
                    AssertJUnit.assertSame((Object)this.mainThread, (Object)Thread.currentThread());
                } else {
                    AssertJUnit.assertNotSame((Object)this.mainThread, (Object)Thread.currentThread());
                }
            }
            catch (Throwable t) {
                this.exceptions.add(t);
            }
        }
    }
}

