/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.List;
import org.easymock.EasyMock;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.notifications.IncorrectCacheListenerException;
import org.jboss.cache.notifications.NotifierImpl;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.NodeMoved;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.NodeMovedEvent;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class NotifierAnnotationsTest {
    private NotifierImpl n;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.n = new NotifierImpl();
        this.n.injectDependencies((CacheSPI)EasyMock.createNiceMock(CacheSPI.class), new Configuration());
        this.n.start();
    }

    @AfterMethod
    public void tearDown() {
        this.n.stop();
        this.n.destroy();
        this.n = null;
    }

    public void testControl() {
        TestControlListener l = new TestControlListener();
        this.n.addCacheListener((Object)l);
        AssertJUnit.assertEquals((int)1, (int)this.n.getCacheListeners().size());
    }

    public void testCacheListenerNoMethods() {
        TestCacheListenerNoMethodsListener l = new TestCacheListenerNoMethodsListener();
        this.n.addCacheListener((Object)l);
        AssertJUnit.assertEquals((String)"Hello", (String)((Object)l).toString());
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)this.n.getCacheListeners().isEmpty());
    }

    public void testNonAnnotatedListener() {
        TestNonAnnotatedListener l = new TestNonAnnotatedListener();
        try {
            this.n.addCacheListener((Object)l);
            AssertJUnit.fail((String)"Should not accept an un-annotated cache listener");
        }
        catch (IncorrectCacheListenerException incorrectCacheListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)this.n.getCacheListeners().isEmpty());
    }

    public void testNonPublicListener() {
        TestNonPublicListener l = new TestNonPublicListener();
        try {
            this.n.addCacheListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a private callback class");
        }
        catch (IncorrectCacheListenerException incorrectCacheListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)this.n.getCacheListeners().isEmpty());
    }

    public void testNonPublicListenerMethod() {
        TestNonPublicListenerMethodListener l = new TestNonPublicListenerMethodListener();
        this.n.addCacheListener((Object)l);
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)this.n.getCacheListeners().isEmpty());
    }

    public void testNonVoidReturnTypeMethod() {
        TestNonVoidReturnTypeMethodListener l = new TestNonVoidReturnTypeMethodListener();
        try {
            this.n.addCacheListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a listener method with a return type");
        }
        catch (IncorrectCacheListenerException incorrectCacheListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)this.n.getCacheListeners().isEmpty());
    }

    public void testIncorrectMethodSignature1() {
        TestIncorrectMethodSignature1Listener l = new TestIncorrectMethodSignature1Listener();
        try {
            this.n.addCacheListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a cache listener with a bad method signature");
        }
        catch (IncorrectCacheListenerException incorrectCacheListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)this.n.getCacheListeners().isEmpty());
    }

    public void testIncorrectMethodSignature2() {
        TestIncorrectMethodSignature2Listener l = new TestIncorrectMethodSignature2Listener();
        try {
            this.n.addCacheListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a cache listener with a bad method signature");
        }
        catch (IncorrectCacheListenerException incorrectCacheListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)this.n.getCacheListeners().isEmpty());
    }

    public void testIncorrectMethodSignature3() {
        TestIncorrectMethodSignature3Listener l = new TestIncorrectMethodSignature3Listener();
        try {
            this.n.addCacheListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a cache listener with a bad method signature");
        }
        catch (IncorrectCacheListenerException incorrectCacheListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)this.n.getCacheListeners().isEmpty());
    }

    public void testUnassignableMethodSignature() {
        TestUnassignableMethodSignatureListener l = new TestUnassignableMethodSignatureListener();
        try {
            this.n.addCacheListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a cache listener with a bad method signature");
        }
        catch (IncorrectCacheListenerException incorrectCacheListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)this.n.getCacheListeners().isEmpty());
    }

    public void testPartlyUnassignableMethodSignature() {
        TestPartlyUnassignableMethodSignatureListener l = new TestPartlyUnassignableMethodSignatureListener();
        try {
            this.n.addCacheListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a cache listener with a bad method signature");
        }
        catch (IncorrectCacheListenerException incorrectCacheListenerException) {
            // empty catch block
        }
    }

    public void testMultipleMethods() {
        TestMultipleMethodsListener l = new TestMultipleMethodsListener();
        this.n.addCacheListener((Object)l);
        List invocations = this.n.cacheStartedListeners;
        AssertJUnit.assertEquals((int)1, (int)invocations.size());
        invocations = this.n.cacheStoppedListeners;
        AssertJUnit.assertEquals((int)1, (int)invocations.size());
        AssertJUnit.assertEquals((int)1, (int)this.n.getCacheListeners().size());
    }

    public void testMultipleAnnotationsOneMethod() {
        TestMultipleAnnotationsOneMethodListener l = new TestMultipleAnnotationsOneMethodListener();
        this.n.addCacheListener((Object)l);
        List invocations = this.n.cacheStartedListeners;
        AssertJUnit.assertEquals((int)1, (int)invocations.size());
        invocations = this.n.cacheStoppedListeners;
        AssertJUnit.assertEquals((int)1, (int)invocations.size());
        AssertJUnit.assertEquals((int)1, (int)this.n.getCacheListeners().size());
    }

    public void testMultipleMethodsOneAnnotation() {
        TestMultipleMethodsOneAnnotationListener l = new TestMultipleMethodsOneAnnotationListener();
        this.n.addCacheListener((Object)l);
        List invocations = this.n.cacheStartedListeners;
        AssertJUnit.assertEquals((int)2, (int)invocations.size());
        AssertJUnit.assertEquals((int)1, (int)this.n.getCacheListeners().size());
    }

    @CacheListener
    public class TestMultipleMethodsOneAnnotationListener {
        @CacheStarted
        public void callback1(Event e) {
        }

        @CacheStarted
        public void callback2(Event e) {
        }
    }

    @CacheListener
    public class TestMultipleAnnotationsOneMethodListener {
        @CacheStopped
        @CacheStarted
        public void callback(Event nme) {
        }
    }

    @CacheListener
    public class TestMultipleMethodsListener {
        @CacheStarted
        public void callback1(Event e) {
        }

        @CacheStopped
        public void callback2(Event e) {
        }
    }

    @CacheListener
    public class TestPartlyUnassignableMethodSignatureListener {
        @NodeMoved
        @CacheStarted
        public void callback(NodeMovedEvent nme) {
        }
    }

    @CacheListener
    public class TestUnassignableMethodSignatureListener {
        @CacheStarted
        public void callback(NodeMovedEvent nme) {
        }
    }

    @CacheListener
    public class TestIncorrectMethodSignature3Listener {
        @CacheStarted
        public void callback(Event e, String ... s) {
        }
    }

    @CacheListener
    public class TestIncorrectMethodSignature2Listener {
        @CacheStarted
        public void callback(Event e, String s) {
        }
    }

    @CacheListener
    public class TestIncorrectMethodSignature1Listener {
        @CacheStarted
        public void callback() {
        }
    }

    @CacheListener
    public class TestNonVoidReturnTypeMethodListener {
        @CacheStarted
        public String callback(Event e) {
            return "Hello";
        }
    }

    @CacheListener
    public class TestNonPublicListenerMethodListener {
        @CacheStarted
        protected void callback(Event e) {
        }
    }

    @CacheListener
    protected class TestNonPublicListener {
        protected TestNonPublicListener() {
        }

        @CacheStarted
        public void callback() {
        }
    }

    public class TestNonAnnotatedListener {
        public String toString() {
            return "Hello";
        }
    }

    @CacheListener
    public class TestCacheListenerNoMethodsListener {
        public String toString() {
            return "Hello";
        }
    }

    @CacheListener
    public class TestControlListener {
        @CacheStarted
        @CacheStopped
        public void callback(Event e) {
            System.out.println("Hello");
        }
    }
}

