/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true)
public class ConcurrentTransactionTest
extends AbstractOptimisticTestCase {
    private CacheSPI<Object, Object> cache;
    private Fqn f = Fqn.fromString((String)"/a/b");
    private List<Exception> exceptions = new CopyOnWriteArrayList<Exception>();

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        try {
            this.cache = this.createCacheUnstarted();
            this.cache.getConfiguration().setUseRegionBasedMarshalling(true);
            this.cache.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testConcurrentTransactions() throws Exception {
        TransactionManager tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        Fqn abcd = Fqn.fromString((String)"/a/b/c/d");
        Fqn abce = Fqn.fromString((String)"/a/b/c/e");
        Fqn abcf = Fqn.fromString((String)"/a/b/c/f");
        Fqn abcg = Fqn.fromString((String)"/a/b/c/g");
        Fqn abxy = Fqn.fromString((String)"/a/b/x/y");
        this.cache.put(abcd, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(abcd, (Object)this.key));
        tm.begin();
        Transaction tx = tm.getTransaction();
        this.cache.put(abxy, (Object)this.key, (Object)this.value);
        tm.suspend();
        this.cache.put(abcd, (Object)this.key, (Object)(this.value + this.value));
        this.cache.put(abce, (Object)this.key, (Object)this.value);
        this.cache.put(abcf, (Object)this.key, (Object)this.value);
        this.cache.put(abcg, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)(this.value + this.value), (Object)this.cache.get(abcd, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(abce, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(abcf, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(abcg, (Object)this.key));
        tm.resume(tx);
        tm.commit();
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(abxy, (Object)this.key));
        NodeSPI n = this.cache.getRoot();
        System.out.println(n.getVersion());
    }

    public void testConcurrentCreationTestWithEmptyCache() throws Exception {
        this.doConcurrentCreationTest(false);
    }

    public void testConcurrentCreationTestWithEmptyCacheActivated() throws Exception {
        this.cache.put(Fqn.fromString((String)"/parent"), null);
        this.cache.getRegion(Fqn.fromString((String)"/parent"), true).activate();
        AssertJUnit.assertNotNull((Object)this.cache.peek(Fqn.fromString((String)"/parent"), false));
        this.doConcurrentCreationTest(false);
    }

    public void testConcurrentCreationTestWithPopulatedCache() throws Exception {
        this.doConcurrentCreationTest(true);
    }

    public void testConcurrentReadAndRemove() throws Exception {
        final LinkedList exceptions = new LinkedList();
        final CountDownLatch readerLatch = new CountDownLatch(1);
        final CountDownLatch readerFinishedLatch = new CountDownLatch(1);
        final Fqn fqn = Fqn.fromString((String)"/parent/child");
        this.cache.put(fqn, (Object)"k", (Object)"v");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Reader
        extends Thread {
            Reader() {
            }

            @Override
            public void run() {
                try {
                    ConcurrentTransactionTest.this.cache.getTransactionManager().begin();
                    ConcurrentTransactionTest.this.cache.get(fqn, (Object)"k");
                    readerFinishedLatch.countDown();
                    readerLatch.await();
                    ConcurrentTransactionTest.this.cache.getTransactionManager().commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    exceptions.add(e);
                }
            }
        }
        Reader reader = new Reader();
        reader.start();
        readerFinishedLatch.await();
        this.cache.removeNode(fqn.getParent());
        AssertJUnit.assertNull((Object)this.cache.peek(fqn.getParent(), false));
        readerLatch.countDown();
        reader.join();
        AssertJUnit.assertTrue((String)"Should not have caught any exceptions!!", (boolean)exceptions.isEmpty());
    }

    public void testConcurrentPutReadAndRemove() throws Exception {
        final LinkedList exceptions = new LinkedList();
        final CountDownLatch readerLatch = new CountDownLatch(1);
        final CountDownLatch readerFinishedLatch = new CountDownLatch(1);
        final Fqn fqn = Fqn.fromString((String)"/parent/child");
        this.cache.put(fqn, (Object)"k", (Object)"v");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Reader
        extends Thread {
            Reader() {
            }

            @Override
            public void run() {
                try {
                    ConcurrentTransactionTest.this.cache.getTransactionManager().begin();
                    ConcurrentTransactionTest.this.cache.put(Fqn.ROOT, (Object)"x", (Object)"y");
                    ConcurrentTransactionTest.this.cache.get(fqn, (Object)"k");
                    readerFinishedLatch.countDown();
                    readerLatch.await();
                    ConcurrentTransactionTest.this.cache.getTransactionManager().commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    exceptions.add(e);
                }
            }
        }
        Reader reader = new Reader();
        reader.start();
        readerFinishedLatch.await();
        this.cache.removeNode(fqn.getParent());
        AssertJUnit.assertNull((Object)this.cache.peek(fqn.getParent(), false));
        readerLatch.countDown();
        reader.join();
        AssertJUnit.assertTrue((String)"Should not have caught any exceptions!!", (boolean)exceptions.isEmpty());
    }

    private void doConcurrentCreationTest(boolean prepopulateParent) throws Exception {
        if (prepopulateParent) {
            this.cache.put(Fqn.fromString((String)"/parent/dummy"), (Object)"k", (Object)"v");
        }
        final LinkedList exceptions = new LinkedList();
        final CountDownLatch latch = new CountDownLatch(1);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ConcurrentCreator
        extends Thread {
            private String name;

            public ConcurrentCreator(String name) {
                this.name = name;
            }

            @Override
            public void run() {
                try {
                    ConcurrentTransactionTest.this.cache.getTransactionManager().begin();
                    ConcurrentTransactionTest.this.cache.put(Fqn.fromString((String)("/parent/child" + this.name)), (Object)"key", (Object)"value");
                    latch.await();
                    ConcurrentTransactionTest.this.cache.getTransactionManager().commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    exceptions.add(e);
                }
            }
        }
        ConcurrentCreator one = new ConcurrentCreator("one");
        ConcurrentCreator two = new ConcurrentCreator("two");
        one.start();
        two.start();
        latch.countDown();
        one.join();
        two.join();
        AssertJUnit.assertTrue((String)"Should not have caught any exceptions!!", (boolean)exceptions.isEmpty());
    }

    public void testConcurrentPut() throws Exception {
        String slowThreadName = "SLOW";
        String fastThreadName = "FAST";
        CommandInterceptor slowdownInterceptor = new CommandInterceptor(){

            public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
                if (Thread.currentThread().getName().equals("SLOW")) {
                    Thread.sleep(1000L);
                }
                return super.handleDefault(ctx, command);
            }
        };
        TestingUtil.injectInterceptor(this.cache, slowdownInterceptor, OptimisticCreateIfNotExistsInterceptor.class);
        Putter slow = new Putter("SLOW");
        Putter fast = new Putter("FAST");
        slow.start();
        TestingUtil.sleepThread(200L);
        fast.start();
        fast.join();
        slow.join();
        for (Exception e : this.exceptions) {
            e.printStackTrace();
        }
        AssertJUnit.assertEquals((int)0, (int)this.exceptions.size());
    }

    public void testConcurrentRemove() throws Exception {
        String slowThreadName = "SLOW";
        String fastThreadName = "FAST";
        CommandInterceptor slowdownInterceptor = new CommandInterceptor(){

            public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
                if (Thread.currentThread().getName().equals("SLOW") && ctx.getMethodCall().getMethodId() == 18) {
                    Thread.sleep(1000L);
                }
                return this.invokeNextInterceptor(ctx, command);
            }
        };
        TestingUtil.injectInterceptor(this.cache, slowdownInterceptor, TxInterceptor.class);
        Remover slow = new Remover("SLOW");
        Remover fast = new Remover("FAST");
        this.cache.put(this.f, (Object)"hello", (Object)"world");
        slow.start();
        TestingUtil.sleepThread(200L);
        fast.start();
        fast.join();
        slow.join();
        for (Exception e : this.exceptions) {
            e.printStackTrace();
        }
        AssertJUnit.assertEquals((int)0, (int)this.exceptions.size());
    }

    public class Remover
    extends Thread {
        public Remover(String name) {
            super(name);
        }

        public void run() {
            try {
                ConcurrentTransactionTest.this.cache.getTransactionManager().begin();
                ConcurrentTransactionTest.this.cache.removeNode(ConcurrentTransactionTest.this.f);
                ConcurrentTransactionTest.this.cache.getTransactionManager().commit();
            }
            catch (Exception e) {
                ConcurrentTransactionTest.this.exceptions.add(e);
            }
        }
    }

    public class Putter
    extends Thread {
        public Putter(String name) {
            super(name);
        }

        public void run() {
            try {
                ConcurrentTransactionTest.this.cache.getTransactionManager().begin();
                ConcurrentTransactionTest.this.cache.put(Fqn.fromRelativeElements((Fqn)ConcurrentTransactionTest.this.f, (Object[])new String[]{this.getName()}), (Object)"a", (Object)"b");
                ConcurrentTransactionTest.this.cache.getTransactionManager().commit();
            }
            catch (Exception e) {
                ConcurrentTransactionTest.this.exceptions.add(e);
            }
        }
    }
}

