/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.Collections;
import java.util.HashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.interceptors.InvocationContextInterceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.OptimisticValidatorInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true)
public class ValidatorInterceptorTest
extends AbstractOptimisticTestCase {
    private CacheSPI<Object, Object> cache;
    private TransactionManager mgr;
    private MockInterceptor dummy;

    @BeforeMethod
    public void setUp() throws Exception {
        this.cache = this.createCacheWithListener();
        this.mgr = this.cache.getTransactionManager();
        InvocationContextInterceptor ici = TestingUtil.findInterceptor(this.cache, InvocationContextInterceptor.class);
        OptimisticValidatorInterceptor validateInterceptor = TestingUtil.findInterceptor(this.cache, OptimisticValidatorInterceptor.class);
        OptimisticCreateIfNotExistsInterceptor interceptor = TestingUtil.findInterceptor(this.cache, OptimisticCreateIfNotExistsInterceptor.class);
        OptimisticNodeInterceptor nodeInterceptor = TestingUtil.findInterceptor(this.cache, OptimisticNodeInterceptor.class);
        this.dummy = new MockInterceptor();
        ici.setNext((CommandInterceptor)validateInterceptor);
        validateInterceptor.setNext((CommandInterceptor)interceptor);
        interceptor.setNext((CommandInterceptor)nodeInterceptor);
        nodeInterceptor.setNext((CommandInterceptor)this.dummy);
        TestingUtil.replaceInterceptorChain(this.cache, (CommandInterceptor)ici);
        this.cache.addInterceptor((CommandInterceptor)new ResetRemoteFlagInterceptor(), InvocationContextInterceptor.class);
        System.out.println("Interceptors: " + CachePrinter.printCacheInterceptors(this.cache));
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testTransactionvalidateMethod() throws Throwable {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        OptimisticPrepareCommand prepareCommand = new OptimisticPrepareCommand(gtx, entry.getModifications(), (Address)gtx.getAddress(), Boolean.FALSE.booleanValue());
        TestingUtil.replicateCommand(this.cache, (VisitableCommand)prepareCommand);
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)prepareCommand, (Object)this.dummy.getCalledCommand());
        this.mgr.commit();
    }

    public void testTransactionValidateFailureMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        workspace.getNode(Fqn.fromString((String)"/one/two")).getNode().setVersion((DataVersion)new DefaultDataVersion(2L));
        OptimisticPrepareCommand prepareCommand = new OptimisticPrepareCommand(gtx, entry.getModifications(), (Address)gtx.getAddress(), Boolean.FALSE.booleanValue());
        try {
            TestingUtil.replicateCommand(this.cache, (VisitableCommand)prepareCommand);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        this.mgr.commit();
    }

    public void testTransactionValidateCommitMethod() throws Throwable {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        this.cache.put("/one/two", Collections.singletonMap("key1", pojo));
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        OptimisticPrepareCommand prepareCommand = new OptimisticPrepareCommand(gtx, entry.getModifications(), (Address)gtx.getAddress(), Boolean.FALSE.booleanValue());
        try {
            TestingUtil.replicateCommand(this.cache, (VisitableCommand)prepareCommand);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        CommitCommand commitCommand = new CommitCommand(gtx);
        TestingUtil.replicateCommand(this.cache, (VisitableCommand)commitCommand);
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertEquals((Object)commitCommand, (Object)this.dummy.getCalledCommand());
        NodeSPI node = workspace.getNode(Fqn.ROOT).getNode();
        AssertJUnit.assertNotNull((Object)node);
        node = (NodeSPI)node.getChild((Object)"one");
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(0L), (Object)node.getVersion());
        AssertJUnit.assertNotNull((Object)node);
        node = (NodeSPI)node.getChild((Object)"two");
        AssertJUnit.assertNotNull((Object)node);
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(1L), (Object)node.getVersion());
        AssertJUnit.assertEquals((Object)pojo, (Object)node.get((Object)"key1"));
        this.mgr.commit();
    }

    public void testTransactionValidateFailRemoteCommitMethod() throws Throwable {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        OptimisticPrepareCommand prepareCommand = new OptimisticPrepareCommand(gtx, entry.getModifications(), (Address)gtx.getAddress(), Boolean.FALSE.booleanValue());
        try {
            TestingUtil.replicateCommand(this.cache, (VisitableCommand)prepareCommand);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        CommitCommand commitCommand = new CommitCommand(gtx);
        TestingUtil.replicateCommand(this.cache, (VisitableCommand)commitCommand);
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertEquals((Object)commitCommand, (Object)this.dummy.getCalledCommand());
        NodeSPI node = workspace.getNode(Fqn.fromString((String)"/")).getNode();
        AssertJUnit.assertNotNull((Object)node);
        node = (NodeSPI)node.getChild((Object)"one");
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(0L), (Object)node.getVersion());
        AssertJUnit.assertNotNull((Object)node);
        AssertJUnit.assertTrue((boolean)this.cache.exists(node.getFqn()));
        node = (NodeSPI)node.getChild((Object)"two");
        AssertJUnit.assertNotNull((Object)node);
        AssertJUnit.assertTrue((boolean)this.cache.exists(node.getFqn()));
        AssertJUnit.assertEquals((Object)new DefaultDataVersion(1L), (Object)node.getVersion());
        AssertJUnit.assertEquals((Object)pojo, (Object)node.get((Object)"key1"));
        this.mgr.commit();
    }

    public void testTransactionValidateRollbackMethod() throws Throwable {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((Object)pojo, (Object)workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)1, (int)workspace.getNode(Fqn.fromString((String)"/one/two")).getMergedData().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        OptimisticPrepareCommand prepareCommand = new OptimisticPrepareCommand(gtx, entry.getModifications(), (Address)gtx.getAddress(), Boolean.FALSE.booleanValue());
        try {
            TestingUtil.replicateCommand(this.cache, (VisitableCommand)prepareCommand);
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        RollbackCommand rollbackCommand = new RollbackCommand(gtx);
        TestingUtil.replicateCommand(this.cache, (VisitableCommand)rollbackCommand);
        AssertJUnit.assertEquals((int)0, (int)workspace.getNodes().size());
        AssertJUnit.assertNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        this.mgr.commit();
    }

    public static class ResetRemoteFlagInterceptor
    extends CommandInterceptor {
        public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            this.log.trace((Object)("Setting isRemote on globalTransaction " + ctx.getGlobalTransaction() + " to true"));
            ctx.getGlobalTransaction().setRemote(true);
            return this.invokeNextInterceptor(ctx, command);
        }
    }
}

