/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options;

import java.util.concurrent.CountDownLatch;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeInvalidated;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, enabled=false)
public class ForceCacheModeTest {
    private static final Log log = LogFactory.getLog(ForceCacheModeTest.class);
    private static final Fqn FQNA = Fqn.fromString((String)"/A");
    private static final String KEY = "key";
    private static final String VALUE1 = "value1";
    private static final String VALUE2 = "value2";
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    private Option asyncOption;
    private Option syncOption;
    private static CountDownLatch latch;
    private BlockingListener listener;

    private void createCaches(Configuration.NodeLockingScheme scheme, Configuration.CacheMode mode) {
        Configuration c = new Configuration();
        c.setNodeLockingScheme(scheme);
        c.setCacheMode(mode);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        c = new Configuration();
        c.setNodeLockingScheme(scheme);
        c.setCacheMode(mode);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        this.cache1.start();
        this.cache2.start();
        this.asyncOption = new Option();
        this.asyncOption.setForceAsynchronous(true);
        this.syncOption = new Option();
        this.syncOption.setForceSynchronous(true);
        Option local = new Option();
        local.setCacheModeLocal(true);
        this.cache1.getInvocationContext().setOptionOverrides(local);
        this.cache1.put(FQNA, (Object)KEY, (Object)VALUE1);
        AssertJUnit.assertEquals((String)"Cache1 correct", (Object)VALUE1, (Object)this.cache1.get(FQNA, (Object)KEY));
        local = new Option();
        local.setCacheModeLocal(true);
        this.cache2.getInvocationContext().setOptionOverrides(local);
        this.cache2.put(FQNA, (Object)KEY, (Object)VALUE1);
        AssertJUnit.assertEquals((String)"Cache1 correct", (Object)VALUE1, (Object)this.cache1.get(FQNA, (Object)KEY));
        AssertJUnit.assertEquals((String)"Cache2 correct", (Object)VALUE1, (Object)this.cache2.get(FQNA, (Object)KEY));
        this.listener = new BlockingListener();
        this.cache2.addCacheListener((Object)this.listener);
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        latch = new CountDownLatch(1);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache1 != null) {
            TestingUtil.killCaches(new Cache[]{this.cache1});
            this.cache1 = null;
        }
        if (this.cache2 != null) {
            if (this.listener != null) {
                this.cache2.removeCacheListener((Object)this.listener);
            }
            TestingUtil.killCaches(new Cache[]{this.cache2});
            this.cache2 = null;
        }
        latch.countDown();
    }

    public void testPessimisticReplicationPutForceAsync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.REPL_SYNC);
        this.checkNoBlocking(null, this.asyncOption, false);
    }

    public void testPessimisticReplicationRemoveForceAsync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.REPL_SYNC);
        this.checkNoBlocking(null, this.asyncOption, true);
    }

    public void testPessimisticReplicationPutForceAsyncWithTx() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.REPL_SYNC);
        this.checkBlocking(this.cache1.getTransactionManager(), this.asyncOption, false);
    }

    public void testPessimisticInvalidationPutForceAsync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.INVALIDATION_SYNC);
        this.checkNoBlocking(null, this.asyncOption, false);
    }

    public void testPessimisticInvalidationRemoveForceAsync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.INVALIDATION_SYNC);
        this.checkNoBlocking(null, this.asyncOption, true);
    }

    public void testPessimisticInvalidationPutForceAsyncWithTx() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.INVALIDATION_SYNC);
        this.checkBlocking(this.cache1.getTransactionManager(), this.asyncOption, false);
    }

    public void testPessimisticReplicationPutForceSync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.REPL_ASYNC);
        this.checkBlocking(null, this.syncOption, false);
    }

    public void testPessimisticReplicationRemoveForceSync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.REPL_ASYNC);
        this.checkBlocking(null, this.syncOption, true);
    }

    public void testPessimisticReplicationPutForceSyncWithTx() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.REPL_ASYNC);
        this.checkNoBlocking(this.cache1.getTransactionManager(), this.syncOption, false);
    }

    public void testPessimisticInvalidationPutForceSync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.INVALIDATION_ASYNC);
        this.checkBlocking(null, this.syncOption, false);
    }

    public void testPessimisticInvalidationRemoveForceSync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.INVALIDATION_ASYNC);
        this.checkBlocking(null, this.syncOption, true);
    }

    public void testPessimisticInvalidationPutForceSyncWithTx() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.PESSIMISTIC, Configuration.CacheMode.INVALIDATION_ASYNC);
        this.checkNoBlocking(this.cache1.getTransactionManager(), this.syncOption, false);
    }

    public void testOptimisticReplicationPutForceAsync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.REPL_SYNC);
        this.checkNoBlocking(null, this.asyncOption, false);
    }

    public void testOptimisticReplicationRemoveForceAsync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.REPL_SYNC);
        this.checkNoBlocking(null, this.asyncOption, true);
    }

    public void testOptimisticReplicationPutForceAsyncWithTx() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.REPL_SYNC);
        this.checkBlocking(this.cache1.getTransactionManager(), this.asyncOption, false);
    }

    public void testOptimisticInvalidationPutForceAsync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.INVALIDATION_SYNC);
        this.checkNoBlocking(null, this.asyncOption, false);
    }

    public void testOptimisticInvalidationRemoveForceAsync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.INVALIDATION_SYNC);
        this.checkNoBlocking(null, this.asyncOption, true);
    }

    public void testOptimisticInvalidationPutForceAsyncWithTx() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.INVALIDATION_SYNC);
        this.checkBlocking(this.cache1.getTransactionManager(), this.asyncOption, false);
    }

    public void testOptimisticReplicationPutForceSync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.REPL_ASYNC);
        this.checkBlocking(null, this.syncOption, false);
    }

    public void testOptimisticReplicationRemoveForceSync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.REPL_ASYNC);
        this.checkBlocking(null, this.syncOption, true);
    }

    public void testOptimisticReplicationPutForceSyncWithTx() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.REPL_ASYNC);
        this.checkNoBlocking(this.cache1.getTransactionManager(), this.syncOption, false);
    }

    public void testOptimisticInvalidationPutForceSync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.INVALIDATION_ASYNC);
        this.checkBlocking(null, this.syncOption, false);
    }

    public void testOptimisticInvalidationRemoveForceSync() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.INVALIDATION_ASYNC);
        this.checkBlocking(null, this.syncOption, true);
    }

    public void testOptimisticInvalidationPutForceSyncWithTx() throws Exception {
        this.createCaches(Configuration.NodeLockingScheme.OPTIMISTIC, Configuration.CacheMode.INVALIDATION_ASYNC);
        this.checkNoBlocking(this.cache1.getTransactionManager(), this.syncOption, false);
    }

    private void checkNoBlocking(TransactionManager tm, Option option, boolean removeTest) throws InterruptedException, CacheException {
        int i;
        Updater updater = new Updater(tm, option, removeTest);
        updater.start();
        updater.join(250L);
        AssertJUnit.assertTrue((String)"Updater didn't finish", (boolean)updater.finished);
        AssertJUnit.assertNull((String)"Updater failed", (Object)updater.failure);
        for (i = 0; i < 50 && !this.listener.blocked; ++i) {
            TestingUtil.sleepThread(10L);
        }
        AssertJUnit.assertTrue((String)"Listener should have blocked!", (boolean)this.listener.blocked);
        AssertJUnit.assertEquals((String)"Cache1 state incorrect!", (Object)(removeTest ? null : VALUE2), (Object)this.cache1.get(FQNA, (Object)KEY));
        latch.countDown();
        for (i = 0; i < 50 && this.listener.blocked; ++i) {
            TestingUtil.sleepThread(10L);
        }
        TestingUtil.sleepThread(5L);
        Configuration.CacheMode mode = this.cache2.getConfiguration().getCacheMode();
        boolean expectNull = removeTest || mode == Configuration.CacheMode.INVALIDATION_ASYNC || mode == Configuration.CacheMode.INVALIDATION_SYNC;
        AssertJUnit.assertEquals((String)"Cache2 state incorrect!", (Object)(expectNull ? null : VALUE2), (Object)this.cache2.get(FQNA, (Object)KEY));
    }

    private void checkBlocking(TransactionManager tm, Option option, boolean removeTest) throws InterruptedException, CacheException {
        int i;
        Updater updater = new Updater(tm, option, removeTest);
        updater.start();
        updater.join(250L);
        AssertJUnit.assertFalse((String)"Updater should have blocked!", (boolean)updater.finished);
        for (i = 0; i < 50 && !this.listener.blocked; ++i) {
            TestingUtil.sleepThread(10L);
        }
        AssertJUnit.assertTrue((String)"Listener should have blocked", (boolean)this.listener.blocked);
        latch.countDown();
        for (i = 0; i < 50 && (!updater.finished || this.listener.blocked); ++i) {
            TestingUtil.sleepThread(10L);
        }
        AssertJUnit.assertTrue((String)"Updater should have finished", (boolean)updater.finished);
        AssertJUnit.assertFalse((String)"Listener should have blocked", (boolean)this.listener.blocked);
        AssertJUnit.assertNull((String)"Updater should have succeeded", (Object)updater.failure);
        AssertJUnit.assertEquals((String)"Cache1 state incorrect", (Object)(removeTest ? null : VALUE2), (Object)this.cache1.get(FQNA, (Object)KEY));
        TestingUtil.sleepThread(500L);
        Configuration.CacheMode mode = this.cache2.getConfiguration().getCacheMode();
        boolean expectNull = removeTest || mode == Configuration.CacheMode.INVALIDATION_ASYNC || mode == Configuration.CacheMode.INVALIDATION_SYNC;
        AssertJUnit.assertEquals((String)"Cache2 state incorrect", (Object)(expectNull ? null : VALUE2), (Object)this.cache2.get(FQNA, (Object)KEY));
    }

    @CacheListener
    public static class BlockingListener {
        boolean blocked;

        @NodeModified
        @NodeRemoved
        @NodeInvalidated
        public void block(NodeEvent event) {
            log.error((Object)("Received event notification " + event));
            if (!event.isPre() && FQNA.equals((Object)event.getFqn())) {
                this.blocked = true;
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.blocked = false;
            }
        }
    }

    class Updater
    extends Thread {
        TransactionManager tm;
        Option option;
        boolean remove;
        Throwable failure;
        boolean finished;

        Updater(TransactionManager tm, Option option) {
            this(tm, option, false);
        }

        Updater(TransactionManager tm, Option option, boolean remove) {
            this.tm = tm;
            this.option = option;
            this.remove = remove;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block12: {
                    try {
                        try {
                            if (this.tm != null) {
                                this.tm.begin();
                            }
                            ForceCacheModeTest.this.cache1.getInvocationContext().setOptionOverrides(this.option);
                            if (this.remove) {
                                ForceCacheModeTest.this.cache1.remove(FQNA, (Object)ForceCacheModeTest.KEY);
                            } else {
                                ForceCacheModeTest.this.cache1.put(FQNA, (Object)ForceCacheModeTest.KEY, (Object)ForceCacheModeTest.VALUE2);
                            }
                        }
                        catch (Exception e) {
                            if (this.tm == null) throw e;
                            this.tm.setRollbackOnly();
                            throw e;
                        }
                        Object var3_1 = null;
                        if (this.tm == null) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var3_2 = null;
                        if (this.tm != null) {
                            this.tm.commit();
                        }
                        this.finished = true;
                        throw throwable;
                    }
                    this.tm.commit();
                }
                this.finished = true;
                return;
            }
            catch (Throwable t) {
                this.failure = t;
            }
        }
    }
}

