/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options.cachemodelocal;

import java.util.HashMap;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class CacheModeLocalTestBase {
    protected Configuration.CacheMode cacheMode;
    protected String nodeLockingScheme;
    protected boolean isInvalidation;
    private ThreadLocal<CacheSPI<String, String>> cache1TL = new ThreadLocal();
    private ThreadLocal<CacheSPI<String, String>> cache2TL = new ThreadLocal();
    private ThreadLocal<NodeSPI<String, String>> root1TL = new ThreadLocal();
    private ThreadLocal<NodeSPI<String, String>> root2TL = new ThreadLocal();
    private final Fqn fqn = Fqn.fromString((String)"/a");
    private final String key = "key";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        CacheSPI cache1 = this.cache1TL.get();
        CacheSPI cache2 = this.cache2TL.get();
        if (cache1 != null || cache2 != null) {
            this.tearDown();
        }
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        Configuration c = new Configuration();
        c.setClusterName("test");
        c.setStateRetrievalTimeout(1000L);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c.setNodeLockingScheme(this.nodeLockingScheme);
        c.setCacheMode(this.cacheMode);
        cache1 = (CacheSPI)instance.createCache(c, false);
        cache1.start();
        c = new Configuration();
        c.setClusterName("test");
        c.setStateRetrievalTimeout(1000L);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c.setNodeLockingScheme(this.nodeLockingScheme);
        c.setCacheMode(this.cacheMode);
        cache2 = (CacheSPI)instance.createCache(c, false);
        cache2.start();
        this.cache1TL.set((CacheSPI<String, String>)cache1);
        this.cache2TL.set((CacheSPI<String, String>)cache2);
        this.root1TL.set((NodeSPI<String, String>)cache1.getRoot());
        this.root2TL.set((NodeSPI<String, String>)cache2.getRoot());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        TestingUtil.killCaches(new Cache[]{cache1, cache2});
        this.cache1TL.set(null);
        this.cache2TL.set(null);
    }

    public void testPutKeyValue() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        cache1.getInvocationContext().getOptionOverrides().reset();
        cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache2.get(this.fqn, (Object)"key"));
        }
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache2.put(this.fqn, (Object)"key", (Object)"value2");
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get(this.fqn, (Object)"key")));
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        cache2.getInvocationContext().getOptionOverrides().reset();
        cache2.put(this.fqn, (Object)"key", (Object)"value2");
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value2", (String)((String)cache1.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache1.get(this.fqn, (Object)"key"));
        }
    }

    public void testPutKeyValueViaNodeAPI() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        NodeSPI<String, String> root1 = this.root1TL.get();
        NodeSPI<String, String> root2 = this.root2TL.get();
        Node node1 = root1.addChild(this.fqn);
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        node1.put((Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        cache1.getInvocationContext().getOptionOverrides().reset();
        node1.put((Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache2.get(this.fqn, (Object)"key"));
        }
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        Node node2 = root2.addChild(this.fqn);
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        node2.put((Object)"key", (Object)"value2");
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get(this.fqn, (Object)"key")));
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        cache2.getInvocationContext().getOptionOverrides().reset();
        node2.put((Object)"key", (Object)"value2");
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value2", (String)((String)cache1.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache1.get(this.fqn, (Object)"key"));
        }
    }

    public void testPutData() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache1.put(this.fqn, map);
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        cache1.put(this.fqn, map);
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache2.get(this.fqn, (Object)"key"));
        }
        map.put("key", "value2");
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache2.put(this.fqn, map);
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get(this.fqn, (Object)"key")));
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        cache2.getInvocationContext().getOptionOverrides().reset();
        cache2.put(this.fqn, (Object)"key", (Object)"value2");
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value2", (String)((String)cache1.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache1.get(this.fqn, (Object)"key"));
        }
    }

    public void testPutDataViaNodeAPI() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        NodeSPI<String, String> root1 = this.root1TL.get();
        NodeSPI<String, String> root2 = this.root2TL.get();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        Node node1 = root1.addChild(this.fqn);
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        node1.putAll(map);
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        node1.putAll(map);
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache2.get(this.fqn, (Object)"key"));
        }
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        Node node2 = root2.addChild(this.fqn);
        map.put("key", "value2");
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        node2.putAll(map);
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get(this.fqn, (Object)"key")));
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        cache2.getInvocationContext().getOptionOverrides().reset();
        node2.put((Object)"key", (Object)"value2");
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value2", (String)((String)cache1.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache1.get(this.fqn, (Object)"key"));
        }
    }

    public void testRemoveNode() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        cache1.getInvocationContext().setOptionOverrides(null);
        cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache1.removeNode(this.fqn);
        this.delay();
        AssertJUnit.assertNull((String)"should be null", (Object)cache1.get(this.fqn, (Object)"key"));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        cache1.removeNode(this.fqn);
        this.delay();
        AssertJUnit.assertNull((String)"should be null", (Object)cache1.get(this.fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"should be null", (Object)cache2.get(this.fqn, (Object)"key"));
    }

    public void testRemoveNodeViaNodeAPI() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        NodeSPI<String, String> root1 = this.root1TL.get();
        NodeSPI<String, String> root2 = this.root2TL.get();
        cache1.getInvocationContext().setOptionOverrides(null);
        cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        root1.removeChild(this.fqn);
        this.delay();
        AssertJUnit.assertNull((String)"should be null", (Object)cache1.get(this.fqn, (Object)"key"));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        root1.removeChild(this.fqn);
        this.delay();
        AssertJUnit.assertNull((String)"should be null", (Object)cache1.get(this.fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"should be null", (Object)cache2.get(this.fqn, (Object)"key"));
    }

    public void testRemoveKey() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        cache1.getInvocationContext().setOptionOverrides(null);
        cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache1.remove(this.fqn, (Object)"key");
        this.delay();
        AssertJUnit.assertNull((String)"should be null", (Object)cache1.get(this.fqn, (Object)"key"));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        cache1.getInvocationContext().getOptionOverrides().reset();
        cache1.remove(this.fqn, (Object)"key");
        this.delay();
        AssertJUnit.assertNull((String)"should be null", (Object)cache1.get(this.fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"should be null", (Object)cache2.get(this.fqn, (Object)"key"));
    }

    public void testRemoveKeyViaNodeAPI() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        NodeSPI<String, String> root1 = this.root1TL.get();
        NodeSPI<String, String> root2 = this.root2TL.get();
        Node node1 = root1.addChild(this.fqn);
        cache1.getInvocationContext().setOptionOverrides(null);
        node1.put((Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        node1.remove((Object)"key");
        this.delay();
        AssertJUnit.assertNull((String)"should be null", (Object)cache1.get(this.fqn, (Object)"key"));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        node1.put((Object)"key", (Object)"value");
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (this.isInvalidation) {
            AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get(this.fqn, (Object)"key"));
        } else {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        }
        cache1.getInvocationContext().getOptionOverrides().reset();
        node1.remove((Object)"key");
        this.delay();
        AssertJUnit.assertNull((String)"should be null", (Object)cache1.get(this.fqn, (Object)"key"));
        AssertJUnit.assertNull((String)"should be null", (Object)cache2.get(this.fqn, (Object)"key"));
    }

    public void testTransactionalBehaviourCommit() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        TransactionManager mgr = cache1.getTransactionManager();
        mgr.begin();
        cache1.getInvocationContext().getOptionOverrides().reset();
        cache1.put(this.fqn, (Object)"key", (Object)"value1");
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache1.put(this.fqn, (Object)"key", (Object)"value2");
        mgr.commit();
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value1", (String)((String)cache2.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((Object)cache2.get(this.fqn, (Object)"key"));
        }
        mgr.begin();
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache1.put(this.fqn, (Object)"key", (Object)"value3");
        cache1.getInvocationContext().getOptionOverrides().reset();
        cache1.put(this.fqn, (Object)"key", (Object)"value");
        mgr.commit();
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache2.get(this.fqn, (Object)"key"));
        }
        mgr = cache2.getTransactionManager();
        mgr.begin();
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        cache2.put(this.fqn, (Object)"key", (Object)"value3");
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache2.put(this.fqn, (Object)"key", (Object)"value2");
        mgr.commit();
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value3", (String)((String)cache1.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((Object)cache1.get(this.fqn, (Object)"key"));
        }
        mgr.begin();
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache2.put(this.fqn, (Object)"key", (Object)"value2");
        cache2.getInvocationContext().getOptionOverrides().reset();
        cache2.put(this.fqn, (Object)"key", (Object)"value4");
        mgr.commit();
        this.delay();
        AssertJUnit.assertEquals((String)"value4", (String)((String)cache2.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value4", (String)((String)cache1.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache1.get(this.fqn, (Object)"key"));
        }
    }

    public void testTransactionalBehaviourRollback() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        TransactionManager mgr = cache1.getTransactionManager();
        cache1.put("/a", (Object)"key", (Object)"old");
        cache1.put("/b", (Object)"key", (Object)"old");
        this.delay();
        mgr.begin();
        cache1.getInvocationContext().getOptionOverrides().reset();
        cache1.put("/a", (Object)"key", (Object)"value1");
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        cache1.put("/b", (Object)"key", (Object)"value2");
        mgr.rollback();
        this.delay();
        assert (((String)cache1.get("/a", (Object)"key")).equals("old"));
        assert (((String)cache1.get("/b", (Object)"key")).equals("old"));
        if (this.isInvalidation) {
            assert (cache2.get("/a", (Object)"key") == null);
            assert (cache2.get("/b", (Object)"key") == null);
        } else {
            assert (((String)cache2.get("/a", (Object)"key")).equals("old"));
            assert (((String)cache2.get("/b", (Object)"key")).equals("old"));
        }
    }

    public void testTransactionalBehaviourViaNodeAPI() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        NodeSPI<String, String> root1 = this.root1TL.get();
        NodeSPI<String, String> root2 = this.root2TL.get();
        Node node1 = root1.addChild(this.fqn);
        TransactionManager mgr = cache1.getTransactionManager();
        mgr.begin();
        cache1.getInvocationContext().getOptionOverrides().reset();
        node1.put((Object)"key", (Object)"value1");
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        node1.put((Object)"key", (Object)"value2");
        mgr.commit();
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value1", (String)((String)cache2.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((Object)cache2.get(this.fqn, (Object)"key"));
        }
        mgr.begin();
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        node1.put((Object)"key", (Object)"value3");
        cache1.getInvocationContext().getOptionOverrides().reset();
        node1.put((Object)"key", (Object)"value");
        mgr.commit();
        this.delay();
        AssertJUnit.assertEquals((String)"value", (String)((String)cache1.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value", (String)((String)cache2.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache2.get(this.fqn, (Object)"key"));
        }
        Node node2 = root2.addChild(this.fqn);
        mgr = cache2.getTransactionManager();
        mgr.begin();
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        node2.put((Object)"key", (Object)"value3");
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        node2.put((Object)"key", (Object)"value2");
        mgr.commit();
        this.delay();
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache2.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value3", (String)((String)cache1.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((Object)cache1.get(this.fqn, (Object)"key"));
        }
        mgr.begin();
        cache2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        node2.put((Object)"key", (Object)"value2");
        cache2.getInvocationContext().getOptionOverrides().reset();
        node2.put((Object)"key", (Object)"value4");
        mgr.commit();
        this.delay();
        AssertJUnit.assertEquals((String)"value4", (String)((String)cache2.get(this.fqn, (Object)"key")));
        if (!this.isInvalidation) {
            AssertJUnit.assertEquals((String)"value4", (String)((String)cache1.get(this.fqn, (Object)"key")));
        } else {
            AssertJUnit.assertNull((String)"should be invalidated", (Object)cache1.get(this.fqn, (Object)"key"));
        }
    }

    public void testAddChild() throws Exception {
        CacheSPI<String, String> cache1 = this.cache1TL.get();
        CacheSPI<String, String> cache2 = this.cache2TL.get();
        NodeSPI<String, String> root1 = this.root1TL.get();
        NodeSPI<String, String> root2 = this.root2TL.get();
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        root1.addChild(this.fqn);
        this.delay();
        AssertJUnit.assertTrue((boolean)root1.hasChild(this.fqn));
        Node node2 = root2.getChild(this.fqn);
        AssertJUnit.assertTrue((String)"Should be null", (node2 == null || this.isInvalidation && !node2.isValid() ? 1 : 0) != 0);
        root1.removeChild(this.fqn);
        cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        root1.addChild(this.fqn);
        this.delay();
        AssertJUnit.assertTrue((boolean)root1.hasChild(this.fqn));
        if (!this.isInvalidation) {
            AssertJUnit.assertTrue((boolean)root2.hasChild(this.fqn));
        } else {
            AssertJUnit.assertTrue((String)"Should be null", (node2 == null || !node2.isValid() ? 1 : 0) != 0);
        }
    }

    protected abstract void delay();
}

