/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class BasicPassivationTest {
    CacheSPI cache;
    long wakeupIntervalMillis = 0L;
    final String ROOT_STR = "/test";
    Throwable t1_ex;
    Throwable t2_ex;
    final long DURATION = 10000L;
    boolean isTrue;
    final String FQNSTR = "/org/jboss/3";
    int activationCount = 0;
    int passivationCount = 0;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupInterval();
        this.log("wakeupInterval is " + this.wakeupIntervalMillis);
        if (this.wakeupIntervalMillis < 0L) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
        this.t2_ex = null;
        this.t1_ex = null;
        this.isTrue = true;
    }

    private void initCaches() {
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = (CacheSPI)instance.createCache(new XmlConfigurationParser().parseFile("configs/local-passivation.xml"), false);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        TestCacheListener listener = new TestCacheListener();
        this.cache.getConfiguration().getCacheLoaderConfig().getFirstCacheLoaderConfig().setClassName(DummyInMemoryCacheLoader.class.getName());
        this.cache.start();
        this.cache.getNotifier().addCacheListener((Object)listener);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testBasic() {
        this.activationCount = 0;
        this.passivationCount = 0;
        this.cache.put("/org/jboss/3", (Object)"/org/jboss/3", (Object)"/org/jboss/3");
        System.out.println(this.cache.toString());
        TestingUtil.sleepThread(2100L);
        System.out.println(this.cache.toString());
        assert (!this.cache.exists("/org/jboss/3") || !this.cache.getNode("/org/jboss/3").getKeys().contains("/org/jboss/3")) : "Should have been evicted!!";
        Object val = this.cache.get("/org/jboss/3", (Object)"/org/jboss/3");
        AssertJUnit.assertNotNull((String)"DataNode should not be empty ", (Object)val);
        AssertJUnit.assertEquals((String)"activation count:", (int)1, (int)this.activationCount);
        AssertJUnit.assertEquals((String)"passivation count:", (int)1, (int)this.passivationCount);
    }

    public void testDualPassivation() throws Exception {
        Fqn fqn = Fqn.fromString((String)"/org/jboss/3");
        this.cache.put(fqn, (Object)"key", (Object)"value");
        this.cache.evict(fqn);
        this.cache.evict(fqn);
        AssertJUnit.assertEquals((String)"Proper value after 2 passivations", (Object)"value", (Object)this.cache.get(fqn, (Object)"key"));
    }

    public void testIntermingledPassivation() throws Exception {
        Fqn fqn = Fqn.fromString((String)"/org/jboss/3");
        this.cache.put(fqn, (Object)"key1", (Object)"value");
        this.cache.evict(fqn);
        this.cache.put(fqn, (Object)"key2", (Object)"value");
        this.cache.evict(fqn);
        AssertJUnit.assertEquals((String)"Proper value after 2 passivations", (Object)"value", (Object)this.cache.get(fqn, (Object)"key1"));
    }

    private void log(String msg) {
        System.out.println("-- " + msg);
    }

    @CacheListener
    public class TestCacheListener {
        @NodeActivated
        @NodePassivated
        public void callback(NodeEvent ne) {
            if (ne.isPre()) {
                return;
            }
            if (!ne.getFqn().isChildOrEquals(Fqn.fromString((String)"/org/jboss/3"))) {
                return;
            }
            BasicPassivationTest.this.log("got event " + ne);
            if (ne.getType() == Event.Type.NODE_ACTIVATED) {
                ++BasicPassivationTest.this.activationCount;
            } else if (ne.getType() == Event.Type.NODE_PASSIVATED) {
                ++BasicPassivationTest.this.passivationCount;
            }
        }
    }
}

