/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.LocalDelegatingCacheLoaderConfig;
import org.jboss.cache.passivation.PassivationTestsBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class PassivationToLocalDelegatingCacheLoaderTest
extends PassivationTestsBase {
    ThreadLocal<CacheSPI> delegating_cacheTL = new ThreadLocal();

    protected void configureCache() throws Exception {
        CacheSPI delegating_cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        delegating_cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        delegating_cache.create();
        delegating_cache.start();
        this.delegating_cacheTL.set(delegating_cache);
        LocalDelegatingCacheLoaderConfig cfg = new LocalDelegatingCacheLoaderConfig();
        cfg.setDelegate((Cache)delegating_cache);
        cfg.setAsync(false);
        cfg.setFetchPersistentState(false);
        CacheLoaderConfig cacheLoaderConfig = new CacheLoaderConfig();
        cacheLoaderConfig.addIndividualCacheLoaderConfig((CacheLoaderConfig.IndividualCacheLoaderConfig)cfg);
        cacheLoaderConfig.setPassivation(true);
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        cache.getConfiguration().setCacheLoaderConfig(cacheLoaderConfig);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        super.tearDown();
        CacheSPI delegating_cache = this.delegating_cacheTL.get();
        this.delegating_cacheTL.set(null);
        TestingUtil.killCaches(new Cache[]{delegating_cache});
        delegating_cache = null;
    }

    public void testLoadAndStore() throws Exception {
    }
}

