/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import java.util.HashSet;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.Region;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.DummySharedInMemoryCacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ReplAndStateTransferWithPassivationTest
extends AbstractCacheLoaderTestBase {
    public void testStateTransferOfPassivatedState() throws Exception {
        this.doTest(Configuration.NodeLockingScheme.MVCC, false);
    }

    public void testStateTransferOfPassivatedStatePessimistic() throws Exception {
        this.doTest(Configuration.NodeLockingScheme.PESSIMISTIC, false);
    }

    public void testStateTransferOfPassivatedPartialState() throws Exception {
        this.doPartialStateTransferTest(Configuration.NodeLockingScheme.MVCC);
    }

    public void testStateTransferOfPassivatedPartialStatePessimistic() throws Exception {
        this.doPartialStateTransferTest(Configuration.NodeLockingScheme.PESSIMISTIC);
    }

    public void testStateTransferOfPassivatedPartialStateBR() throws Exception {
        this.doTest(Configuration.NodeLockingScheme.MVCC, true);
    }

    public void testStateTransferOfPassivatedPartialStateBRPessimistic() throws Exception {
        this.doTest(Configuration.NodeLockingScheme.PESSIMISTIC, true);
    }

    public void testStateTransferOfPassivatedPartialStateBRForceRemote() throws Exception {
        this.doTest(Configuration.NodeLockingScheme.MVCC, false);
    }

    public void testStateTransferOfPassivatedPartialStateBRPessimisticForceRemote() throws Exception {
        this.doTest(Configuration.NodeLockingScheme.PESSIMISTIC, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPartialStateTransferTest(Configuration.NodeLockingScheme nls) throws Exception {
        CacheSPI cache1 = null;
        CacheSPI cache2 = null;
        String subtree = "/SESSIONS";
        try {
            HashSet<String> nameSet = new HashSet<String>();
            nameSet.add("a");
            nameSet.add("b");
            nameSet.add("c");
            cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(this.buildConf(nls, "cache1", true, false, true));
            cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(this.buildConf(nls, "cache2", true, false, true));
            Region r1 = cache1.getRegionManager().getRegion(subtree, true);
            Region r2 = cache2.getRegionManager().getRegion(subtree, true);
            r1.registerContextClassLoader(this.getClass().getClassLoader());
            r2.registerContextClassLoader(this.getClass().getClassLoader());
            r1.activate();
            cache1.put(subtree + "/a", (Object)"k", (Object)"v");
            cache1.put(subtree + "/b", (Object)"k", (Object)"v");
            cache1.put(subtree + "/c", (Object)"k", (Object)"v");
            NodeSPI root1 = cache1.getNode(subtree);
            assert (((Object)root1.getChildrenNames()).equals(nameSet)) : "Expecting " + nameSet + " but got " + root1.getChildrenNames();
            cache1.evict(Fqn.fromString((String)"/a"));
            r2.activate();
            NodeSPI root2 = cache1.getNode(subtree);
            assert (((Object)root2.getChildrenNames()).equals(nameSet)) : "Expecting " + nameSet + " but got " + root2.getChildrenNames();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            TestingUtil.killCaches(new Cache[]{cache1, cache2});
            throw throwable;
        }
        TestingUtil.killCaches(new Cache[]{cache1, cache2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(Configuration.NodeLockingScheme nls, boolean useBR) throws Exception {
        Cache cache1 = null;
        Cache cache2 = null;
        Fqn fqn = useBR ? Fqn.fromString((String)"/someFqn") : Fqn.ROOT;
        Fqn A = Fqn.fromRelativeElements((Fqn)fqn, (Object[])new String[]{"a"});
        Fqn B = Fqn.fromRelativeElements((Fqn)fqn, (Object[])new String[]{"b"});
        Fqn C = Fqn.fromRelativeElements((Fqn)fqn, (Object[])new String[]{"c"});
        try {
            HashSet<Object> nameSet = new HashSet<Object>();
            nameSet.add(A.getLastElement());
            nameSet.add(B.getLastElement());
            nameSet.add(C.getLastElement());
            cache1 = new UnitTestCacheFactory().createCache(this.buildConf(nls, "cache1", false, useBR, true));
            cache1.put(A, (Object)"k", (Object)"v");
            cache1.put(B, (Object)"k", (Object)"v");
            cache1.put(C, (Object)"k", (Object)"v");
            assert (((Object)cache1.getNode(fqn).getChildrenNames()).equals(nameSet));
            cache1.evict(A);
            cache2 = new UnitTestCacheFactory().createCache(this.buildConf(nls, "cache2", false, useBR, true));
            if (useBR) {
                HashSet backupNameSet = new HashSet(nameSet);
                backupNameSet.remove("_BUDDY_BACKUP_");
                cache2.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
                Node backupNode = cache2.getNode(fqn);
                assert (((Object)backupNode.getChildrenNames()).equals(backupNameSet)) : "Expecting " + backupNameSet + " but got " + backupNode.getChildrenNames();
            } else assert (((Object)cache2.getRoot().getChildrenNames()).equals(nameSet)) : "Expecting " + nameSet + " but got " + cache2.getRoot().getChildrenNames();
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            TestingUtil.killCaches(cache1, cache2);
            throw throwable;
        }
        TestingUtil.killCaches(cache1, cache2);
    }

    private Configuration buildConf(Configuration.NodeLockingScheme nls, String n, boolean regionbased, boolean useBR, boolean brSearchSubtrees) throws Exception {
        Configuration c = new Configuration();
        if (regionbased) {
            c.setUseRegionBasedMarshalling(true);
            c.setInactiveOnStartup(true);
        }
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setNodeLockingScheme(nls);
        CacheLoaderConfig clc = this.getSingleCacheLoaderConfig("", DummySharedInMemoryCacheLoader.class.getName(), "bin=" + n, false, true, false);
        clc.setPassivation(true);
        c.setCacheLoaderConfig(clc);
        if (useBR) {
            BuddyReplicationConfig brc = new BuddyReplicationConfig();
            brc.setEnabled(true);
            brc.setAutoDataGravitation(false);
            brc.setDataGravitationSearchBackupTrees(brSearchSubtrees);
            brc.setDataGravitationRemoveOnFind(true);
            c.setBuddyReplicationConfig(brc);
        }
        return c;
    }
}

