/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.profiling;

import java.io.NotSerializableException;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.cache.RPCManager;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.marshall.CommandAwareRpcDispatcher;
import org.jboss.cache.profiling.ProfileTest;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.reflect.ReflectionUtil;
import org.jgroups.Address;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.RspList;
import org.testng.annotations.Test;

public class MockAsyncReplTest
extends ProfileTest {
    @Test(enabled=true)
    public void testReplAsync() throws Exception {
        super.testReplAsync();
    }

    protected void startup() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting cache");
        this.cache.start();
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(this.cache);
        RPCManager rpcManager = (RPCManager)cr.getComponent(RPCManager.class);
        RpcDispatcher d = (RpcDispatcher)TestingUtil.extractField(rpcManager, "rpcDispatcher");
        d.stop();
        NoopDispatcher replacement = new NoopDispatcher();
        replacement.setRequestMarshaller(d.getRequestMarshaller());
        replacement.setResponseMarshaller(d.getResponseMarshaller());
        ReflectionUtil.setValue((Object)rpcManager, (String)"rpcDispatcher", (Object)((Object)replacement));
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Started cache.  " + this.printDuration(duration)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NoopDispatcher
    extends CommandAwareRpcDispatcher {
        AtomicInteger ai = new AtomicInteger();
        RpcDispatcher.Marshaller m;
        RpcDispatcher.Marshaller2 m2;

        public RspList invokeRemoteCommands(Vector<Address> dests, ReplicableCommand command, int mode, long timeout, boolean anycasting, boolean oob, RspFilter filter) throws NotSerializableException {
            int i = this.ai.incrementAndGet();
            if (i % 1000 == 0) {
                this.log.warn((Object)("Dispatching operation #" + i));
            }
            return null;
        }
    }
}

