/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.replicated;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class ExceptionTest {
    private Cache cache1;
    private Cache cache2;
    private Fqn fqn = Fqn.fromString((String)"/a");

    @BeforeMethod
    public void setUp() {
        Configuration c = new Configuration();
        c.setSyncCommitPhase(true);
        c.setSyncRollbackPhase(true);
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache1 = new UnitTestCacheFactory().createCache(c, false);
        c = new Configuration();
        c.setSyncCommitPhase(true);
        c.setSyncRollbackPhase(true);
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache2 = new UnitTestCacheFactory().createCache(c, false);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.cache1, this.cache2);
        this.cache1 = null;
        this.cache2 = null;
    }

    @Test(groups={"functional"}, expectedExceptions={TimeoutException.class})
    public void testSyncReplTimeout() {
        this.cache1.getConfiguration().setSyncReplTimeout(1L);
        this.cache2.getConfiguration().setSyncReplTimeout(1L);
        String s = UnitTestCacheConfigurationFactory.getClusterConfigFromFile(this.cache1.getConfiguration().getDefaultClusterConfig());
        String newCfg = UnitTestCacheConfigurationFactory.injectDelay(s, 100, 100);
        this.cache1.getConfiguration().setClusterConfig(newCfg);
        this.cache2.getConfiguration().setClusterConfig(newCfg);
        this.cache1.start();
        this.cache2.start();
        TestingUtil.blockUntilViewsReceived(60000L, this.cache1, this.cache2);
        this.cache1.put(this.fqn, (Object)"k", (Object)"v");
    }

    @Test(groups={"functional"}, expectedExceptions={TimeoutException.class})
    public void testLockAcquisitionTimeout() throws Exception {
        this.cache2.getConfiguration().setLockAcquisitionTimeout(1L);
        this.cache1.start();
        this.cache2.start();
        TestingUtil.blockUntilViewsReceived(10000L, this.cache1, this.cache2);
        TransactionManager tm = this.cache2.getConfiguration().getRuntimeConfig().getTransactionManager();
        tm.begin();
        this.cache2.put(this.fqn, (Object)"block", (Object)"block");
        Transaction t = tm.suspend();
        this.cache1.put(this.fqn, (Object)"k", (Object)"v");
    }
}

