/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.replicated;

import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.invocation.CacheInvocationDelegate;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class SyncReplTest {
    private ThreadLocal<Cache<Object, Object>[]> cachesTL = new ThreadLocal();

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        System.out.println("*** In setUp()");
        Cache[] caches = new Cache[]{new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC)), new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC))};
        this.cachesTL.set(caches);
        TestingUtil.blockUntilViewsReceived(caches, 5000L);
        System.out.println("*** Finished setUp()");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        Cache<Object, Object>[] caches = this.cachesTL.get();
        if (caches != null) {
            TestingUtil.killCaches(caches);
        }
        this.cachesTL.set(null);
    }

    public void testBasicOperation() {
        Cache<Object, Object>[] caches = this.cachesTL.get();
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        this.assertInvocationContextInitState();
        Fqn f = Fqn.fromString((String)"/test/data");
        String k = "key";
        String v = "value";
        AssertJUnit.assertNull((String)"Should be null", (Object)caches[0].getRoot().getChild(f));
        AssertJUnit.assertNull((String)"Should be null", (Object)caches[1].getRoot().getChild(f));
        Node node = caches[0].getRoot().addChild(f);
        assert (((NodeSPI)node).getCache() instanceof CacheInvocationDelegate);
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)node);
        node.put((Object)k, (Object)v);
        AssertJUnit.assertEquals((Object)v, (Object)node.get((Object)k));
        AssertJUnit.assertEquals((Object)v, (Object)caches[0].get(f, (Object)k));
        AssertJUnit.assertEquals((String)"Should have replicated", (Object)v, (Object)caches[1].get(f, (Object)k));
    }

    public void testSyncRepl() {
        Cache<Object, Object>[] caches = this.cachesTL.get();
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        this.assertInvocationContextInitState();
        Fqn fqn = Fqn.fromString((String)"/JSESSIONID/1010.10.5:3000/1234567890/1");
        caches[0].getConfiguration().setSyncCommitPhase(true);
        caches[1].getConfiguration().setSyncCommitPhase(true);
        caches[0].put(fqn, (Object)"age", (Object)38);
        AssertJUnit.assertEquals((String)"Value should be set", (Object)38, (Object)caches[0].get(fqn, (Object)"age"));
        AssertJUnit.assertEquals((String)"Value should have replicated", (Object)38, (Object)caches[1].get(fqn, (Object)"age"));
    }

    public void testNodeConvenienceNodeRemoval() {
        Cache<Object, Object>[] caches = this.cachesTL.get();
        Fqn fqn = Fqn.fromString((String)"/test/fqn");
        caches[0].getRoot().addChild(fqn);
        AssertJUnit.assertTrue((boolean)caches[0].getRoot().hasChild(fqn));
        AssertJUnit.assertTrue((boolean)caches[1].getRoot().hasChild(fqn));
        AssertJUnit.assertEquals((boolean)true, (boolean)caches[0].removeNode(fqn));
        AssertJUnit.assertFalse((boolean)caches[0].getRoot().hasChild(fqn));
        AssertJUnit.assertFalse((boolean)caches[1].getRoot().hasChild(fqn));
        AssertJUnit.assertEquals((boolean)false, (boolean)caches[0].removeNode(fqn));
        Fqn child = Fqn.fromString((String)"/test/fqn/child");
        caches[0].getRoot().addChild(child);
        AssertJUnit.assertTrue((boolean)caches[0].getRoot().hasChild(child));
        AssertJUnit.assertTrue((boolean)caches[1].getRoot().hasChild(child));
        AssertJUnit.assertEquals((boolean)true, (boolean)caches[0].removeNode(fqn));
        AssertJUnit.assertFalse((boolean)caches[0].getRoot().hasChild(fqn));
        AssertJUnit.assertFalse((boolean)caches[1].getRoot().hasChild(fqn));
        AssertJUnit.assertEquals((boolean)false, (boolean)caches[0].removeNode(fqn));
    }

    private void assertClusterSize(String message, int size) {
        Cache<Object, Object>[] caches;
        for (Cache<Object, Object> c : caches = this.cachesTL.get()) {
            this.assertClusterSize(message, size, c);
        }
    }

    private void assertClusterSize(String message, int size, Cache c) {
        AssertJUnit.assertEquals((String)message, (int)size, (int)c.getMembers().size());
    }

    private void assertInvocationContextInitState() {
        Cache<Object, Object>[] caches;
        for (Cache<Object, Object> c : caches = this.cachesTL.get()) {
            this.assertInvocationContextInitState(c);
        }
    }

    private void assertInvocationContextInitState(Cache c) {
        InvocationContext ctx = c.getInvocationContext();
        InvocationContext control = ctx.copy();
        control.reset();
        AssertJUnit.assertEquals((String)"Should be equal", (Object)control, (Object)ctx);
    }
}

