/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, enabled=false)
public class PersistingTransientStateTest {
    protected Configuration.NodeLockingScheme nls = Configuration.NodeLockingScheme.PESSIMISTIC;
    protected Fqn fqn = Fqn.fromString((String)"/a/b/c");
    protected String k = "k";
    protected String v = "v";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistentStateTransfer() throws Exception {
        Cache c1 = null;
        Cache c2 = null;
        try {
            UnitTestCacheFactory cf = new UnitTestCacheFactory();
            Configuration cfg = new Configuration();
            cfg.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
            cfg.setCacheMode(Configuration.CacheMode.REPL_SYNC);
            cfg.setFetchInMemoryState(true);
            CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
            iclc.setClassName(DummyInMemoryCacheLoader.class.getName());
            iclc.setFetchPersistentState(false);
            CacheLoaderConfig clc = new CacheLoaderConfig();
            clc.addIndividualCacheLoaderConfig(iclc);
            cfg.setCacheLoaderConfig(clc);
            cfg.setNodeLockingScheme(this.nls);
            c1 = cf.createCache(cfg.clone());
            c1.put(this.fqn, (Object)this.k, (Object)this.v);
            assert (((String)c1.get(this.fqn, (Object)this.k)).equals(this.v));
            assert (this.getLoader(c1).get(this.fqn).get(this.k).equals(this.v));
            c2 = cf.createCache(cfg.clone());
            assert (((String)c2.get(this.fqn, (Object)this.k)).equals(this.v));
            assert (this.getLoader(c2).get(this.fqn).get(this.k).equals(this.v));
        }
        catch (Throwable throwable) {
            TestingUtil.killCaches(c1, c2);
            throw throwable;
        }
        TestingUtil.killCaches(c1, c2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistentStateTransferShared() throws Exception {
        Cache c1 = null;
        Cache c2 = null;
        try {
            UnitTestCacheFactory cf = new UnitTestCacheFactory();
            Configuration cfg = new Configuration();
            cfg.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
            cfg.setCacheMode(Configuration.CacheMode.REPL_SYNC);
            cfg.setFetchInMemoryState(true);
            CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
            iclc.setClassName(DummyInMemoryCacheLoader.class.getName());
            iclc.setFetchPersistentState(false);
            CacheLoaderConfig clc = new CacheLoaderConfig();
            clc.addIndividualCacheLoaderConfig(iclc);
            clc.setShared(true);
            cfg.setCacheLoaderConfig(clc);
            cfg.setNodeLockingScheme(this.nls);
            c1 = cf.createCache(cfg.clone());
            c1.put(this.fqn, (Object)this.k, (Object)this.v);
            assert (((String)c1.get(this.fqn, (Object)this.k)).equals(this.v));
            assert (this.getLoader(c1).get(this.fqn).get(this.k).equals(this.v));
            c2 = cf.createCache(cfg.clone());
            assert (((String)c2.get(this.fqn, (Object)this.k)).equals(this.v));
            assert (this.getLoader(c2).get(this.fqn) == null);
        }
        catch (Throwable throwable) {
            TestingUtil.killCaches(c1, c2);
            throw throwable;
        }
        TestingUtil.killCaches(c1, c2);
    }

    protected CacheLoader getLoader(Cache<?, ?> c) {
        return ((CacheSPI)c).getCacheLoaderManager().getCacheLoader();
    }
}

