/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, sequential=true)
public class ReplicatedTransactionDeadlockTest {
    private static final int NUM_WORKERS = 2;
    private static final int NUM_RUNS = 100;
    private static final long LOCK_ACQUISITION_TIMEOUT = 10000L;
    private static volatile Exception exception = null;
    private CacheSPI<Boolean, Boolean> srcCache = null;
    private CacheSPI dstCache = null;
    private Log log = LogFactory.getLog(ReplicatedTransactionDeadlockTest.class);

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        exception = null;
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        c.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setSyncCommitPhase(true);
        c.setLockAcquisitionTimeout(10000L);
        this.srcCache = (CacheSPI)instance.createCache(c, false);
        this.srcCache.create();
        this.srcCache.start();
        c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setSyncCommitPhase(true);
        c.setLockAcquisitionTimeout(10000L);
        this.dstCache = (CacheSPI)instance.createCache(c, false);
        this.dstCache.create();
        this.dstCache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.srcCache, this.dstCache});
        this.srcCache = null;
        this.dstCache = null;
        TestingUtil.killTransaction(TransactionSetup.getManager());
    }

    public void testConcurrentReplicatedTransaction() throws Exception {
        this.performTest();
    }

    private void performTest() throws Exception {
        for (int i = 0; i < 100; ++i) {
            if (exception != null) {
                AssertJUnit.fail((String)("Due to an exception: " + exception));
            }
            Worker[] t = new Worker[2];
            for (int j = 0; j < t.length; ++j) {
                t[j] = new Worker("worker " + i + ":" + j);
                t[j].start();
            }
            for (Worker aT : t) {
                aT.join();
            }
        }
    }

    private UserTransaction getTransaction() {
        return TransactionSetup.getUserTransaction();
    }

    private class Worker
    extends Thread {
        public Worker(String name) {
            super(name);
        }

        public void run() {
            try {
                UserTransaction tx = ReplicatedTransactionDeadlockTest.this.getTransaction();
                ReplicatedTransactionDeadlockTest.this.log.warn((Object)"begin");
                tx.begin();
                ReplicatedTransactionDeadlockTest.this.log.warn((Object)"put");
                ReplicatedTransactionDeadlockTest.this.srcCache.put("/Node", (Object)Boolean.FALSE, (Object)Boolean.TRUE);
                ReplicatedTransactionDeadlockTest.this.log.warn((Object)"commit");
                tx.commit();
                ReplicatedTransactionDeadlockTest.this.log.warn((Object)"leave");
            }
            catch (Exception e) {
                ReplicatedTransactionDeadlockTest.this.log.error((Object)("caught exception " + e), (Throwable)e);
                exception = e;
            }
        }
    }
}

