/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.internals;

import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.cluster.ReplicationQueue;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.invocation.CacheInvocationDelegate;
import org.jboss.cache.util.TestingUtil;

public class ReplicationQueueNotifier {
    private CacheInvocationDelegate cache;
    private Object replicated = new Object();

    public ReplicationQueueNotifier(Cache cache) {
        this.cache = (CacheInvocationDelegate)cache;
        if (!this.isAsync(cache)) {
            throw new RuntimeException("No  queue events expected on a sync cache!");
        }
        this.replaceInternal();
    }

    private boolean isAsync(Cache cache) {
        return cache.getConfiguration().getCacheMode() == Configuration.CacheMode.INVALIDATION_ASYNC || cache.getConfiguration().getCacheMode() == Configuration.CacheMode.REPL_ASYNC;
    }

    private void replaceInternal() {
        ComponentRegistry componentRegistry = TestingUtil.extractComponentRegistry((Cache)this.cache);
        InterceptorChain ic = (InterceptorChain)componentRegistry.getComponent(InterceptorChain.class);
        List commands = ic.getInterceptorsWhichExtend(BaseRpcInterceptor.class);
        for (CommandInterceptor interceptor : commands) {
            ReplicationQueue original = (ReplicationQueue)TestingUtil.extractField(BaseRpcInterceptor.class, interceptor, "replicationQueue");
            TestingUtil.replaceField((Object)new ReplicationQueueDelegate(original), "replicationQueue", interceptor, BaseRpcInterceptor.class);
            this.log("replaced replicationQueue in " + interceptor.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntillAllReplicated(long timeout) {
        Object object = this.replicated;
        synchronized (object) {
            try {
                this.replicated.wait(timeout);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.log("returning from waitUntillAllReplicated call");
    }

    private void log(String str) {
        System.out.println("ReplicationQueueNotifier >>>  " + str);
    }

    private class ReplicationQueueDelegate
    extends ReplicationQueue {
        ReplicationQueue original;

        private ReplicationQueueDelegate(ReplicationQueue original) {
            this.original = original;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            ReplicationQueueNotifier.this.log("Flush invoked!");
            this.original.flush();
            Object object = ReplicationQueueNotifier.this.replicated;
            synchronized (object) {
                ReplicationQueueNotifier.this.replicated.notifyAll();
            }
        }
    }
}

