/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RPCManager;
import org.jboss.cache.Region;
import org.jboss.cache.RegionEmptyException;
import org.jboss.cache.RegionManager;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.buddyreplication.BuddyLocator;
import org.jboss.cache.buddyreplication.BuddyNotInitException;
import org.jboss.cache.buddyreplication.Fqn2BuddyFqnVisitor;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.remote.AnnounceBuddyPoolNameCommand;
import org.jboss.cache.commands.remote.AssignToBuddyGroupCommand;
import org.jboss.cache.commands.remote.RemoveFromBuddyGroupCommand;
import org.jboss.cache.commands.remote.ReplicateCommand;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.io.ExposedByteArrayOutputStream;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.cache.util.concurrent.ConcurrentHashSet;
import org.jboss.cache.util.reflect.ReflectionUtil;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.View;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyManager {
    private final Log log = LogFactory.getLog(BuddyManager.class);
    private boolean trace;
    BuddyReplicationConfig config;
    BuddyLocator buddyLocator;
    Fqn2BuddyFqnVisitor fqnVisitorFqn2;
    CommandsFactory commandsFactory;
    private CacheSPI<?, ?> cache;
    private Configuration configuration;
    private RegionManager regionManager;
    private Notifier notifier;
    private StateTransferManager stateTransferManager;
    private RPCManager rpcManager;
    BuddyGroup buddyGroup;
    final Map<Address, String> buddyPool = new ConcurrentHashMap<Address, String>();
    final Set<Address> nullBuddyPool = new ConcurrentHashSet<Address>();
    final Map<Address, BuddyGroup> buddyGroupsIParticipateIn = new ConcurrentHashMap<Address, BuddyGroup>();
    private final BlockingQueue<MembershipChange> queue = new LinkedBlockingQueue<MembershipChange>();
    private final AsyncViewChangeHandlerThread asyncViewChangeHandler = new AsyncViewChangeHandlerThread();
    public static final String BUDDY_BACKUP_SUBTREE = "_BUDDY_BACKUP_";
    public static final Fqn BUDDY_BACKUP_SUBTREE_FQN = Fqn.fromString("_BUDDY_BACKUP_");
    private static final int UNINIT_BUDDIES_RETRIES = 5;
    private static final long[] UNINIT_BUDDIES_RETRY_NAPTIME = new long[]{500L, 1000L, 1500L, 2000L, 2500L};
    private final Object poolInfoNotifierLock = new Object();
    private final CountDownLatch initialisationLatch = new CountDownLatch(1);
    private static final MembershipChange STOP_NOTIFIER = new MembershipChange(null, null);
    private ViewChangeListener viewChangeListener;
    private boolean receivedBuddyInfo;
    private DataContainer dataContainer;
    private BuddyFqnTransformer buddyFqnTransformer;

    public BuddyManager() {
    }

    public BuddyManager(BuddyReplicationConfig config) {
        this.setupInternals(config);
    }

    private void setupInternals(BuddyReplicationConfig config) {
        this.config = config;
        this.trace = this.log.isTraceEnabled();
        BuddyReplicationConfig.BuddyLocatorConfig blc = config.getBuddyLocatorConfig();
        try {
            this.buddyLocator = blc == null ? this.createDefaultBuddyLocator() : this.createBuddyLocator(blc);
        }
        catch (Exception e) {
            this.log.warn((Object)"Caught exception instantiating buddy locator", (Throwable)e);
            this.log.error((Object)("Unable to instantiate specified buddyLocatorClass [" + blc + "].  Using default buddyLocator [" + NextMemberBuddyLocator.class.getName() + "] instead, with default properties."));
            this.buddyLocator = this.createDefaultBuddyLocator();
        }
        if (blc != this.buddyLocator.getConfig()) {
            config.setBuddyLocatorConfig(this.buddyLocator.getConfig());
        }
    }

    @Inject
    public void injectDependencies(CacheSPI cache, Configuration configuration, RegionManager regionManager, StateTransferManager stateTransferManager, RPCManager rpcManager, Notifier notifier, CommandsFactory factory, DataContainer dataContainer, BuddyFqnTransformer transformer) {
        this.cache = cache;
        this.configuration = configuration;
        this.regionManager = regionManager;
        this.stateTransferManager = stateTransferManager;
        this.rpcManager = rpcManager;
        this.notifier = notifier;
        this.commandsFactory = factory;
        this.dataContainer = dataContainer;
        this.buddyFqnTransformer = transformer;
    }

    public BuddyReplicationConfig getConfig() {
        return this.config;
    }

    protected BuddyLocator createBuddyLocator(BuddyReplicationConfig.BuddyLocatorConfig config) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        BuddyLocator bl = (BuddyLocator)Class.forName(config.getBuddyLocatorClass()).newInstance();
        bl.init(config);
        return bl;
    }

    protected BuddyLocator createDefaultBuddyLocator() {
        NextMemberBuddyLocator bl = new NextMemberBuddyLocator();
        bl.init(null);
        return bl;
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    public String getBuddyPoolName() {
        return this.config.getBuddyPoolName();
    }

    @Stop(priority=5)
    public void stop() {
        if (this.isEnabled()) {
            this.log.debug((Object)"Stopping BuddyManager");
            if (this.cache != null) {
                this.cache.removeCacheListener(this.viewChangeListener);
            }
            try {
                this.queue.clear();
                this.queue.put(STOP_NOTIFIER);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Start(priority=20)
    public void init() throws CacheException {
        this.setupInternals(this.configuration.getBuddyReplicationConfig());
        if (this.isEnabled()) {
            this.log.debug((Object)"Starting BuddyManager");
            this.dataContainer.registerInternalFqn(BUDDY_BACKUP_SUBTREE_FQN);
            this.buddyGroup = new BuddyGroup();
            this.buddyGroup.setDataOwner(this.cache.getLocalAddress());
            Address localAddress = this.rpcManager.getLocalAddress();
            if (localAddress == null) {
                if (this.configuration.getCacheMode() == Configuration.CacheMode.LOCAL) {
                    this.log.warn((Object)"Buddy replication is enabled but cache mode is LOCAL - not starting BuddyManager!");
                    ReflectionUtil.setValue(this.config, "accessible", true);
                    this.config.setEnabled(false);
                    return;
                }
                throw new CacheException("Unable to initialize BuddyManager - the RPCManager has not connected to the cluster and local Address is null!");
            }
            this.buddyGroup.setGroupName(this.buddyFqnTransformer.getGroupNameFromAddress(localAddress));
            if (this.config.getBuddyPoolName() != null) {
                this.buddyPool.put(this.buddyGroup.getDataOwner(), this.config.getBuddyPoolName());
            }
            this.broadcastBuddyPoolMembership();
            this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
            if (!this.cache.exists(BUDDY_BACKUP_SUBTREE_FQN)) {
                this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
                this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                this.cache.put(BUDDY_BACKUP_SUBTREE_FQN, Collections.emptyMap());
            }
            this.initialisationLatch.countDown();
            this.viewChangeListener = new ViewChangeListener();
            this.cache.addCacheListener(this.viewChangeListener);
            this.reassignBuddies(this.cache.getMembers());
            this.queue.clear();
            this.asyncViewChangeHandler.start();
            this.initFqnTransformer(this.buddyGroup.getGroupName(), this.commandsFactory);
        }
    }

    void initFqnTransformer(String groupName, CommandsFactory commandsFactory) {
        this.fqnVisitorFqn2 = new Fqn2BuddyFqnVisitor(groupName, commandsFactory);
        this.fqnVisitorFqn2.setBuddyFqnTransformer(this.buddyFqnTransformer);
    }

    public boolean isAutoDataGravitation() {
        return this.config.isAutoDataGravitation();
    }

    public boolean isDataGravitationRemoveOnFind() {
        return this.config.isDataGravitationRemoveOnFind();
    }

    public boolean isDataGravitationSearchBackupTrees() {
        return this.config.isDataGravitationSearchBackupTrees();
    }

    public int getBuddyCommunicationTimeout() {
        return this.config.getBuddyCommunicationTimeout();
    }

    private synchronized void enqueueViewChange(MembershipChange mc) {
        try {
            if (this.queue.peek() != STOP_NOTIFIER) {
                this.queue.clear();
                if (this.trace) {
                    this.log.trace((Object)("Enqueueing " + mc + " for async processing"));
                }
                this.queue.put(mc);
            }
        }
        catch (InterruptedException e) {
            this.log.warn((Object)"Caught interrupted exception trying to enqueue a view change event", (Throwable)e);
        }
    }

    private void reassignBuddies(List<Address> members) throws CacheException {
        boolean buddyGroupMutated;
        List<Address> newBuddies;
        List<Address> unreachableBuddies;
        ArrayList<Address> membership = new ArrayList<Address>(members);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Data owner address " + this.cache.getLocalAddress()));
            this.log.debug((Object)("Entering updateGroup.  Current group: " + this.buddyGroup + ".  Current View membership: " + membership));
        }
        if (!(unreachableBuddies = this.checkBuddyStatus(newBuddies = this.buddyLocator.locateBuddies(this.buddyPool, membership, this.buddyGroup.getDataOwner()))).isEmpty()) {
            membership.removeAll(unreachableBuddies);
            newBuddies = this.buddyLocator.locateBuddies(this.buddyPool, membership, this.buddyGroup.getDataOwner());
        }
        ArrayList<Address> uninitialisedBuddies = new ArrayList<Address>();
        List<Address> originalBuddies = this.buddyGroup.getBuddies();
        for (Address newBuddy : newBuddies) {
            if (originalBuddies.contains(newBuddy)) continue;
            uninitialisedBuddies.add(newBuddy);
        }
        ArrayList<Address> obsoleteBuddies = new ArrayList<Address>();
        for (Address origBuddy : originalBuddies) {
            if (newBuddies.contains(origBuddy)) continue;
            obsoleteBuddies.add(origBuddy);
        }
        boolean bl = buddyGroupMutated = !obsoleteBuddies.isEmpty() || !uninitialisedBuddies.isEmpty();
        if (!obsoleteBuddies.isEmpty()) {
            this.removeFromGroup(obsoleteBuddies);
        } else {
            this.log.trace((Object)"No obsolete buddies found, nothing to announce.");
        }
        if (!uninitialisedBuddies.isEmpty()) {
            this.addBuddies(newBuddies);
        } else {
            this.log.trace((Object)"No uninitialized buddies found, nothing to announce.");
        }
        if (buddyGroupMutated) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Buddy group members have changed. New buddy group: " + this.buddyGroup));
            }
            this.configuration.getRuntimeConfig().setBuddyGroup(this.buddyGroup);
            this.notifier.notifyBuddyGroupChange(this.buddyGroup, false);
        } else {
            this.log.debug((Object)"Nothing has changed; new buddy list is identical to the old one.");
        }
    }

    private List<Address> checkBuddyStatus(List<Address> members) {
        Channel ch = this.configuration.getRuntimeConfig().getChannel();
        View currentView = ch.getView();
        LinkedList<Address> deadBuddies = new LinkedList<Address>();
        for (Address a : members) {
            if (currentView.containsMember(a)) continue;
            deadBuddies.add(a);
        }
        return deadBuddies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePoolNameBroadcast(Address address, String poolName) {
        Object object;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("BuddyManager@" + Integer.toHexString(this.hashCode()) + ": received announcement that cache instance " + address + " is in buddy pool " + poolName));
        }
        if (poolName != null) {
            this.buddyPool.put(address, poolName);
        } else {
            object = this.nullBuddyPool;
            synchronized (object) {
                if (!this.nullBuddyPool.contains(address)) {
                    this.nullBuddyPool.add(address);
                }
            }
        }
        object = this.poolInfoNotifierLock;
        synchronized (object) {
            this.log.trace((Object)"Notifying any waiting view change threads that we have received buddy pool info.");
            this.receivedBuddyInfo = true;
            this.poolInfoNotifierLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemoveFromBuddyGroup(String groupName) throws BuddyNotInitException {
        try {
            if (!this.initialisationLatch.await(0L, TimeUnit.NANOSECONDS)) {
                throw new BuddyNotInitException("Not yet initialised");
            }
        }
        catch (InterruptedException e) {
            this.log.debug((Object)"Caught InterruptedException", (Throwable)e);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Removing self from buddy group " + groupName));
        }
        for (Map.Entry<Address, String> me : this.buddyPool.entrySet()) {
            if (!me.getValue().equals(groupName)) continue;
            this.buddyGroupsIParticipateIn.remove(me.getKey());
            break;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Removing backup data for group " + groupName));
        }
        try {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            this.cache.removeNode(Fqn.fromRelativeElements(BUDDY_BACKUP_SUBTREE_FQN, groupName));
        }
        catch (CacheException e) {
            this.log.error((Object)("Unable to remove backup data for group " + groupName), (Throwable)e);
        }
        finally {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAssignToBuddyGroup(BuddyGroup newGroup, Map<Fqn, byte[]> state) throws Exception {
        try {
            if (!this.initialisationLatch.await(0L, TimeUnit.NANOSECONDS)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Local buddy mamanger not initialized, rejecting assign call " + newGroup));
                }
                throw new BuddyNotInitException("Not yet initialised");
            }
        }
        catch (InterruptedException e) {
            this.log.debug((Object)"Caught InterruptedException", (Throwable)e);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Assigning self to buddy group " + newGroup));
        }
        this.buddyGroupsIParticipateIn.put(newGroup.getDataOwner(), newGroup);
        Fqn integrationBase = this.buddyFqnTransformer.getBackupRoot(newGroup.getDataOwner());
        if (state.isEmpty()) {
            if (this.configuredToFetchState()) {
                this.log.info((Object)"Data owner has no state to set, even though buddy is configured to accept state.  Assuming there is no data on the data owner.");
            }
            Option o = this.cache.getInvocationContext().getOptionOverrides();
            o.setSkipCacheStatusCheck(true);
            o = this.cache.getInvocationContext().getOptionOverrides();
            o.setCacheModeLocal(true);
            o.setSkipCacheStatusCheck(true);
            this.cache.put(Fqn.fromElements(BUDDY_BACKUP_SUBTREE, newGroup.getGroupName()), Collections.emptyMap());
        } else {
            for (Map.Entry<Fqn, byte[]> entry : state.entrySet()) {
                Fqn fqn = entry.getKey();
                if (!this.regionManager.isInactive(fqn)) {
                    if (this.trace) {
                        this.log.trace((Object)("Integrating state for region " + fqn));
                    }
                    Fqn integrationRoot = Fqn.fromRelativeFqn(integrationBase, fqn);
                    byte[] stateBuffer = entry.getValue();
                    MarshalledValueInputStream in = null;
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(stateBuffer);
                        in = new MarshalledValueInputStream((InputStream)bais);
                        this.stateTransferManager.setState((ObjectInputStream)in, integrationRoot);
                        continue;
                    }
                    catch (Throwable t) {
                        if (t instanceof CacheException) {
                            this.log.debug((Object)t);
                            continue;
                        }
                        this.log.error((Object)("State for fqn " + fqn + " could not be transferred to a buddy at " + this.cache.getLocalAddress()), t);
                        continue;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        continue;
                    }
                }
                this.log.trace((Object)("Received state for region " + fqn + " but region is inactive"));
            }
        }
    }

    public List<Address> getBackupDataOwners() {
        ArrayList<Address> owners = new ArrayList<Address>();
        for (BuddyGroup group : this.buddyGroupsIParticipateIn.values()) {
            owners.add(group.getDataOwner());
        }
        return owners;
    }

    public List<Address> getBuddyAddresses() {
        return this.buddyGroup.getBuddies();
    }

    public Vector<Address> getBuddyAddressesAsVector() {
        return this.buddyGroup.getBuddiesAsVector();
    }

    public List<Address> getMembersOutsideBuddyGroup() {
        ArrayList<Address> members = new ArrayList<Address>(this.rpcManager.getMembers());
        members.remove(this.rpcManager.getLocalAddress());
        members.removeAll(this.getBuddyAddresses());
        return members;
    }

    public VisitableCommand transformFqns(VisitableCommand call) {
        try {
            VisitableCommand transformed = (VisitableCommand)call.acceptVisitor(null, this.fqnVisitorFqn2);
            if (this.trace) {
                this.log.trace((Object)("Transformed " + call + " to " + transformed));
            }
            return transformed;
        }
        catch (Throwable throwable) {
            this.log.error((Object)"error while transforming an call", throwable);
            throw new CacheException(throwable);
        }
    }

    public ReplicateCommand transformReplicateCommand(ReplicateCommand rc) {
        ReplicateCommand clone = rc.copy();
        if (rc.isSingleCommand()) {
            clone.setSingleModification(this.transformFqns((VisitableCommand)rc.getSingleModification()));
        } else {
            ArrayList<ReplicableCommand> transformed = new ArrayList<ReplicableCommand>(rc.getModifications().size());
            for (ReplicableCommand cmd : rc.getModifications()) {
                transformed.add(this.transformFqns((VisitableCommand)cmd));
            }
            clone.setModifications(transformed);
        }
        return clone;
    }

    private void removeFromGroup(List<Address> buddies) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removing obsolete buddies from buddy group [" + this.buddyGroup.getGroupName() + "].  Obsolete buddies are " + buddies));
        }
        this.buddyGroup.removeBuddies(buddies);
        RemoveFromBuddyGroupCommand command = this.commandsFactory.buildRemoveFromBuddyGroupCommand(this.buddyGroup.getGroupName());
        int attemptsLeft = 5;
        int currentAttempt = 0;
        while (attemptsLeft-- > 0) {
            try {
                this.makeRemoteCall(buddies, command);
                break;
            }
            catch (Exception e) {
                if (e instanceof BuddyNotInitException || e.getCause() instanceof BuddyNotInitException) {
                    if (attemptsLeft > 0) {
                        this.log.info((Object)"One of the buddies have not been initialised.  Will retry after a short nap.");
                        try {
                            Thread.sleep(UNINIT_BUDDIES_RETRY_NAPTIME[currentAttempt++]);
                        }
                        catch (InterruptedException e1) {
                            this.log.trace((Object)"Thread interrupted while sleeping/waiting for a retry", (Throwable)e1);
                        }
                        continue;
                    }
                    throw new BuddyNotInitException("Unable to contact buddy after 5 retries");
                }
                this.log.error((Object)"Unable to communicate with Buddy for some reason", (Throwable)e);
            }
        }
        this.log.trace((Object)"removeFromGroup notification complete");
    }

    private void addBuddies(List<Address> buddies) throws CacheException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Assigning new buddies to buddy group [" + this.buddyGroup.getGroupName() + "].  New buddies are " + buddies));
        }
        this.buddyGroup.addBuddies(buddies);
        HashMap<Fqn, byte[]> stateMap = new HashMap<Fqn, byte[]>();
        if (this.configuredToFetchState()) {
            byte[] state;
            if (this.configuration.isUseRegionBasedMarshalling()) {
                List<Region> regions = this.regionManager.getAllRegions(Region.Type.MARSHALLING);
                if (regions.size() > 0) {
                    for (Region r : regions) {
                        Fqn f = r.getFqn();
                        state = this.acquireState(f);
                        if (state == null) continue;
                        stateMap.put(f, state);
                    }
                } else if (!this.configuration.isInactiveOnStartup() && (state = this.acquireState(Fqn.ROOT)) != null) {
                    stateMap.put(Fqn.ROOT, state);
                }
            } else {
                state = this.acquireState(Fqn.ROOT);
                if (state != null) {
                    stateMap.put(Fqn.ROOT, state);
                }
            }
        } else if (this.trace) {
            this.log.trace((Object)"Not configured to provide state!");
        }
        AssignToBuddyGroupCommand membershipCall = this.commandsFactory.buildAssignToBuddyGroupCommand(this.buddyGroup, stateMap);
        int attemptsLeft = 5;
        int currentAttempt = 0;
        while (attemptsLeft-- > 0) {
            try {
                this.makeRemoteCall(buddies, membershipCall);
                break;
            }
            catch (Exception e) {
                if (e instanceof BuddyNotInitException || e.getCause() instanceof BuddyNotInitException) {
                    if (attemptsLeft > 0) {
                        this.log.info((Object)"One of the buddies have not been initialised.  Will retry after a short nap.");
                        try {
                            Thread.sleep(UNINIT_BUDDIES_RETRY_NAPTIME[currentAttempt++]);
                        }
                        catch (InterruptedException e1) {
                            this.log.trace((Object)"Thread interrupted while sleeping/waiting for a retry", (Throwable)e1);
                        }
                        continue;
                    }
                    throw new BuddyNotInitException("Unable to contact buddy after 5 retries");
                }
                if (attemptsLeft > 0) {
                    this.log.error((Object)"Unable to communicate with Buddy for some reason", (Throwable)e);
                    continue;
                }
                throw new BuddyNotInitException("Unable to contact buddy after 5 retries");
            }
        }
        this.log.trace((Object)"addToGroup notification complete");
    }

    private boolean configuredToFetchState() {
        return this.configuration.isFetchInMemoryState() || this.cache.getCacheLoaderManager() != null && this.cache.getCacheLoaderManager().isFetchPersistentState();
    }

    private byte[] acquireState(Fqn fqn) throws CacheException {
        long[] timeouts = new long[]{400L, 800L, 1600L, this.configuration.getStateRetrievalTimeout()};
        TimeoutException timeoutException = null;
        for (int i = 0; i < timeouts.length; ++i) {
            boolean force = i == timeouts.length - 1;
            try {
                byte[] state = this.generateState(fqn, timeouts[i], force);
                if (this.log.isDebugEnabled()) {
                    if (state == null) {
                        this.log.debug((Object)"acquireState(): Got null state.  Region is probably empty.");
                    } else {
                        this.log.debug((Object)"acquireState(): Got state");
                    }
                }
                return state;
            }
            catch (TimeoutException t) {
                timeoutException = t;
                if (!this.trace) continue;
                this.log.trace((Object)"acquireState(): got a TimeoutException");
                continue;
            }
            catch (Exception e) {
                throw new CacheException("Error acquiring state", e);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (timeoutException != null) {
            throw new CacheException("acquireState(): Failed getting state due to timeout", timeoutException);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"acquireState(): Unable to give state");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateState(Fqn fqn, long timeout, boolean force) throws Throwable {
        ExposedByteArrayOutputStream baos;
        MarshalledValueOutputStream out = null;
        byte[] result = null;
        try {
            baos = new ExposedByteArrayOutputStream(16384);
            out = new MarshalledValueOutputStream((OutputStream)baos);
            try {
                this.stateTransferManager.getState((ObjectOutputStream)out, fqn, timeout, force, false);
            }
            catch (RegionEmptyException ree) {
                byte[] byArray = null;
                Util.close((OutputStream)out);
                return byArray;
            }
        }
        catch (Throwable throwable) {
            Util.close(out);
            throw throwable;
        }
        result = baos.getRawBuffer();
        Util.close((OutputStream)out);
        return result;
    }

    private void broadcastBuddyPoolMembership() {
        this.broadcastBuddyPoolMembership(null);
    }

    private void broadcastBuddyPoolMembership(List<Address> recipients) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Instance " + this.buddyGroup.getDataOwner() + " broadcasting membership in buddy pool " + this.config.getBuddyPoolName() + " to recipients " + recipients));
        }
        AnnounceBuddyPoolNameCommand command = this.commandsFactory.buildAnnounceBuddyPoolNameCommand(this.buddyGroup.getDataOwner(), this.config.getBuddyPoolName());
        try {
            this.makeRemoteCall(recipients, command);
        }
        catch (Exception e) {
            this.log.error((Object)"Problems broadcasting buddy pool membership info to cluster", (Throwable)e);
        }
    }

    private void makeRemoteCall(List<Address> recipients, ReplicableCommand call) throws Exception {
        if (recipients != null) {
            Iterator<Address> recipientsIt = recipients.iterator();
            List<Address> members = this.cache.getMembers();
            while (recipientsIt.hasNext()) {
                if (members.contains(recipientsIt.next())) continue;
                recipientsIt.remove();
            }
        }
        this.rpcManager.callRemoteMethods(recipients == null ? null : new Vector<Address>(recipients), call, true, (long)this.config.getBuddyCommunicationTimeout(), false);
    }

    private void migrateDefunctData(NodeSPI backupRoot, Address dataOwner) {
        Fqn defunctBackupRootFqn = this.getDefunctBackupRootFqn(dataOwner);
        if (this.trace) {
            this.log.trace((Object)("Migrating defunct data.  Backup root is " + backupRoot));
        }
        if (this.trace) {
            this.log.trace((Object)("Children of backup root are " + backupRoot.getChildren()));
        }
        for (Node child : backupRoot.getChildren()) {
            Fqn childFqn = child.getFqn();
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            this.cache.move(childFqn, defunctBackupRootFqn);
        }
        this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        backupRoot.getParentDirect().removeChild(backupRoot.getFqn().getLastElement());
    }

    private Fqn getDefunctBackupRootFqn(Address dataOwner) {
        Fqn defunctRoot = this.buddyFqnTransformer.getDeadBackupRoot(dataOwner);
        this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
        NodeSPI<?, ?> root = this.cache.getRoot();
        this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        this.cache.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
        Node defunctRootNode = root.addChild(defunctRoot);
        TreeSet<Object> childrenNames = new TreeSet<Object>(defunctRootNode.getChildrenNames());
        Integer childName = 1;
        if (!childrenNames.isEmpty()) {
            Integer lastChild = (Integer)childrenNames.last();
            childName = lastChild + 1;
        }
        this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        defunctRootNode.addChild(Fqn.fromElements(childName));
        return Fqn.fromRelativeElements(defunctRoot, childName);
    }

    @ManagedAttribute(description="A String representation of the cache's buddy group")
    public String getBuddyGroup() {
        return this.buddyGroup.toString();
    }

    @ManagedAttribute(description="A String representation of buddy groups the cache participates in")
    public String getBuddyGroupsIParticipateIn() {
        return this.buddyGroupsIParticipateIn.toString();
    }

    @CacheListener
    public class ViewChangeListener {
        private Vector<Address> oldMembers;

        @ViewChanged
        public void handleViewChange(ViewChangedEvent event) {
            View newView = event.getNewView();
            if (BuddyManager.this.trace) {
                BuddyManager.this.log.trace((Object)("BuddyManager CacheListener - got view change with new view " + newView));
            }
            Vector newMembers = newView.getMembers();
            if (BuddyManager.this.config.getBuddyPoolName() == null) {
                BuddyManager.this.enqueueViewChange(new MembershipChange(null, new Vector<Address>(newMembers)));
            } else {
                MembershipChange mc = new MembershipChange(this.oldMembers == null ? null : new Vector<Address>(this.oldMembers), new Vector<Address>(newMembers));
                BuddyManager.this.enqueueViewChange(mc);
                if (this.oldMembers == null) {
                    this.oldMembers = new Vector();
                }
                this.oldMembers.clear();
                this.oldMembers.addAll(newMembers);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncViewChangeHandlerThread
    implements Runnable {
        private Thread t;
        private boolean isRunning = true;

        private AsyncViewChangeHandlerThread() {
        }

        public void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread(this);
                this.t.setName("AsyncViewChangeHandlerThread," + BuddyManager.this.cache.getLocalAddress());
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        @Override
        public void run() {
            BuddyManager.this.log.trace((Object)"Started");
            try {
                BuddyManager.this.initialisationLatch.await();
            }
            catch (InterruptedException e) {
                BuddyManager.this.log.debug((Object)"Caught InterruptedException", (Throwable)e);
            }
            while (!Thread.interrupted() && this.isRunning) {
                try {
                    this.handleEnqueuedViewChange();
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Throwable t) {
                    BuddyManager.this.log.error((Object)"Caught exception handling view change", t);
                }
            }
            BuddyManager.this.log.trace((Object)"Exiting run()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleEnqueuedViewChange() throws Exception {
            BuddyManager.this.log.trace((Object)"Waiting for enqueued view change events");
            MembershipChange members = (MembershipChange)BuddyManager.this.queue.take();
            if (members == STOP_NOTIFIER) {
                BuddyManager.this.log.trace((Object)"Caught stop notifier, time to go home.");
                this.isRunning = false;
                return;
            }
            if (members.newMembers.size() == 1 && members.newMembers.get(0).equals(BuddyManager.this.cache.getLocalAddress())) {
                BuddyManager.this.log.info((Object)"Ignoring membership change event since it only contains self.");
                return;
            }
            this.broadcastPoolMembership(members);
            boolean rebroadcast = false;
            while (!this.buddyPoolInfoAvailable(members.newMembers)) {
                rebroadcast = true;
                Object object = BuddyManager.this.poolInfoNotifierLock;
                synchronized (object) {
                    BuddyManager.this.log.trace((Object)"Not received necessary buddy pool info for all new members yet; waiting on poolInfoNotifierLock.");
                    while (!BuddyManager.this.receivedBuddyInfo) {
                        BuddyManager.this.poolInfoNotifierLock.wait();
                    }
                    BuddyManager.this.log.trace((Object)"Notified!!");
                    BuddyManager.this.receivedBuddyInfo = false;
                }
            }
            if (rebroadcast) {
                this.broadcastPoolMembership(members);
            }
            BuddyManager.this.reassignBuddies(members.newMembers);
            if (!members.newMembers.containsAll(BuddyManager.this.buddyGroupsIParticipateIn.keySet())) {
                HashSet<Address> toRemove = new HashSet<Address>();
                for (Address a : BuddyManager.this.buddyGroupsIParticipateIn.keySet()) {
                    if (members.newMembers.contains(a)) continue;
                    toRemove.add(a);
                }
                for (Address a : toRemove) {
                    BuddyGroup bg = BuddyManager.this.buddyGroupsIParticipateIn.remove(a);
                    Fqn backupRootFqn = BuddyManager.this.buddyFqnTransformer.getBackupRoot(bg.getDataOwner());
                    NodeSPI backupRoot = BuddyManager.this.cache.getNode(backupRootFqn);
                    if (backupRoot == null) continue;
                    BuddyManager.this.migrateDefunctData(backupRoot, bg.getDataOwner());
                }
            }
        }

        private void broadcastPoolMembership(MembershipChange members) {
            BuddyManager.this.log.trace((Object)"Broadcasting pool membership details, triggered by view change.");
            if (members.oldMembers == null) {
                BuddyManager.this.broadcastBuddyPoolMembership();
            } else {
                ArrayList<Address> delta = new ArrayList<Address>();
                delta.addAll(members.newMembers);
                delta.removeAll(members.oldMembers);
                BuddyManager.this.broadcastBuddyPoolMembership(delta);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean buddyPoolInfoAvailable(List<Address> newMembers) {
            boolean infoReceived = true;
            for (Address address : newMembers) {
                Set<Address> set = BuddyManager.this.nullBuddyPool;
                synchronized (set) {
                    infoReceived = infoReceived && (address.equals(BuddyManager.this.cache.getLocalAddress()) || BuddyManager.this.buddyPool.keySet().contains(address) || BuddyManager.this.nullBuddyPool.contains(address));
                }
            }
            if (BuddyManager.this.trace) {
                BuddyManager.this.log.trace((Object)(BuddyManager.this.buddyGroup.getDataOwner() + " received buddy pool info for new members " + newMembers + "?  " + infoReceived));
            }
            return infoReceived;
        }

        public void stop() {
            if (this.t != null) {
                this.t.interrupt();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MembershipChange {
        final List<Address> oldMembers;
        final List<Address> newMembers;

        public MembershipChange(List<Address> oldMembers, List<Address> newMembers) {
            this.oldMembers = oldMembers;
            this.newMembers = newMembers;
        }

        public String toString() {
            return "MembershipChange: Old members = " + this.oldMembers + " New members = " + this.newMembers;
        }
    }
}

