/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.CustomInterceptorConfig;
import org.jboss.cache.config.parsing.JGroupsStackParser;
import org.jboss.cache.config.parsing.RootElementBuilder;
import org.jboss.cache.config.parsing.XmlParserBase;
import org.jboss.cache.config.parsing.element.BuddyElementParser;
import org.jboss.cache.config.parsing.element.CustomInterceptorsElementParser;
import org.jboss.cache.config.parsing.element.EvictionElementParser;
import org.jboss.cache.config.parsing.element.LoadersElementParser;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.util.FileLookup;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;

public class XmlConfigurationParser
extends XmlParserBase {
    private RootElementBuilder rootElementBuilder;
    private Configuration config = new Configuration();
    private Element root;

    public XmlConfigurationParser(ErrorHandler errorHandler) {
        this.rootElementBuilder = new RootElementBuilder(errorHandler);
    }

    public XmlConfigurationParser(boolean validating, ErrorHandler errorHandler) {
        this.rootElementBuilder = new RootElementBuilder(errorHandler, validating);
    }

    public XmlConfigurationParser() {
        this.rootElementBuilder = new RootElementBuilder();
    }

    public Configuration parseFile(String filename) {
        InputStream is = new FileLookup().lookupFile(filename);
        if (is == null) {
            throw new ConfigurationException("Unable to find config file " + filename + " either in classpath or on the filesystem!");
        }
        return this.parseStream(is);
    }

    public Configuration parseStream(InputStream configStream) {
        this.readRoot(configStream);
        return this.processElements(false);
    }

    public Configuration parseElement(Element root) {
        this.root = root;
        this.root.normalize();
        return this.processElements(false);
    }

    public Configuration parseElementIgnoringRoot(Element root) {
        this.root = root;
        this.root.normalize();
        return this.processElements(true);
    }

    public boolean isValidating() {
        return this.rootElementBuilder.isValidating();
    }

    private Configuration processElements(boolean ignoreRoot) {
        if (!(ignoreRoot || "jbosscache".equals(this.root.getLocalName()) && "urn:jboss:jbosscache-core:config:3.0".equals(this.root.getNamespaceURI()))) {
            throw new ConfigurationException("Expected root element {urn:jboss:jbosscache-core:config:3.0}jbosscache");
        }
        try {
            this.configureLocking(this.getSingleElement("locking"));
            this.configureTransaction(this.getSingleElement("transaction"));
            this.configureClustering(this.getSingleElement("clustering"));
            this.configureSerialization(this.getSingleElement("serialization"));
            this.configureInvalidation(this.getSingleElement("invalidation"));
            this.configureStartup(this.getSingleElement("startup"));
            this.configureShutdown(this.getSingleElement("shutdown"));
            this.configureJmxStatistics(this.getSingleElement("jmxStatistics"));
            this.configureEviction(this.getSingleElement("eviction"));
            this.configureCacheLoaders(this.getSingleElement("loaders"));
            this.configureCustomInterceptors(this.getSingleElement("customInterceptors"));
            this.configureListeners(this.getSingleElement("listeners"));
            this.configureInvocationBatching(this.getSingleElement("invocationBatching"));
        }
        catch (Exception e) {
            throw new ConfigurationException("Unexpected exception while parsing the configuration file", e);
        }
        return this.config;
    }

    private void configureClustering(Element e) {
        boolean sync;
        if (e == null) {
            return;
        }
        boolean repl = true;
        String mode = this.getAttributeValue(e, "mode").toUpperCase();
        if (mode.startsWith("R")) {
            repl = true;
        } else if (mode.startsWith("I")) {
            repl = false;
        }
        Element asyncEl = this.getSingleElementInCoreNS("async", e);
        Element syncEl = this.getSingleElementInCoreNS("sync", e);
        if (syncEl != null && asyncEl != null) {
            throw new ConfigurationException("Cannot have sync and async elements within the same cluster element!");
        }
        boolean bl = sync = asyncEl == null;
        if (sync) {
            this.config.setCacheMode(repl ? Configuration.CacheMode.REPL_SYNC : Configuration.CacheMode.INVALIDATION_SYNC);
            this.configureSyncMode(syncEl);
        } else {
            this.config.setCacheMode(repl ? Configuration.CacheMode.REPL_ASYNC : Configuration.CacheMode.INVALIDATION_ASYNC);
            this.configureAsyncMode(asyncEl);
        }
        String cn = this.getAttributeValue(e, "clusterName");
        if (this.existsAttribute(cn)) {
            this.config.setClusterName(cn);
        }
        this.configureBuddyReplication(this.getSingleElementInCoreNS("buddy", e));
        this.configureStateRetrieval(this.getSingleElementInCoreNS("stateRetrieval", e));
        this.configureTransport(this.getSingleElementInCoreNS("jgroupsConfig", e));
    }

    private void configureStateRetrieval(Element element) {
        String stateRetrievalTimeout;
        if (element == null) {
            return;
        }
        String fetchInMemoryState = this.getAttributeValue(element, "fetchInMemoryState");
        if (this.existsAttribute(fetchInMemoryState)) {
            this.config.setFetchInMemoryState(this.getBoolean(fetchInMemoryState));
        }
        if (this.existsAttribute(stateRetrievalTimeout = this.getAttributeValue(element, "timeout"))) {
            this.config.setStateRetrievalTimeout(this.getLong(stateRetrievalTimeout));
        }
    }

    private void configureTransaction(Element element) {
        String syncCommitPhase;
        String syncRollbackPhase;
        if (element == null) {
            return;
        }
        String attrName = "transactionManagerLookupClass";
        String txMngLookupClass = this.getAttributeValue(element, attrName);
        if (this.existsAttribute(txMngLookupClass)) {
            this.config.setTransactionManagerLookupClass(txMngLookupClass);
        }
        if (this.existsAttribute(syncRollbackPhase = this.getAttributeValue(element, "syncRollbackPhase"))) {
            this.config.setSyncRollbackPhase(this.getBoolean(syncRollbackPhase));
        }
        if (this.existsAttribute(syncCommitPhase = this.getAttributeValue(element, "syncCommitPhase"))) {
            this.config.setSyncCommitPhase(this.getBoolean(syncCommitPhase));
        }
    }

    private void configureSerialization(Element element) {
        String useRegionBasedMarshalling;
        String useLazyDeserialization;
        String marshallerClass;
        String version;
        String objectOutputStreamPoolSize;
        if (element == null) {
            return;
        }
        String objectInputStreamPoolSize = this.getAttributeValue(element, "objectInputStreamPoolSize");
        if (this.existsAttribute(objectInputStreamPoolSize)) {
            this.config.setObjectInputStreamPoolSize(this.getInt(objectInputStreamPoolSize));
        }
        if (this.existsAttribute(objectOutputStreamPoolSize = this.getAttributeValue(element, "objectOutputStreamPoolSize"))) {
            this.config.setObjectOutputStreamPoolSize(this.getInt(objectOutputStreamPoolSize));
        }
        if (this.existsAttribute(version = this.getAttributeValue(element, "version"))) {
            this.config.setReplVersionString(version);
        }
        if (this.existsAttribute(marshallerClass = this.getAttributeValue(element, "marshallerClass"))) {
            this.config.setMarshallerClass(marshallerClass);
        }
        if (this.existsAttribute(useLazyDeserialization = this.getAttributeValue(element, "useLazyDeserialization"))) {
            this.config.setUseLazyDeserialization(this.getBoolean(useLazyDeserialization));
        }
        if (this.existsAttribute(useRegionBasedMarshalling = this.getAttributeValue(element, "useRegionBasedMarshalling"))) {
            this.config.setUseRegionBasedMarshalling(this.getBoolean(useRegionBasedMarshalling));
        }
    }

    private void configureCustomInterceptors(Element element) {
        if (element == null) {
            return;
        }
        CustomInterceptorsElementParser parser = new CustomInterceptorsElementParser();
        List<CustomInterceptorConfig> interceptorConfigList = parser.parseCustomInterceptors(element);
        this.config.setCustomInterceptors(interceptorConfigList);
    }

    private void configureListeners(Element element) {
        if (element == null) {
            return;
        }
        String asyncPoolSizeStr = this.getAttributeValue(element, "asyncPoolSize");
        if (this.existsAttribute(asyncPoolSizeStr)) {
            try {
                this.config.setListenerAsyncPoolSize(Integer.parseInt(asyncPoolSizeStr));
            }
            catch (NumberFormatException nfe) {
                throw new ConfigurationException("Unable to parse the asyncPoolSize attribute of the listeners element.  Was [" + asyncPoolSizeStr + "]");
            }
        }
    }

    private void configureInvocationBatching(Element element) {
        if (element == null) {
            return;
        }
        boolean enabled = this.getBoolean(this.getAttributeValue(element, "enabled"));
        this.config.setInvocationBatchingEnabled(enabled);
    }

    private void configureBuddyReplication(Element element) {
        if (element == null) {
            return;
        }
        BuddyElementParser buddyElementParser = new BuddyElementParser();
        BuddyReplicationConfig brConfig = buddyElementParser.parseBuddyElement(element);
        this.config.setBuddyReplicationConfig(brConfig);
    }

    private void configureCacheLoaders(Element element) {
        if (element == null) {
            return;
        }
        LoadersElementParser clElementParser = new LoadersElementParser();
        CacheLoaderConfig cacheLoaderConfig = clElementParser.parseLoadersElement(element);
        this.config.setCacheLoaderConfig(cacheLoaderConfig);
    }

    private void configureEviction(Element element) {
        if (element == null) {
            return;
        }
        EvictionElementParser evictionElementParser = new EvictionElementParser();
        this.config.setEvictionConfig(evictionElementParser.parseEvictionElement(element));
    }

    private void configureJmxStatistics(Element element) {
        if (element == null) {
            return;
        }
        String enabled = this.getAttributeValue(element, "enabled");
        this.config.setExposeManagementStatistics(this.getBoolean(enabled));
    }

    private void configureShutdown(Element element) {
        if (element == null) {
            return;
        }
        String hookBehavior = this.getAttributeValue(element, "hookBehavior");
        if (this.existsAttribute(hookBehavior)) {
            this.config.setShutdownHookBehavior(hookBehavior);
        }
    }

    private void configureTransport(Element element) {
        if (element == null) {
            return;
        }
        String cfgFile = this.getAttributeValue(element, "configFile");
        if (this.existsAttribute(cfgFile)) {
            URL u = new FileLookup().lookupFileLocation(cfgFile);
            this.config.setJgroupsConfigFile(u);
        } else {
            String multiplexerStack = this.getAttributeValue(element, "multiplexerStack");
            if (this.existsAttribute(multiplexerStack)) {
                this.config.setMultiplexerStack(multiplexerStack);
            } else {
                JGroupsStackParser stackParser = new JGroupsStackParser();
                String clusterConfigStr = stackParser.parseClusterConfigXml(element);
                if (clusterConfigStr != null && clusterConfigStr.trim().length() > 0) {
                    this.config.setClusterConfig(clusterConfigStr);
                }
            }
        }
    }

    private void configureStartup(Element element) {
        if (element == null) {
            return;
        }
        String inactiveOnStartup = this.getAttributeValue(element, "regionsInactiveOnStartup");
        if (this.existsAttribute(inactiveOnStartup)) {
            this.config.setInactiveOnStartup(this.getBoolean(inactiveOnStartup));
        }
    }

    private void configureInvalidation(Element element) {
        Element sync;
        if (element == null) {
            return;
        }
        Element async = this.getSingleElement("async");
        if (async != null) {
            this.config.setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
            this.configureAsyncMode(this.getSingleElementInCoreNS("async", element));
        }
        if ((sync = this.getSingleElement("sync")) != null) {
            this.config.setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
            this.configureSyncMode(this.getSingleElementInCoreNS("sync", element));
        }
    }

    private void configureSyncMode(Element element) {
        String replTimeout = this.getAttributeValue(element, "replTimeout");
        if (this.existsAttribute(replTimeout)) {
            this.config.setSyncReplTimeout(this.getLong(replTimeout));
        }
    }

    private void configureAsyncMode(Element element) {
        String serializationExecutorPoolSize;
        String replQueueMaxElements;
        String replQueueInterval;
        String useReplQueue = this.getAttributeValue(element, "useReplQueue");
        if (this.existsAttribute(useReplQueue)) {
            this.config.setUseReplQueue(this.getBoolean(useReplQueue));
        }
        if (this.existsAttribute(replQueueInterval = this.getAttributeValue(element, "replQueueInterval"))) {
            this.config.setReplQueueInterval(this.getLong(replQueueInterval));
        }
        if (this.existsAttribute(replQueueMaxElements = this.getAttributeValue(element, "replQueueMaxElements"))) {
            this.config.setReplQueueMaxElements(this.getInt(replQueueMaxElements));
        }
        if (this.existsAttribute(serializationExecutorPoolSize = this.getAttributeValue(element, "serializationExecutorPoolSize"))) {
            this.config.setSerializationExecutorPoolSize(this.getInt(serializationExecutorPoolSize));
        }
    }

    private void configureLocking(Element element) {
        String concurrencyLevel;
        String writeSkewCheck;
        String nodeLockingScheme;
        String lockAcquisitionTimeout;
        String lockParentForChildInsertRemove;
        String isolationLevel = this.getAttributeValue(element, "isolationLevel");
        if (this.existsAttribute(isolationLevel)) {
            this.config.setIsolationLevel(IsolationLevel.valueOf(isolationLevel));
        }
        if (this.existsAttribute(lockParentForChildInsertRemove = this.getAttributeValue(element, "lockParentForChildInsertRemove"))) {
            this.config.setLockParentForChildInsertRemove(this.getBoolean(lockParentForChildInsertRemove));
        }
        if (this.existsAttribute(lockAcquisitionTimeout = this.getAttributeValue(element, "lockAcquisitionTimeout"))) {
            this.config.setLockAcquisitionTimeout(this.getLong(lockAcquisitionTimeout));
        }
        if (this.existsAttribute(nodeLockingScheme = this.getAttributeValue(element, "nodeLockingScheme"))) {
            this.config.setNodeLockingScheme(nodeLockingScheme);
        }
        if (this.existsAttribute(writeSkewCheck = this.getAttributeValue(element, "writeSkewCheck"))) {
            this.config.setWriteSkewCheck(this.getBoolean(writeSkewCheck));
        }
        if (this.existsAttribute(concurrencyLevel = this.getAttributeValue(element, "concurrencyLevel"))) {
            this.config.setConcurrencyLevel(this.getInt(concurrencyLevel));
        }
    }

    private Element getSingleElement(String elementName) {
        return this.getSingleElementInCoreNS(elementName, this.root);
    }

    private void readRoot(InputStream config) {
        this.root = this.rootElementBuilder.readRoot(config);
    }

    public boolean isValidElementRoot(Element element) {
        NodeList elements = element.getElementsByTagName("jbosscache");
        return elements != null && elements.getLength() > 0;
    }
}

