/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentMap;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.read.ExistsCommand;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.read.GravitateDataCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.commands.write.InvalidateCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.base.PrePostProcessingCommandInterceptor;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.mvcc.MVCCNodeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVCCLockingInterceptor
extends PrePostProcessingCommandInterceptor {
    LockManager lockManager;
    DataContainer dataContainer;
    MVCCNodeHelper helper;

    @Inject
    public void setDependencies(LockManager lockManager, DataContainer dataContainer, MVCCNodeHelper helper) {
        this.lockManager = lockManager;
        this.dataContainer = dataContainer;
        this.helper = helper;
    }

    @Override
    protected boolean doBeforeCall(InvocationContext ctx, VisitableCommand command) {
        if (ctx.getOptionOverrides().isSuppressLocking() && this.log.isWarnEnabled()) {
            this.log.warn((Object)"Lock suppression not supported with MVCC!");
        }
        return true;
    }

    @Override
    public Object handlePutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        this.helper.wrapNodeForWriting(ctx, command.getFqn(), true, true, false, false, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handlePutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        this.helper.wrapNodeForWriting(ctx, command.getFqn(), true, true, false, false, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handlePutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        this.helper.wrapNodeForWriting(ctx, command.getFqn(), true, true, false, false, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        this.helper.wrapNodesRecursivelyForRemoval(ctx, command.getFqn());
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        this.helper.wrapNodeForWriting(ctx, command.getFqn(), true, false, false, false, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleEvictFqnCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        ctx.getOptionOverrides().setLockAcquisitionTimeout(0);
        if (command.isRecursive()) {
            this.handleRecursiveEvict(ctx, command);
        } else {
            this.handleNonrecursiveEvict(ctx, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private void handleRecursiveEvict(InvocationContext ctx, EvictCommand command) throws InterruptedException {
        List<Fqn<Object>> fqnsToEvict;
        if (command.getFqn().isRoot()) {
            ConcurrentMap children = this.dataContainer.peekInternalNode(Fqn.ROOT, false).getChildrenMap();
            if (!children.isEmpty()) {
                fqnsToEvict = new LinkedList<Fqn>();
                for (InternalNode child : children.values()) {
                    fqnsToEvict.addAll(this.helper.wrapNodesRecursivelyForRemoval(ctx, child.getFqn()));
                }
            } else {
                fqnsToEvict = Collections.emptyList();
            }
        } else {
            fqnsToEvict = this.helper.wrapNodesRecursivelyForRemoval(ctx, command.getFqn());
        }
        command.setNodesToEvict(fqnsToEvict);
    }

    private void handleNonrecursiveEvict(InvocationContext ctx, EvictCommand command) throws InterruptedException {
        if (command.getFqn().isRoot()) {
            ConcurrentMap children = this.dataContainer.peekInternalNode(Fqn.ROOT, false).getChildrenMap();
            if (!children.isEmpty()) {
                for (InternalNode child : children.values()) {
                    this.helper.wrapNodeForWriting(ctx, child.getFqn(), true, false, false, true, true);
                }
            }
        } else {
            this.helper.wrapNodeForWriting(ctx, command.getFqn(), true, false, false, true, true);
        }
    }

    @Override
    public Object handleInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        ctx.getOptionOverrides().setLockAcquisitionTimeout(0);
        if (!command.getFqn().isRoot()) {
            this.helper.wrapNodesRecursivelyForRemoval(ctx, command.getFqn());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        this.helper.wrapNodeForWriting(ctx, command.getFqn(), true, false, false, false, false);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleGetDataMapCommand(InvocationContext ctx, GetDataMapCommand command) throws Throwable {
        this.helper.wrapNodeForReading(ctx, command.getFqn(), true);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleExistsNodeCommand(InvocationContext ctx, ExistsCommand command) throws Throwable {
        this.helper.wrapNodeForReading(ctx, command.getFqn(), true);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        this.helper.wrapNodeForReading(ctx, command.getFqn(), true);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        this.helper.wrapNodeForReading(ctx, command.getFqn(), true);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleGetKeysCommand(InvocationContext ctx, GetKeysCommand command) throws Throwable {
        this.helper.wrapNodeForReading(ctx, command.getFqn(), true);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleGetChildrenNamesCommand(InvocationContext ctx, GetChildrenNamesCommand command) throws Throwable {
        this.helper.wrapNodeForReading(ctx, command.getFqn(), true);
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        List<Fqn> nodeAndChildren = this.helper.wrapNodesRecursivelyForRemoval(ctx, command.getFqn());
        Fqn newParent = command.getTo();
        Fqn oldParent = command.getFqn().getParent();
        this.helper.wrapNodeForWriting(ctx, newParent, true, true, false, false, false);
        if (!oldParent.equals(newParent)) {
            for (Fqn f : nodeAndChildren) {
                Fqn newChildFqn = f.replaceAncestor(oldParent, newParent);
                this.helper.wrapNodeForWriting(ctx, newChildFqn, true, true, true, false, false);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object handleGravitateDataCommand(InvocationContext ctx, GravitateDataCommand command) throws Throwable {
        this.helper.wrapNodeForReading(ctx, command.getFqn(), true);
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handleRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        Object retval = null;
        try {
            retval = this.invokeNextInterceptor(ctx, command);
        }
        finally {
            this.transactionalCleanup(false, ctx);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handleCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        Object retval = null;
        try {
            retval = this.invokeNextInterceptor(ctx, command);
        }
        finally {
            this.transactionalCleanup(true, ctx);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handlePrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = null;
        try {
            retval = this.invokeNextInterceptor(ctx, command);
        }
        finally {
            if (command.isOnePhaseCommit()) {
                this.transactionalCleanup(true, ctx);
            }
        }
        return retval;
    }

    @Override
    protected void doAfterCall(InvocationContext ctx, VisitableCommand command) {
        if (ctx.getTransactionContext() == null) {
            List locks = ctx.getLocks();
            if (!locks.isEmpty()) {
                this.cleanupLocks(locks, ctx, Thread.currentThread(), true);
            } else if (this.trace) {
                this.log.trace((Object)"Nothing to do since there are no modifications in scope.");
            }
        } else if (this.trace) {
            this.log.trace((Object)"Nothing to do since there is a transaction in scope.");
        }
    }

    private void cleanupLocks(List<Fqn> locks, InvocationContext ctx, Object owner, boolean commit) {
        ListIterator<Fqn> it = locks.listIterator(locks.size());
        if (commit) {
            while (it.hasPrevious()) {
                Fqn f = it.previous();
                NodeSPI rcn = ctx.lookUpNode(f);
                if (rcn != null) {
                    rcn.commitUpdate(ctx, this.dataContainer);
                }
                if (this.trace) {
                    this.log.trace((Object)("Releasing lock on [" + f + "] for owner " + owner));
                }
                this.lockManager.unlock(f, owner);
            }
        } else {
            while (it.hasPrevious()) {
                Fqn f = it.previous();
                NodeSPI rcn = ctx.lookUpNode(f);
                if (rcn != null) {
                    rcn.rollbackUpdate();
                }
                if (this.trace) {
                    this.log.trace((Object)("Releasing lock on [" + f + "] for owner " + owner));
                }
                this.lockManager.unlock(f, owner);
            }
        }
        ctx.clearLocks();
    }

    private void transactionalCleanup(boolean commit, InvocationContext ctx) {
        if (ctx.getTransactionContext() != null) {
            List locks = ctx.getTransactionContext().getLocks();
            if (!locks.isEmpty()) {
                this.cleanupLocks(locks, ctx, ctx.getGlobalTransaction(), commit);
            }
        } else {
            throw new IllegalStateException("Attempting to do a commit or rollback but there is no transactional context in scope. " + ctx);
        }
    }
}

