/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Destroy;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.marshall.MarshalledValueMap;
import org.jboss.cache.notifications.IncorrectCacheListenerException;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.notifications.annotation.BuddyGroupChanged;
import org.jboss.cache.notifications.annotation.CacheBlocked;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.CacheUnblocked;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeInvalidated;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeMoved;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.NodeVisited;
import org.jboss.cache.notifications.annotation.TransactionCompleted;
import org.jboss.cache.notifications.annotation.TransactionRegistered;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.BuddyGroupChangedEvent;
import org.jboss.cache.notifications.event.CacheBlockedEvent;
import org.jboss.cache.notifications.event.CacheStartedEvent;
import org.jboss.cache.notifications.event.CacheStoppedEvent;
import org.jboss.cache.notifications.event.CacheUnblockedEvent;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.EventImpl;
import org.jboss.cache.notifications.event.NodeActivatedEvent;
import org.jboss.cache.notifications.event.NodeCreatedEvent;
import org.jboss.cache.notifications.event.NodeEvictedEvent;
import org.jboss.cache.notifications.event.NodeInvalidatedEvent;
import org.jboss.cache.notifications.event.NodeLoadedEvent;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeMovedEvent;
import org.jboss.cache.notifications.event.NodePassivatedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.cache.notifications.event.NodeVisitedEvent;
import org.jboss.cache.notifications.event.TransactionCompletedEvent;
import org.jboss.cache.notifications.event.TransactionRegisteredEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.cache.util.Immutables;
import org.jboss.cache.util.concurrent.WithinThreadExecutor;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class NotifierImpl
implements Notifier {
    private static final Log log = LogFactory.getLog(NotifierImpl.class);
    private static final Class emptyMap = Collections.emptyMap().getClass();
    private static final Class singletonMap = Collections.singletonMap(null, null).getClass();
    private static final Class[] allowedMethodAnnotations = new Class[]{CacheStarted.class, CacheStopped.class, CacheBlocked.class, CacheUnblocked.class, NodeCreated.class, NodeRemoved.class, NodeVisited.class, NodeModified.class, NodeMoved.class, NodeActivated.class, NodePassivated.class, NodeLoaded.class, NodeEvicted.class, TransactionRegistered.class, TransactionCompleted.class, ViewChanged.class, BuddyGroupChanged.class, NodeInvalidated.class};
    private static final Class[] parameterTypes = new Class[]{CacheStartedEvent.class, CacheStoppedEvent.class, CacheBlockedEvent.class, CacheUnblockedEvent.class, NodeCreatedEvent.class, NodeRemovedEvent.class, NodeVisitedEvent.class, NodeModifiedEvent.class, NodeMovedEvent.class, NodeActivatedEvent.class, NodePassivatedEvent.class, NodeLoadedEvent.class, NodeEvictedEvent.class, TransactionRegisteredEvent.class, TransactionCompletedEvent.class, ViewChangedEvent.class, BuddyGroupChangedEvent.class, NodeInvalidatedEvent.class};
    final Map<Class<? extends Annotation>, List<ListenerInvocation>> listenersMap = new HashMap<Class<? extends Annotation>, List<ListenerInvocation>>(32);
    final List<ListenerInvocation> cacheStartedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> cacheStoppedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> cacheBlockedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> cacheUnblockedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> nodeCreatedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> nodeRemovedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> nodeVisitedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> nodeModifiedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> nodeMovedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> nodeActivatedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> nodePassivatedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> nodeLoadedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> nodeInvalidatedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> nodeEvictedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> transactionRegisteredListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> transactionCompletedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> viewChangedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    final List<ListenerInvocation> buddyGroupChangedListeners = new CopyOnWriteArrayList<ListenerInvocation>();
    private Cache cache;
    private boolean useMarshalledValueMaps;
    private Configuration config;
    private ExecutorService syncProcessor;
    private ExecutorService asyncProcessor;
    private static final AtomicInteger asyncNotifierThreadNumber = new AtomicInteger(0);

    public NotifierImpl() {
        this.listenersMap.put(CacheStarted.class, this.cacheStartedListeners);
        this.listenersMap.put(CacheStopped.class, this.cacheStoppedListeners);
        this.listenersMap.put(CacheBlocked.class, this.cacheBlockedListeners);
        this.listenersMap.put(CacheUnblocked.class, this.cacheUnblockedListeners);
        this.listenersMap.put(NodeCreated.class, this.nodeCreatedListeners);
        this.listenersMap.put(NodeRemoved.class, this.nodeRemovedListeners);
        this.listenersMap.put(NodeVisited.class, this.nodeVisitedListeners);
        this.listenersMap.put(NodeModified.class, this.nodeModifiedListeners);
        this.listenersMap.put(NodeMoved.class, this.nodeMovedListeners);
        this.listenersMap.put(NodeActivated.class, this.nodeActivatedListeners);
        this.listenersMap.put(NodePassivated.class, this.nodePassivatedListeners);
        this.listenersMap.put(NodeLoaded.class, this.nodeLoadedListeners);
        this.listenersMap.put(NodeEvicted.class, this.nodeEvictedListeners);
        this.listenersMap.put(TransactionRegistered.class, this.transactionRegisteredListeners);
        this.listenersMap.put(TransactionCompleted.class, this.transactionCompletedListeners);
        this.listenersMap.put(ViewChanged.class, this.viewChangedListeners);
        this.listenersMap.put(BuddyGroupChanged.class, this.buddyGroupChangedListeners);
        this.listenersMap.put(NodeInvalidated.class, this.nodeInvalidatedListeners);
    }

    @Inject
    void injectDependencies(CacheSPI cache, Configuration config) {
        this.cache = cache;
        this.config = config;
    }

    @Stop
    void stop() {
        this.syncProcessor.shutdownNow();
        this.asyncProcessor.shutdownNow();
    }

    @Destroy
    void destroy() {
        this.removeAllCacheListeners();
    }

    @Start
    void start() {
        this.useMarshalledValueMaps = this.config.isUseLazyDeserialization();
        this.syncProcessor = new WithinThreadExecutor();
        this.asyncProcessor = this.config.getRuntimeConfig().getAsyncCacheListenerExecutor();
        if (this.asyncProcessor == null) {
            this.asyncProcessor = this.config.getListenerAsyncPoolSize() > 0 ? Executors.newFixedThreadPool(this.config.getListenerAsyncPoolSize(), new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    return new Thread(r, "AsyncNotifier-" + asyncNotifierThreadNumber.getAndIncrement());
                }
            }) : this.syncProcessor;
        }
    }

    private void validateAndAddListenerInvocation(Object listener) {
        boolean sync = NotifierImpl.testListenerClassValidity(listener.getClass());
        boolean foundMethods = false;
        for (Method m : listener.getClass().getMethods()) {
            for (int i = 0; i < allowedMethodAnnotations.length; ++i) {
                if (!m.isAnnotationPresent(allowedMethodAnnotations[i])) continue;
                NotifierImpl.testListenerMethodValidity(m, parameterTypes[i], allowedMethodAnnotations[i].getName());
                this.addListenerInvocation(allowedMethodAnnotations[i], new ListenerInvocation(listener, m, sync));
                foundMethods = true;
            }
        }
        if (!foundMethods && log.isWarnEnabled()) {
            log.warn((Object)("Attempted to register listener of class " + listener.getClass() + ", but no valid, public methods annotated with method-level event annotations found! Ignoring listener."));
        }
    }

    private static boolean testListenerClassValidity(Class<?> listenerClass) {
        CacheListener cl = listenerClass.getAnnotation(CacheListener.class);
        if (cl == null) {
            throw new IncorrectCacheListenerException("Cache listener class MUST be annotated with org.jboss.cache.notifications.annotation.CacheListener");
        }
        if (!Modifier.isPublic(listenerClass.getModifiers())) {
            throw new IncorrectCacheListenerException("Cache listener class MUST be public!");
        }
        return cl.sync();
    }

    private static void testListenerMethodValidity(Method m, Class allowedParameter, String annotationName) {
        if (m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(allowedParameter)) {
            throw new IncorrectCacheListenerException("Methods annotated with " + annotationName + " must accept exactly one parameter, of assignable from type " + allowedParameter.getName());
        }
        if (!m.getReturnType().equals(Void.TYPE)) {
            throw new IncorrectCacheListenerException("Methods annotated with " + annotationName + " should have a return type of void.");
        }
    }

    private void addListenerInvocation(Class annotation, ListenerInvocation li) {
        List<ListenerInvocation> result = this.getListenerCollectionForAnnotation(annotation);
        result.add(li);
    }

    @Override
    public void addCacheListener(Object listener) {
        this.validateAndAddListenerInvocation(listener);
    }

    @Override
    public void removeCacheListener(Object listener) {
        for (Class annotation : allowedMethodAnnotations) {
            this.removeListenerInvocation(annotation, listener);
        }
    }

    private void removeListenerInvocation(Class annotation, Object listener) {
        if (listener == null) {
            return;
        }
        List<ListenerInvocation> l = this.getListenerCollectionForAnnotation(annotation);
        HashSet<ListenerInvocation> markedForRemoval = new HashSet<ListenerInvocation>();
        for (ListenerInvocation li : l) {
            if (!listener.equals(li.target)) continue;
            markedForRemoval.add(li);
        }
        l.removeAll(markedForRemoval);
    }

    @Stop(priority=99)
    public void removeAllCacheListeners() {
        this.cacheStartedListeners.clear();
        this.cacheStoppedListeners.clear();
        this.cacheBlockedListeners.clear();
        this.cacheUnblockedListeners.clear();
        this.nodeCreatedListeners.clear();
        this.nodeRemovedListeners.clear();
        this.nodeVisitedListeners.clear();
        this.nodeModifiedListeners.clear();
        this.nodeMovedListeners.clear();
        this.nodeActivatedListeners.clear();
        this.nodePassivatedListeners.clear();
        this.nodeLoadedListeners.clear();
        this.nodeEvictedListeners.clear();
        this.transactionRegisteredListeners.clear();
        this.transactionCompletedListeners.clear();
        this.viewChangedListeners.clear();
        this.buddyGroupChangedListeners.clear();
    }

    @Override
    public Set<Object> getCacheListeners() {
        HashSet<Object> result = new HashSet<Object>();
        for (List<ListenerInvocation> list : this.listenersMap.values()) {
            for (ListenerInvocation li : list) {
                result.add(li.target);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public void notifyNodeCreated(Fqn fqn, boolean pre, InvocationContext ctx) {
        if (!this.nodeCreatedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_CREATED);
            for (ListenerInvocation listener : this.nodeCreatedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeModified(Fqn fqn, boolean pre, NodeModifiedEvent.ModificationType modificationType, Map data, InvocationContext ctx) {
        if (!this.nodeModifiedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = NotifierImpl.copy(data, this.useMarshalledValueMaps);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setModificationType(modificationType);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_MODIFIED);
            for (ListenerInvocation listener : this.nodeModifiedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public boolean shouldNotifyOnNodeModified() {
        return !this.nodeModifiedListeners.isEmpty();
    }

    @Override
    public void notifyNodeRemoved(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        if (!this.nodeRemovedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = NotifierImpl.copy(data, this.useMarshalledValueMaps);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_REMOVED);
            for (ListenerInvocation listener : this.nodeRemovedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeVisited(Fqn fqn, boolean pre, InvocationContext ctx) {
        if (!this.nodeVisitedListeners.isEmpty()) {
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_VISITED);
            for (ListenerInvocation listener : this.nodeVisitedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeMoved(Fqn originalFqn, Fqn newFqn, boolean pre, InvocationContext ctx) {
        if (!this.nodeMovedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(originalFqn);
            e.setTargetFqn(newFqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_MOVED);
            for (ListenerInvocation listener : this.nodeMovedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeEvicted(Fqn fqn, boolean pre, InvocationContext ctx) {
        if (!this.nodeEvictedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_EVICTED);
            for (ListenerInvocation listener : this.nodeEvictedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeInvalidated(Fqn fqn, boolean pre, InvocationContext ctx) {
        if (!this.nodeInvalidatedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setType(Event.Type.NODE_INVALIDATED);
            for (ListenerInvocation listener : this.nodeInvalidatedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeLoaded(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        if (!this.nodeLoadedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = NotifierImpl.copy(data, this.useMarshalledValueMaps);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_LOADED);
            for (ListenerInvocation listener : this.nodeLoadedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodeActivated(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        if (!this.nodeActivatedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            Map dataCopy = NotifierImpl.copy(data, this.useMarshalledValueMaps);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_ACTIVATED);
            for (ListenerInvocation listener : this.nodeActivatedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyNodePassivated(Fqn fqn, boolean pre, Map data, InvocationContext ctx) {
        if (!this.nodePassivatedListeners.isEmpty()) {
            Map dataCopy = NotifierImpl.copy(data, this.useMarshalledValueMaps);
            Transaction tx = ctx.getTransaction();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setFqn(fqn);
            e.setTransaction(tx);
            e.setData(dataCopy);
            e.setType(Event.Type.NODE_PASSIVATED);
            for (ListenerInvocation listener : this.nodePassivatedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Start(priority=99)
    public void notifyCacheStarted() {
        if (!this.cacheStartedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setType(Event.Type.CACHE_STARTED);
            for (ListenerInvocation listener : this.cacheStartedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Stop(priority=98)
    public void notifyCacheStopped() {
        if (!this.cacheStoppedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setType(Event.Type.CACHE_STOPPED);
            for (ListenerInvocation listener : this.cacheStoppedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyViewChange(View newView, InvocationContext ctx) {
        if (!this.viewChangedListeners.isEmpty()) {
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setNewView(newView);
            e.setType(Event.Type.VIEW_CHANGED);
            for (ListenerInvocation listener : this.viewChangedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyBuddyGroupChange(BuddyGroup buddyGroup, boolean pre) {
        if (!this.buddyGroupChangedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setBuddyGroup(buddyGroup);
            e.setPre(pre);
            e.setType(Event.Type.BUDDY_GROUP_CHANGED);
            for (ListenerInvocation listener : this.buddyGroupChangedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyTransactionCompleted(Transaction transaction, boolean successful, InvocationContext ctx) {
        if (!this.transactionCompletedListeners.isEmpty()) {
            boolean isOriginLocal = ctx.isOriginLocal();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(isOriginLocal);
            e.setTransaction(transaction);
            e.setSuccessful(successful);
            e.setType(Event.Type.TRANSACTION_COMPLETED);
            for (ListenerInvocation listener : this.transactionCompletedListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyTransactionRegistered(Transaction transaction, InvocationContext ctx) {
        if (!this.transactionRegisteredListeners.isEmpty()) {
            boolean isOriginLocal = ctx.isOriginLocal();
            InvocationContext backup = this.resetInvocationContext(ctx);
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(isOriginLocal);
            e.setTransaction(transaction);
            e.setType(Event.Type.TRANSACTION_REGISTERED);
            for (ListenerInvocation listener : this.transactionRegisteredListeners) {
                listener.invoke(e);
            }
            this.restoreInvocationContext(backup);
        }
    }

    @Override
    public void notifyCacheBlocked(boolean pre) {
        if (!this.cacheBlockedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setType(Event.Type.CACHE_BLOCKED);
            for (ListenerInvocation listener : this.cacheBlockedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheUnblocked(boolean pre) {
        if (!this.cacheUnblockedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setType(Event.Type.CACHE_UNBLOCKED);
            for (ListenerInvocation listener : this.cacheUnblockedListeners) {
                listener.invoke(e);
            }
        }
    }

    private static Map copy(Map data, boolean useMarshalledValueMaps) {
        if (data == null) {
            return null;
        }
        if (data.isEmpty()) {
            return Collections.emptyMap();
        }
        if (NotifierImpl.safe(data)) {
            return useMarshalledValueMaps ? new MarshalledValueMap(data) : data;
        }
        MarshalledValueMap defensivelyCopiedData = Immutables.immutableMapCopy(data);
        return useMarshalledValueMaps ? new MarshalledValueMap(defensivelyCopiedData) : defensivelyCopiedData;
    }

    private void restoreInvocationContext(InvocationContext backup) {
        InvocationContext currentIC = this.cache.getInvocationContext();
        backup.putLookedUpNodes(currentIC.getLookedUpNodes());
        this.cache.setInvocationContext(backup);
    }

    private InvocationContext resetInvocationContext(InvocationContext ctx) {
        this.cache.setInvocationContext(null);
        InvocationContext newContext = this.cache.getInvocationContext();
        newContext.putLookedUpNodes(ctx.getLookedUpNodes());
        return ctx;
    }

    private static boolean safe(Map map) {
        return map == null || Immutables.isImmutable(map) || map.getClass().equals(emptyMap) || map.getClass().equals(singletonMap);
    }

    private List<ListenerInvocation> getListenerCollectionForAnnotation(Class<? extends Annotation> annotation) {
        List<ListenerInvocation> list = this.listenersMap.get(annotation);
        if (list == null) {
            throw new CacheException("Unknown listener annotation: " + annotation);
        }
        return list;
    }

    class ListenerInvocation {
        private final Object target;
        private final Method method;
        private final boolean sync;

        public ListenerInvocation(Object target, Method method, boolean sync) {
            this.target = target;
            this.method = method;
            this.sync = sync;
        }

        public void invoke(final Event e) {
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        ListenerInvocation.this.method.invoke(ListenerInvocation.this.target, e);
                    }
                    catch (InvocationTargetException exception) {
                        Throwable cause = exception.getCause();
                        if (cause != null) {
                            throw new CacheException("Caught exception invoking method " + ListenerInvocation.this.method + " on listener instance " + ListenerInvocation.this.target, cause);
                        }
                        throw new CacheException("Caught exception invoking method " + ListenerInvocation.this.method + " on listener instance " + ListenerInvocation.this.target, exception);
                    }
                    catch (IllegalAccessException exception) {
                        log.warn((Object)("Unable to invoke method " + ListenerInvocation.this.method + " on Object instance " + ListenerInvocation.this.target + " - removing this target object from list of listeners!"), (Throwable)exception);
                        NotifierImpl.this.removeCacheListener(ListenerInvocation.this.target);
                    }
                }
            };
            if (this.sync) {
                NotifierImpl.this.syncProcessor.execute(r);
            } else {
                NotifierImpl.this.asyncProcessor.execute(r);
            }
        }
    }
}

