/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.pojo.test;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Top level sample Pojo for a sample network management software. It is a logical object that can be presented to
 * the user. Example of domain is like temperature or vibration sensor domains.</p>
 * <p>This object is used to illustrate the pojo cache capability of PojoCache. Note the absence of <code>Serializable</code>
 * interface.</p>
 *
 * @author <a href="mailto:ben.wang@jboss.com">Ben Wang</a>
 */
// We are using JDK1.5 annotation.
@org.jboss.cache.pojo.annotation.Replicable
public class NetworkDomain
{
   String name_;
   // The associated nodes from the elements
   List<NetworkNode> nodes_;
   // All the elements to be managed in this domain
   List<NetworkElement> elements_;
   // Adminstration such id, pass
   NetworkAdmin admin_;

   static final int TEMP_SENSOR = 0;
   static final int VIBRATION_SENSOR = 1;

   public String getName()
   {
      return name_;
   }

   public void setName(String name)
   {
      name_ = name;
   }

   public List<NetworkNode> getNodes()
   {
      return nodes_;
   }

   protected void setNodes(List<NetworkNode> nodes)
   {
      nodes_ = nodes;
   }

   public List<NetworkNode> getElements()
   {
      return nodes_;
   }

   protected void addNode(NetworkNode node)
   {
      if (nodes_ == null)
         nodes_ = new ArrayList<NetworkNode>();

      nodes_.add(node);
   }

   public void addElement(NetworkElement element)
   {
      if (elements_ == null)
         elements_ = new ArrayList<NetworkElement>();

      elements_.add(element);

      if (element.getParentNode() == null)
         throw new RuntimeException("NetworkDomain.addElement(): parent node of element is null: " + element);

      addNode(element.getParentNode());
   }

   public NetworkAdmin getAdmin()
   {
      return admin_;
   }

   public void setAdmin(NetworkAdmin admin)
   {
      admin_ = admin;
   }

   public String toString()
   {
      StringBuffer sb = new StringBuffer();
      sb.append("* Damain * name= ").append(getName()).append(" + admin +: ").append(getAdmin());
      sb.append(" + nodes +: ").append(getNodes());
      return sb.toString();
   }
}
