/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javassist.CtClass;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.jboss.annotation.factory.javassist.AnnotationProxy;
import org.jboss.aop.AdviceType;
import org.jboss.aop.AnnotationIntroductionDef;
import org.jboss.aop.Aspect;
import org.jboss.aop.AspectAnnotationLoaderStrategy;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectManagerAnnotationLoaderStrategy;
import org.jboss.aop.Bind;
import org.jboss.aop.CFlowDef;
import org.jboss.aop.CFlowStackDef;
import org.jboss.aop.DeclareError;
import org.jboss.aop.DeclareWarning;
import org.jboss.aop.DynamicCFlowDef;
import org.jboss.aop.InterceptorDef;
import org.jboss.aop.Introduction;
import org.jboss.aop.Mixin;
import org.jboss.aop.PointcutDef;
import org.jboss.aop.Precedence;
import org.jboss.aop.PrecedenceAdvice;
import org.jboss.aop.PrecedenceInterceptor;
import org.jboss.aop.Prepare;
import org.jboss.aop.TypeDef;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.PrecedenceDefEntry;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.pointcut.DynamicCFlow;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.logging.AOPLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectAnnotationLoader {
    private static final AOPLogger logger = AOPLogger.getLogger(AspectAnnotationLoader.class);
    protected AspectManager manager;
    private ClassLoader cl;
    private final AspectAnnotationLoaderStrategy loaderStrategy;

    public AspectAnnotationLoader(AspectManager manager) {
        this.manager = manager;
        this.loaderStrategy = new AspectManagerAnnotationLoaderStrategy();
    }

    public AspectAnnotationLoader(AspectManager manager, AspectAnnotationLoaderStrategy loaderStrategy) {
        this.manager = manager;
        this.loaderStrategy = loaderStrategy;
    }

    public void setClassLoader(ClassLoader cl) {
        this.cl = cl;
    }

    public AspectManager getAspectManager() {
        return this.manager;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployInputStreamIterator(Iterator<InputStream> it) throws Exception {
        while (it.hasNext()) {
            InputStream stream = it.next();
            DataInputStream dstream = new DataInputStream(stream);
            ClassFile cf = null;
            try {
                cf = new ClassFile(dstream);
            }
            finally {
                dstream.close();
                stream.close();
            }
            this.deployClassFile(cf);
        }
    }

    public void deployClassFile(ClassFile cf) throws Exception {
        AnnotationsAttribute visible;
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug("Looking for aspects in: " + cf.getName());
        }
        if ((visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations")) != null) {
            boolean deployed = this.deployAspect(visible, cf);
            if (!deployed) {
                deployed = this.deployInterceptor(visible, cf);
            }
            if (!deployed) {
                this.deployDynamicCFlow(visible, cf);
                if (!this.deployPreparedClass(visible, cf)) {
                    this.deployPrecedence(visible, cf);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployInputStreamIterator(Iterator<InputStream> it) throws Exception {
        while (it.hasNext()) {
            InputStream stream = it.next();
            DataInputStream dstream = new DataInputStream(stream);
            ClassFile cf = null;
            try {
                cf = new ClassFile(dstream);
            }
            finally {
                dstream.close();
                stream.close();
            }
            this.undeployClassFile(cf);
        }
    }

    public void undeployClassFile(ClassFile cf) throws Exception {
        AnnotationsAttribute visible;
        if (AspectManager.verbose && logger.isDebugEnabled()) {
            logger.debug("Looking for aspects in: " + cf.getName());
        }
        if ((visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations")) != null) {
            this.undeployAspect(visible, cf);
            this.undeployInterceptor(visible, cf);
            this.undeployDynamicCFlow(visible, cf);
            this.undeployPreparedClass(visible, cf);
            this.undeployPrecedence(visible, cf);
            this.undeployPointcuts(cf);
            this.undeployMixins(cf);
            this.undeployIntroductions(cf);
            this.undeployTypedefs(cf);
            this.undeployCFlowStackDefs(cf);
            this.undeployPrepares(cf);
            this.undeployAnnotationIntroductions(cf);
            this.undeployDeclares(cf);
        }
    }

    private boolean deployAspect(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Aspect.class.getName());
        if (info != null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug("[debug] Found @Aspect in: " + cf.getName());
            }
            Aspect aspect = (Aspect)AnnotationProxy.createProxy((Annotation)info, Aspect.class);
            Scope scope = aspect.scope();
            String[] interfaces = cf.getInterfaces();
            boolean isFactory = false;
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].equals(AspectFactory.class.getName())) continue;
                isFactory = true;
                break;
            }
            this.loaderStrategy.deployAspect(this, isFactory, cf.getName(), scope);
            this.deployAspectOrInterceptorFields(cf);
            if (!isFactory) {
                this.deployAspectMethodBindings(cf, cf.getName());
            }
            return true;
        }
        return false;
    }

    private void undeployAspect(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Aspect.class.getName());
        if (info != null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug("Undeploying @Aspect in: " + cf.getName());
            }
            this.loaderStrategy.undeployAspect(this, cf.getName());
            this.undeployAspectMethodBindings(cf);
        }
    }

    private boolean deployInterceptor(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(InterceptorDef.class.getName());
        if (info != null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug("Found @InterceptorDef in: " + cf.getName());
            }
            Aspect aspect = (Aspect)AnnotationProxy.createProxy((Annotation)info, Aspect.class);
            Scope scope = aspect.scope();
            String[] interfaces = cf.getInterfaces();
            boolean isFactory = false;
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].equals(AspectFactory.class.getName())) {
                    isFactory = true;
                    break;
                }
                if (interfaces[i].equals(Interceptor.class.getName())) break;
            }
            this.loaderStrategy.deployInterceptor(this, isFactory, cf.getName(), scope);
            this.deployAspectOrInterceptorFields(cf);
            this.deployInterceptorBindings(visible, cf, cf.getName());
            return true;
        }
        return false;
    }

    private void undeployInterceptor(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(InterceptorDef.class.getName());
        if (info != null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug("Undeploying @InterceptorDef in: " + cf.getName());
            }
            AnnotationProxy.createProxy((Annotation)info, Aspect.class);
            this.loaderStrategy.undeployInterceptor(this, cf.getName());
            this.undeployInterceptorBindings(visible, cf);
        }
    }

    private void deployDynamicCFlow(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(DynamicCFlowDef.class.getName());
        if (info != null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug("Found @DynamicCFlowDef in: " + cf.getName());
            }
            AnnotationProxy.createProxy((Annotation)info, DynamicCFlowDef.class);
            String name = cf.getName();
            String clazz = cf.getName();
            String[] interfaces = cf.getInterfaces();
            boolean foundDCFlow = false;
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].equals(DynamicCFlow.class.getName())) continue;
                foundDCFlow = true;
                break;
            }
            if (!foundDCFlow) {
                throw new RuntimeException("@DynamicCFlow annotated class: " + clazz + " must implement " + DynamicCFlow.class.getName());
            }
            this.loaderStrategy.deployDynamicCFlow(this, clazz, name);
        }
    }

    private void undeployDynamicCFlow(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(DynamicCFlowDef.class.getName());
        if (info != null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug("Undeploying @DynamicCFlowDef in: " + cf.getName());
            }
            String name = cf.getName();
            this.loaderStrategy.undeployDynamicCFlow(this, name);
        }
    }

    private boolean deployPreparedClass(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Prepare.class.getName());
        if (info != null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug("Found top-level @Prepare in: " + cf.getName());
            }
            Prepare prepare = (Prepare)AnnotationProxy.createProxy((Annotation)info, Prepare.class);
            String name = cf.getName() + "." + visible.getName();
            String expr = AspectAnnotationLoader.replaceThisInExpr(prepare.value(), cf.getName());
            this.loaderStrategy.deployPointcut(this, name, expr);
            return true;
        }
        return false;
    }

    private void undeployPreparedClass(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Prepare.class.getName());
        if (info != null) {
            String name = cf.getName() + "." + visible.getName();
            this.loaderStrategy.undeployPointcut(this, name);
        }
    }

    private void deployPrecedence(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Precedence.class.getName());
        if (info != null) {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug("Found top-level @Precedence in: " + cf.getName());
            }
            ArrayList<PrecedenceDefEntry> entries = new ArrayList<PrecedenceDefEntry>();
            for (FieldInfo finfo : cf.getFields()) {
                AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
                if (mgroup == null) continue;
                Annotation binfo = mgroup.getAnnotation(PrecedenceInterceptor.class.getName());
                if (binfo != null) {
                    entries.add(new PrecedenceDefEntry(this.getFieldType(finfo), null));
                    continue;
                }
                binfo = mgroup.getAnnotation(PrecedenceAdvice.class.getName());
                if (binfo == null) continue;
                PrecedenceAdvice advice = (PrecedenceAdvice)AnnotationProxy.createProxy((Annotation)binfo, PrecedenceAdvice.class);
                String method = advice.value();
                entries.add(new PrecedenceDefEntry(this.getFieldType(finfo), method));
            }
            PrecedenceDefEntry[] pentries = entries.toArray(new PrecedenceDefEntry[entries.size()]);
            this.loaderStrategy.deployPrecedence(this, cf.getName(), pentries);
        }
    }

    private void undeployPrecedence(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation info = visible.getAnnotation(Precedence.class.getName());
        if (info != null) {
            this.loaderStrategy.undeployPrecedence(this, cf.getName());
        }
    }

    private void deployAspectMethodBindings(ClassFile cf, String aspectDefName) throws Exception {
        for (MethodInfo minfo : cf.getMethods()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(Bind.class.getName())) == null) continue;
            Bind binding = (Bind)AnnotationProxy.createProxy((Annotation)binfo, Bind.class);
            String pointcutString = AspectAnnotationLoader.replaceThisInExpr(binding.pointcut(), cf.getName());
            String cflow = AspectAnnotationLoader.replaceThisInExpr(binding.cflow(), cf.getName());
            if (cflow == null || cflow.trim().equals("")) {
                cflow = null;
            }
            ASTCFlowExpression cflowExpression = null;
            if (cflow != null) {
                cflowExpression = new PointcutExpressionParser(new StringReader(cflow)).CFlowExpression();
            }
            org.jboss.aop.advice.AdviceType internalAdviceType = this.getInternalAdviceType(binding.type());
            String bindingName = this.getAspectMethodBindingName(cf, minfo);
            this.loaderStrategy.deployAspectMethodBinding(this, internalAdviceType, aspectDefName, minfo.getName(), bindingName, pointcutString, cflow, cflowExpression);
        }
    }

    private org.jboss.aop.advice.AdviceType getInternalAdviceType(AdviceType adviceType) {
        if (adviceType == AdviceType.AROUND) {
            return org.jboss.aop.advice.AdviceType.AROUND;
        }
        if (adviceType == AdviceType.BEFORE) {
            return org.jboss.aop.advice.AdviceType.BEFORE;
        }
        if (adviceType == AdviceType.AFTER) {
            return org.jboss.aop.advice.AdviceType.AFTER;
        }
        if (adviceType == AdviceType.THROWING) {
            return org.jboss.aop.advice.AdviceType.THROWING;
        }
        if (adviceType == AdviceType.FINALLY) {
            return org.jboss.aop.advice.AdviceType.FINALLY;
        }
        throw new RuntimeException("Bad type " + (Object)((Object)adviceType));
    }

    private void undeployAspectMethodBindings(ClassFile cf) throws Exception {
        for (MethodInfo minfo : cf.getMethods()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(Bind.class.getName())) == null) continue;
            String bindingName = this.getAspectMethodBindingName(cf, minfo);
            this.loaderStrategy.undeployAspectMethodBinding(this, bindingName, cf.getName(), minfo.getName());
        }
    }

    private String getAspectMethodBindingName(ClassFile cf, MethodInfo minfo) throws Exception {
        String method = cf.getName() + "." + minfo.getName();
        String fullMethod = method + minfo.getDescriptor();
        return method + " " + MethodHashing.createHash(fullMethod);
    }

    private void deployInterceptorBindings(AnnotationsAttribute visible, ClassFile cf, String name) throws Exception {
        Annotation binfo = visible.getAnnotation(Bind.class.getName());
        if (binfo == null) {
            return;
        }
        Bind bind = (Bind)AnnotationProxy.createProxy((Annotation)binfo, Bind.class);
        String pointcutString = AspectAnnotationLoader.replaceThisInExpr(bind.pointcut(), cf.getName());
        String cflow = AspectAnnotationLoader.replaceThisInExpr(bind.cflow(), cf.getName());
        if (cflow == null || cflow.trim().equals("")) {
            cflow = null;
        }
        ASTCFlowExpression cflowExpression = null;
        if (cflow != null) {
            cflowExpression = new PointcutExpressionParser(new StringReader(cflow)).CFlowExpression();
        }
        this.loaderStrategy.deployInterceptorBinding(this, name, pointcutString, cflow, cflowExpression);
    }

    private void undeployInterceptorBindings(AnnotationsAttribute visible, ClassFile cf) throws Exception {
        Annotation binfo = visible.getAnnotation(Bind.class.getName());
        if (binfo == null) {
            return;
        }
        this.loaderStrategy.undeployInterceptorBinding(this, cf.getName());
    }

    private void deployPointcuts(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(PointcutDef.class.getName())) == null) continue;
            PointcutDef pdef = (PointcutDef)AnnotationProxy.createProxy((Annotation)binfo, PointcutDef.class);
            this.loaderStrategy.deployPointcut(this, this.getPointcutName(cf, finfo), pdef.value());
        }
    }

    private void undeployPointcuts(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(PointcutDef.class.getName())) == null) continue;
            this.loaderStrategy.undeployPointcut(this, this.getPointcutName(cf, finfo));
        }
    }

    private String getPointcutName(ClassFile cf, FieldInfo finfo) {
        return cf.getName() + "." + finfo.getName();
    }

    private void deployMixins(ClassFile cf) throws Exception {
        for (MethodInfo minfo : cf.getMethods()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(Mixin.class.getName())) == null) continue;
            MemberValue mv = binfo.getMemberValue("target");
            String target = mv != null ? ((ClassMemberValue)mv).getValue() : "java.lang.Class";
            mv = binfo.getMemberValue("typeExpression");
            String typeExpression = mv != null ? ((StringMemberValue)mv).getValue() : "";
            mv = binfo.getMemberValue("interfaces");
            MemberValue[] values = ((ArrayMemberValue)mv).getValue();
            String[] interfaces = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                interfaces[i] = ((ClassMemberValue)values[i]).getValue();
            }
            mv = binfo.getMemberValue("isTransient");
            boolean isTransient = mv != null ? ((BooleanMemberValue)mv).getValue() : true;
            String name = cf.getName() + "." + minfo.getName();
            AspectAnnotationLoaderStrategy.InterfaceIntroductionInfo intro = null;
            String construction = name;
            switch (Descriptor.numOfParameters((String)minfo.getDescriptor())) {
                case 0: {
                    construction = construction + "()";
                    intro = this.createIntroduction(name, target, typeExpression, null, null, null);
                    break;
                }
                case 1: {
                    construction = construction + "(this)";
                    intro = this.createIntroduction(name, target, typeExpression, null, cf.getName(), minfo.getName());
                    String parameter = Descriptor.getParamDescriptor((String)minfo.getDescriptor());
                    if (parameter.charAt(1) == 'L') break;
                    String errorMessage = "Mixin creator method '" + name + "' parameter is primitive type ";
                    char desc = parameter.charAt(1);
                    if (desc == ((CtPrimitiveType)CtClass.booleanType).getDescriptor()) {
                        errorMessage = errorMessage + "boolean";
                    } else if (desc == ((CtPrimitiveType)CtClass.byteType).getDescriptor()) {
                        errorMessage = errorMessage + "byte";
                    } else if (desc == ((CtPrimitiveType)CtClass.charType).getDescriptor()) {
                        errorMessage = errorMessage + "char";
                    } else if (desc == ((CtPrimitiveType)CtClass.doubleType).getDescriptor()) {
                        errorMessage = errorMessage + "double";
                    } else if (desc == ((CtPrimitiveType)CtClass.floatType).getDescriptor()) {
                        errorMessage = errorMessage + "float";
                    } else if (desc == ((CtPrimitiveType)CtClass.intType).getDescriptor()) {
                        errorMessage = errorMessage + "int";
                    } else if (desc == ((CtPrimitiveType)CtClass.longType).getDescriptor()) {
                        errorMessage = errorMessage + "long";
                    } else {
                        if (desc != ((CtPrimitiveType)CtClass.shortType).getDescriptor()) break;
                        errorMessage = errorMessage + "short";
                    }
                    errorMessage = errorMessage + ".\n   It should have the introduction target type as parameter, or have no parameter at all.";
                    throw new RuntimeException(errorMessage);
                }
                default: {
                    throw new RuntimeException("Mixin creator method '" + name + "' should not have more than one parameter.");
                }
            }
            if (!Modifier.isStatic((int)minfo.getAccessFlags()) || !Modifier.isPublic((int)minfo.getAccessFlags())) {
                throw new RuntimeException("Mixin creator method '" + name + "' must be public and static.");
            }
            String classname = this.getReturnType(minfo);
            intro.addMixin(new AspectAnnotationLoaderStrategy.InterfaceIntroductionMixinInfo(classname, interfaces, construction, isTransient));
            this.loaderStrategy.deployInterfaceIntroduction(this, intro);
        }
    }

    private void undeployMixins(ClassFile cf) throws Exception {
        for (MethodInfo minfo : cf.getMethods()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(Mixin.class.getName())) == null) continue;
            String name = cf.getName() + "." + minfo.getName();
            this.loaderStrategy.undeployInterfaceIntroduction(this, name);
        }
    }

    private void deployIntroductions(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(Introduction.class.getName())) == null) continue;
            MemberValue mv = binfo.getMemberValue("target");
            String target = mv != null ? ((ClassMemberValue)mv).getValue() : "java.lang.Class";
            mv = binfo.getMemberValue("typeExpression");
            String typeExpression = mv != null ? ((StringMemberValue)mv).getValue() : "";
            mv = binfo.getMemberValue("interfaces");
            MemberValue[] values = ((ArrayMemberValue)mv).getValue();
            String[] interfaces = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                interfaces[i] = ((ClassMemberValue)values[i]).getValue();
            }
            String name = cf.getName() + "." + finfo.getName();
            AspectAnnotationLoaderStrategy.InterfaceIntroductionInfo interfaceIntro = this.createIntroduction(name, target, typeExpression, interfaces, null, null);
            this.loaderStrategy.deployInterfaceIntroduction(this, interfaceIntro);
        }
    }

    private void undeployIntroductions(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(Introduction.class.getName())) == null) continue;
            String name = cf.getName() + "." + finfo.getName();
            this.loaderStrategy.undeployInterfaceIntroduction(this, name);
        }
    }

    private void deployTypedefs(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(TypeDef.class.getName())) == null) continue;
            TypeDef typeDefinition = (TypeDef)AnnotationProxy.createProxy((Annotation)binfo, TypeDef.class);
            String name = this.getTypedefName(cf, finfo);
            String expr = typeDefinition.value();
            this.loaderStrategy.deployTypedef(this, name, expr);
        }
    }

    private void undeployTypedefs(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(TypeDef.class.getName())) == null) continue;
            AnnotationProxy.createProxy((Annotation)binfo, TypeDef.class);
            this.loaderStrategy.undeployTypedef(this, this.getTypedefName(cf, finfo));
        }
    }

    private String getTypedefName(ClassFile cf, FieldInfo finfo) {
        return cf.getName() + "." + finfo.getName();
    }

    private void deployCFlowStackDefs(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(CFlowStackDef.class.getName())) == null) continue;
            CFlowStackDef stackDef = (CFlowStackDef)AnnotationProxy.createProxy((Annotation)binfo, CFlowStackDef.class);
            String name = this.getStackDefName(cf, finfo);
            CFlowDef[] cflows = stackDef.cflows();
            AspectAnnotationLoaderStrategy.CFlowStackInfo stack = new AspectAnnotationLoaderStrategy.CFlowStackInfo(name);
            for (int i = 0; i < cflows.length; ++i) {
                CFlowDef cflow = cflows[i];
                boolean not = !cflow.called();
                stack.addCFlow(new AspectAnnotationLoaderStrategy.CFlowInfo(cflow.expr(), not));
            }
            this.loaderStrategy.deployCFlow(this, stack);
        }
    }

    private void undeployCFlowStackDefs(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(CFlowStackDef.class.getName())) == null) continue;
            AnnotationProxy.createProxy((Annotation)binfo, CFlowStackDef.class);
            this.loaderStrategy.undeployCFlow(this, this.getStackDefName(cf, finfo));
        }
    }

    private String getStackDefName(ClassFile cf, FieldInfo finfo) {
        return cf.getName() + "." + finfo.getName();
    }

    private void deployPrepares(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(Prepare.class.getName())) == null) continue;
            Prepare prepare = (Prepare)AnnotationProxy.createProxy((Annotation)binfo, Prepare.class);
            String name = this.getPrepareName(cf, finfo);
            String expr = prepare.value();
            this.loaderStrategy.deployPointcut(this, name, expr);
        }
    }

    private void undeployPrepares(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(Prepare.class.getName())) == null) continue;
            AnnotationProxy.createProxy((Annotation)binfo, Prepare.class);
            this.loaderStrategy.undeployPointcut(this, this.getPrepareName(cf, finfo));
        }
    }

    private String getPrepareName(ClassFile cf, FieldInfo finfo) {
        return cf.getName() + "." + finfo.getName();
    }

    private void deployAnnotationIntroductions(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(AnnotationIntroductionDef.class.getName())) == null) continue;
            AnnotationIntroductionDef intro = (AnnotationIntroductionDef)AnnotationProxy.createProxy((Annotation)binfo, AnnotationIntroductionDef.class);
            String expr = intro.expr();
            boolean invisible = intro.invisible();
            String annotation = intro.annotation();
            annotation = annotation.replace('\'', '\"');
            this.loaderStrategy.deployAnnotationIntroduction(this, expr, annotation, invisible);
        }
    }

    private void undeployAnnotationIntroductions(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            Annotation binfo;
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null || (binfo = mgroup.getAnnotation(AnnotationIntroductionDef.class.getName())) == null) continue;
            AnnotationIntroductionDef intro = (AnnotationIntroductionDef)AnnotationProxy.createProxy((Annotation)binfo, AnnotationIntroductionDef.class);
            String expr = intro.expr();
            boolean invisible = intro.invisible();
            String annotation = intro.annotation();
            annotation = annotation.replace('\'', '\"');
            this.loaderStrategy.undeployAnnotationIntroduction(this, expr, annotation, invisible);
        }
    }

    private void deployDeclares(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null) continue;
            Annotation dwinfo = mgroup.getAnnotation(DeclareWarning.class.getName());
            Annotation deinfo = mgroup.getAnnotation(DeclareError.class.getName());
            if (dwinfo == null && deinfo == null) continue;
            String name = this.getDeclareName(cf, finfo);
            if (dwinfo != null && deinfo != null) {
                throw new RuntimeException("Cannot annotate " + name + " field with both DeclareError and DeclareWarning");
            }
            String expr = null;
            String msg = null;
            boolean warning = false;
            if (deinfo != null) {
                DeclareError derror = (DeclareError)AnnotationProxy.createProxy((Annotation)deinfo, DeclareError.class);
                expr = derror.expr();
                msg = derror.msg();
            } else {
                DeclareWarning dwarning = (DeclareWarning)AnnotationProxy.createProxy((Annotation)dwinfo, DeclareWarning.class);
                expr = dwarning.expr();
                msg = dwarning.msg();
                warning = true;
            }
            this.loaderStrategy.deployDeclare(this, name, expr, warning, msg);
        }
    }

    private void undeployDeclares(ClassFile cf) throws Exception {
        for (FieldInfo finfo : cf.getFields()) {
            AnnotationsAttribute mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
            if (mgroup == null) continue;
            Annotation dwinfo = mgroup.getAnnotation(DeclareWarning.class.getName());
            Annotation deinfo = mgroup.getAnnotation(DeclareError.class.getName());
            if (dwinfo == null && deinfo == null) continue;
            String name = this.getDeclareName(cf, finfo);
            this.loaderStrategy.undeployDeclare(this, name);
        }
    }

    private String getDeclareName(ClassFile cf, FieldInfo finfo) {
        return cf.getName() + "." + finfo.getName();
    }

    private AspectAnnotationLoaderStrategy.InterfaceIntroductionInfo createIntroduction(String name, String target, String typeExpression, String[] interfaces, String constructorClass, String constructorMethod) throws Exception {
        if (typeExpression != null && typeExpression.trim().equals("")) {
            typeExpression = null;
        }
        if (typeExpression != null && target != null && target.equals("java.lang.Class")) {
            target = null;
        }
        if (target == null && typeExpression == null) {
            throw new RuntimeException("No target nor a typeExpression attribute is defined for this @Mixin");
        }
        if (target == null && typeExpression == null) {
            throw new RuntimeException("You cannot define both a target and typeExpression attribute in the same @Mixin");
        }
        AspectAnnotationLoaderStrategy.InterfaceIntroductionInfo intro = new AspectAnnotationLoaderStrategy.InterfaceIntroductionInfo(name, interfaces, target, typeExpression, constructorClass, constructorMethod);
        return intro;
    }

    private String getReturnType(MethodInfo minfo) {
        String descriptor = minfo.getDescriptor();
        int paramsEnd = descriptor.indexOf(")");
        String classname = descriptor.substring(paramsEnd + 2, descriptor.length() - 1);
        classname = classname.replace('/', '.');
        return classname;
    }

    private String getFieldType(FieldInfo finfo) {
        String descriptor = finfo.getDescriptor();
        String classname = descriptor.substring(1, descriptor.length() - 1);
        classname = classname.replace('/', '.');
        return classname;
    }

    private static String replaceThisInExpr(String expr, String classname) {
        String THIS = "this";
        StringBuffer buf = new StringBuffer();
        int index = expr.indexOf("this");
        if (index == -1) {
            return expr;
        }
        int lastindex = 0;
        while (index != -1) {
            boolean isPartOfWord = false;
            if (index > 0) {
                char before = expr.charAt(index - 1);
                isPartOfWord = Character.isJavaIdentifierPart(before);
            }
            if (!isPartOfWord && index + "this".length() < expr.length() - 1) {
                char after = expr.charAt(index + "this".length());
                isPartOfWord = Character.isJavaIdentifierPart(after);
            }
            buf.append(expr.substring(lastindex, index));
            if (isPartOfWord) {
                buf.append("this");
            } else {
                buf.append(classname);
            }
            lastindex = index + "this".length();
            index = expr.indexOf("this", lastindex);
        }
        buf.append(expr.substring(lastindex));
        return buf.toString();
    }

    private void deployAspectOrInterceptorFields(ClassFile cf) throws Exception {
        this.deployPointcuts(cf);
        this.deployMixins(cf);
        this.deployIntroductions(cf);
        this.deployTypedefs(cf);
        this.deployCFlowStackDefs(cf);
        this.deployPrepares(cf);
        this.deployAnnotationIntroductions(cf);
        this.deployDeclares(cf);
    }
}

