/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.aop.util.logging.SystemOutLoggerPlugin;
import org.jboss.logging.Logger;
import org.jboss.logging.NullLoggerPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOPLogger {
    private static final ConcurrentMap<Class<?>, AOPLogger> loggers = new ConcurrentHashMap();
    private final Logger logger;

    public static AOPLogger getLogger(Class<?> clazz) {
        AOPLogger oldLogger;
        AOPLogger logger = (AOPLogger)loggers.get(clazz);
        if (logger == null && (oldLogger = loggers.putIfAbsent(clazz, logger = new AOPLogger(clazz))) != null) {
            logger = oldLogger;
        }
        return logger;
    }

    private AOPLogger(Class<?> clazz) {
        Logger log = Logger.getLogger(clazz);
        if (log.getLoggerPlugin().getClass().getName().equals(NullLoggerPlugin.class.getName())) {
            Logger.setPluginClassName((String)SystemOutLoggerPlugin.class.getName());
            log = Logger.getLogger(clazz);
        }
        this.logger = log;
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void fatal(Object message) {
        this.logger.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.logger.fatal(message, t);
    }

    public void error(Object message) {
        this.logger.error(message);
    }

    public void error(Object message, Throwable t) {
        this.logger.error(message, t);
    }

    public void warn(Object message) {
        this.logger.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.logger.warn(message, t);
    }

    public void info(Object message) {
        this.logger.info(message);
    }

    public void info(Object message, Throwable t) {
        this.logger.info(message, t);
    }

    public void debug(Object message) {
        this.logger.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.logger.debug(message, t);
    }

    public void trace(Object message) {
        this.logger.trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.logger.trace(message, t);
    }
}

